/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorDeActivator;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureManager;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRequestDecider;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.Checkpoints;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.checkpoint.OperatorCoordinatorCheckpointContext;
import org.apache.flink.runtime.checkpoint.OperatorCoordinatorCheckpoints;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.PendingCheckpoint;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.apache.flink.runtime.checkpoint.StateAssignmentOperation;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.hooks.MasterHooks;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.runtime.operators.coordination.OperatorInfo;
import org.apache.flink.runtime.state.CheckpointStorageCoordinatorView;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryFactory;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointCoordinator.class);
    private static final int NUM_GHOST_CHECKPOINT_IDS = 16;
    private final Object lock = new Object();
    private final JobID job;
    private final CheckpointProperties checkpointProperties;
    private final Executor executor;
    private final CheckpointsCleaner checkpointsCleaner;
    private final ExecutionVertex[] tasksToTrigger;
    private final ExecutionVertex[] tasksToWaitFor;
    private final ExecutionVertex[] tasksToCommitTo;
    private final Collection<OperatorCoordinatorCheckpointContext> coordinatorsToCheckpoint;
    @GuardedBy(value="lock")
    private final Map<Long, PendingCheckpoint> pendingCheckpoints;
    private final CompletedCheckpointStore completedCheckpointStore;
    private final CheckpointStorageCoordinatorView checkpointStorage;
    private final ArrayDeque<Long> recentPendingCheckpoints;
    private final CheckpointIDCounter checkpointIdCounter;
    private final long baseInterval;
    private final long checkpointTimeout;
    private final long minPauseBetweenCheckpoints;
    private final ScheduledExecutor timer;
    private final HashMap<String, MasterTriggerRestoreHook<?>> masterHooks;
    private final boolean unalignedCheckpointsEnabled;
    private final long alignmentTimeout;
    private JobStatusListener jobStatusListener;
    private final AtomicInteger numUnsuccessfulCheckpointsTriggers = new AtomicInteger(0);
    private ScheduledFuture<?> currentPeriodicTrigger;
    private long lastCheckpointCompletionRelativeTime;
    private boolean periodicScheduling;
    private volatile boolean shutdown;
    @Nullable
    private CheckpointStatsTracker statsTracker;
    private final SharedStateRegistryFactory sharedStateRegistryFactory;
    private SharedStateRegistry sharedStateRegistry;
    private boolean isPreferCheckpointForRecovery;
    private final CheckpointFailureManager failureManager;
    private final Clock clock;
    private final boolean isExactlyOnceMode;
    private boolean isTriggering = false;
    private final CheckpointRequestDecider requestDecider;

    public CheckpointCoordinator(JobID job, CheckpointCoordinatorConfiguration chkConfig, ExecutionVertex[] tasksToTrigger, ExecutionVertex[] tasksToWaitFor, ExecutionVertex[] tasksToCommitTo, Collection<OperatorCoordinatorCheckpointContext> coordinatorsToCheckpoint, CheckpointIDCounter checkpointIDCounter, CompletedCheckpointStore completedCheckpointStore, StateBackend checkpointStateBackend, Executor executor, CheckpointsCleaner checkpointsCleaner, ScheduledExecutor timer, SharedStateRegistryFactory sharedStateRegistryFactory, CheckpointFailureManager failureManager) {
        this(job, chkConfig, tasksToTrigger, tasksToWaitFor, tasksToCommitTo, coordinatorsToCheckpoint, checkpointIDCounter, completedCheckpointStore, checkpointStateBackend, executor, checkpointsCleaner, timer, sharedStateRegistryFactory, failureManager, (Clock)SystemClock.getInstance());
    }

    @VisibleForTesting
    public CheckpointCoordinator(JobID job, CheckpointCoordinatorConfiguration chkConfig, ExecutionVertex[] tasksToTrigger, ExecutionVertex[] tasksToWaitFor, ExecutionVertex[] tasksToCommitTo, Collection<OperatorCoordinatorCheckpointContext> coordinatorsToCheckpoint, CheckpointIDCounter checkpointIDCounter, CompletedCheckpointStore completedCheckpointStore, StateBackend checkpointStateBackend, Executor executor, CheckpointsCleaner checkpointsCleaner, ScheduledExecutor timer, SharedStateRegistryFactory sharedStateRegistryFactory, CheckpointFailureManager failureManager, Clock clock) {
        long baseInterval;
        Preconditions.checkNotNull((Object)checkpointStateBackend);
        long minPauseBetweenCheckpoints = chkConfig.getMinPauseBetweenCheckpoints();
        if (minPauseBetweenCheckpoints > 31536000000L) {
            minPauseBetweenCheckpoints = 31536000000L;
        }
        if ((baseInterval = chkConfig.getCheckpointInterval()) < minPauseBetweenCheckpoints) {
            baseInterval = minPauseBetweenCheckpoints;
        }
        this.job = (JobID)Preconditions.checkNotNull((Object)job);
        this.baseInterval = baseInterval;
        this.checkpointTimeout = chkConfig.getCheckpointTimeout();
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        this.tasksToTrigger = (ExecutionVertex[])Preconditions.checkNotNull((Object)tasksToTrigger);
        this.tasksToWaitFor = (ExecutionVertex[])Preconditions.checkNotNull((Object)tasksToWaitFor);
        this.tasksToCommitTo = (ExecutionVertex[])Preconditions.checkNotNull((Object)tasksToCommitTo);
        this.coordinatorsToCheckpoint = Collections.unmodifiableCollection(coordinatorsToCheckpoint);
        this.pendingCheckpoints = new LinkedHashMap<Long, PendingCheckpoint>();
        this.checkpointIdCounter = (CheckpointIDCounter)Preconditions.checkNotNull((Object)checkpointIDCounter);
        this.completedCheckpointStore = (CompletedCheckpointStore)Preconditions.checkNotNull((Object)completedCheckpointStore);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.checkpointsCleaner = (CheckpointsCleaner)Preconditions.checkNotNull((Object)checkpointsCleaner);
        this.sharedStateRegistryFactory = (SharedStateRegistryFactory)Preconditions.checkNotNull((Object)sharedStateRegistryFactory);
        this.sharedStateRegistry = sharedStateRegistryFactory.create(executor);
        this.isPreferCheckpointForRecovery = chkConfig.isPreferCheckpointForRecovery();
        this.failureManager = (CheckpointFailureManager)Preconditions.checkNotNull((Object)failureManager);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.isExactlyOnceMode = chkConfig.isExactlyOnce();
        this.unalignedCheckpointsEnabled = chkConfig.isUnalignedCheckpointsEnabled();
        this.alignmentTimeout = chkConfig.getAlignmentTimeout();
        this.recentPendingCheckpoints = new ArrayDeque(16);
        this.masterHooks = new HashMap();
        this.timer = timer;
        this.checkpointProperties = CheckpointProperties.forCheckpoint(chkConfig.getCheckpointRetentionPolicy());
        try {
            this.checkpointStorage = checkpointStateBackend.createCheckpointStorage(job);
            this.checkpointStorage.initializeBaseLocations();
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Failed to create checkpoint storage at checkpoint coordinator side.", (Throwable)e);
        }
        try {
            checkpointIDCounter.start();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to start checkpoint ID counter: " + t.getMessage(), t);
        }
        this.requestDecider = new CheckpointRequestDecider(chkConfig.getMaxConcurrentCheckpoints(), this::rescheduleTrigger, this.clock, this.minPauseBetweenCheckpoints, this.pendingCheckpoints::size, this.checkpointsCleaner::getNumberOfCheckpointsToClean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMasterHook(MasterTriggerRestoreHook<?> hook) {
        Preconditions.checkNotNull(hook);
        String id = hook.getIdentifier();
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)id) ? 1 : 0) != 0, (Object)"The hook has a null or empty id");
        Object object = this.lock;
        synchronized (object) {
            if (!this.masterHooks.containsKey(id)) {
                this.masterHooks.put(id, hook);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfRegisteredMasterHooks() {
        Object object = this.lock;
        synchronized (object) {
            return this.masterHooks.size();
        }
    }

    public void setCheckpointStatsTracker(@Nullable CheckpointStatsTracker statsTracker) {
        this.statsTracker = statsTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(JobStatus jobStatus) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                LOG.info("Stopping checkpoint coordinator for job {}.", (Object)this.job);
                this.periodicScheduling = false;
                MasterHooks.close(this.masterHooks.values(), LOG);
                this.masterHooks.clear();
                CheckpointException reason = new CheckpointException(CheckpointFailureReason.CHECKPOINT_COORDINATOR_SHUTDOWN);
                this.abortPendingAndQueuedCheckpoints(reason);
                this.completedCheckpointStore.shutdown(jobStatus, this.checkpointsCleaner, () -> {});
                this.checkpointIdCounter.shutdown(jobStatus);
            }
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public CompletableFuture<CompletedCheckpoint> triggerSavepoint(@Nullable String targetLocation) {
        CheckpointProperties properties = CheckpointProperties.forSavepoint(!this.unalignedCheckpointsEnabled);
        return this.triggerSavepointInternal(properties, targetLocation);
    }

    public CompletableFuture<CompletedCheckpoint> triggerSynchronousSavepoint(boolean terminate, @Nullable String targetLocation) {
        CheckpointProperties properties = CheckpointProperties.forSyncSavepoint(!this.unalignedCheckpointsEnabled, terminate);
        return this.triggerSavepointInternal(properties, targetLocation);
    }

    private CompletableFuture<CompletedCheckpoint> triggerSavepointInternal(CheckpointProperties checkpointProperties, @Nullable String targetLocation) {
        Preconditions.checkNotNull((Object)checkpointProperties);
        CompletableFuture<CompletedCheckpoint> resultFuture = new CompletableFuture<CompletedCheckpoint>();
        this.timer.execute(() -> this.triggerCheckpoint(checkpointProperties, targetLocation, false).whenComplete((completedCheckpoint, throwable) -> {
            if (throwable == null) {
                resultFuture.complete((CompletedCheckpoint)completedCheckpoint);
            } else {
                resultFuture.completeExceptionally((Throwable)throwable);
            }
        }));
        return resultFuture;
    }

    public CompletableFuture<CompletedCheckpoint> triggerCheckpoint(boolean isPeriodic) {
        return this.triggerCheckpoint(this.checkpointProperties, null, isPeriodic);
    }

    @VisibleForTesting
    public CompletableFuture<CompletedCheckpoint> triggerCheckpoint(CheckpointProperties props, @Nullable String externalSavepointLocation, boolean isPeriodic) {
        if (!(props.getCheckpointType().getPostCheckpointAction() != CheckpointType.PostCheckpointAction.TERMINATE || props.isSynchronous() && props.isSavepoint())) {
            return FutureUtils.completedExceptionally(new IllegalArgumentException("Only synchronous savepoints are allowed to advance the watermark to MAX."));
        }
        CheckpointTriggerRequest request = new CheckpointTriggerRequest(props, externalSavepointLocation, isPeriodic);
        this.chooseRequestToExecute(request).ifPresent(this::startTriggeringCheckpoint);
        return request.onCompletionPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTriggeringCheckpoint(CheckpointTriggerRequest request) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.preCheckGlobalState(request.isPeriodic);
            }
            Execution[] executions = this.getTriggerExecutions();
            Map<ExecutionAttemptID, ExecutionVertex> ackTasks = this.getAckTasks();
            Preconditions.checkState((!this.isTriggering ? 1 : 0) != 0);
            this.isTriggering = true;
            long timestamp = System.currentTimeMillis();
            CompletionStage pendingCheckpointCompletableFuture = this.initializeCheckpoint(request.props, request.externalSavepointLocation).thenApplyAsync(checkpointIdAndStorageLocation -> this.createPendingCheckpoint(timestamp, request.props, ackTasks, request.isPeriodic, ((CheckpointIdAndStorageLocation)checkpointIdAndStorageLocation).checkpointId, ((CheckpointIdAndStorageLocation)checkpointIdAndStorageLocation).checkpointStorageLocation, request.getOnCompletionFuture()), (Executor)this.timer);
            CompletionStage coordinatorCheckpointsComplete = ((CompletableFuture)pendingCheckpointCompletableFuture).thenComposeAsync(pendingCheckpoint -> OperatorCoordinatorCheckpoints.triggerAndAcknowledgeAllCoordinatorCheckpointsWithCompletion(this.coordinatorsToCheckpoint, pendingCheckpoint, this.timer), (Executor)this.timer);
            CompletionStage masterStatesComplete = ((CompletableFuture)coordinatorCheckpointsComplete).thenComposeAsync(arg_0 -> this.lambda$startTriggeringCheckpoint$5((CompletableFuture)pendingCheckpointCompletableFuture, arg_0), (Executor)this.timer);
            FutureUtils.assertNoException(((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{masterStatesComplete, coordinatorCheckpointsComplete}).handleAsync((arg_0, arg_1) -> this.lambda$startTriggeringCheckpoint$7((CompletableFuture)pendingCheckpointCompletableFuture, request, timestamp, executions, arg_0, arg_1), (Executor)this.timer)).exceptionally(error -> {
                if (!this.isShutdown()) {
                    throw new CompletionException((Throwable)error);
                }
                if (ExceptionUtils.findThrowable((Throwable)error, RejectedExecutionException.class).isPresent()) {
                    LOG.debug("Execution rejected during shutdown");
                } else {
                    LOG.warn("Error encountered during shutdown", error);
                }
                return null;
            }));
        }
        catch (Throwable throwable) {
            this.onTriggerFailure(request, throwable);
        }
    }

    private CompletableFuture<CheckpointIdAndStorageLocation> initializeCheckpoint(CheckpointProperties props, @Nullable String externalSavepointLocation) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                long checkpointID = this.checkpointIdCounter.getAndIncrement();
                CheckpointStorageLocation checkpointStorageLocation = props.isSavepoint() ? this.checkpointStorage.initializeLocationForSavepoint(checkpointID, externalSavepointLocation) : this.checkpointStorage.initializeLocationForCheckpoint(checkpointID);
                return new CheckpointIdAndStorageLocation(checkpointID, checkpointStorageLocation);
            }
            catch (Throwable throwable) {
                throw new CompletionException(throwable);
            }
        }, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingCheckpoint createPendingCheckpoint(long timestamp, CheckpointProperties props, Map<ExecutionAttemptID, ExecutionVertex> ackTasks, boolean isPeriodic, long checkpointID, CheckpointStorageLocation checkpointStorageLocation, CompletableFuture<CompletedCheckpoint> onCompletionPromise) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.preCheckGlobalState(isPeriodic);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        }
        PendingCheckpoint checkpoint = new PendingCheckpoint(this.job, checkpointID, timestamp, ackTasks, OperatorInfo.getIds(this.coordinatorsToCheckpoint), this.masterHooks.keySet(), props, checkpointStorageLocation, onCompletionPromise);
        if (this.statsTracker != null) {
            PendingCheckpointStats callback = this.statsTracker.reportPendingCheckpoint(checkpointID, timestamp, props);
            checkpoint.setStatsCallback(callback);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.pendingCheckpoints.put(checkpointID, checkpoint);
            ScheduledFuture<?> cancellerHandle = this.timer.schedule(new CheckpointCanceller(checkpoint), this.checkpointTimeout, TimeUnit.MILLISECONDS);
            if (!checkpoint.setCancellerHandle(cancellerHandle)) {
                cancellerHandle.cancel(false);
            }
        }
        LOG.info("Triggering checkpoint {} (type={}) @ {} for job {}.", new Object[]{checkpointID, checkpoint.getProps().getCheckpointType(), timestamp, this.job});
        return checkpoint;
    }

    private CompletableFuture<Void> snapshotMasterState(PendingCheckpoint checkpoint) {
        if (this.masterHooks.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        long checkpointID = checkpoint.getCheckpointId();
        long timestamp = checkpoint.getCheckpointTimestamp();
        CompletableFuture<Void> masterStateCompletableFuture = new CompletableFuture<Void>();
        for (MasterTriggerRestoreHook<?> masterHook : this.masterHooks.values()) {
            MasterHooks.triggerHook(masterHook, checkpointID, timestamp, this.executor).whenCompleteAsync((masterState, throwable) -> {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        if (masterStateCompletableFuture.isDone()) {
                            return;
                        }
                        if (checkpoint.isDisposed()) {
                            throw new IllegalStateException("Checkpoint " + checkpointID + " has been discarded");
                        }
                        if (throwable == null) {
                            checkpoint.acknowledgeMasterState(masterHook.getIdentifier(), (MasterState)masterState);
                            if (checkpoint.areMasterStatesFullyAcknowledged()) {
                                masterStateCompletableFuture.complete(null);
                            }
                        } else {
                            masterStateCompletableFuture.completeExceptionally((Throwable)throwable);
                        }
                    }
                }
                catch (Throwable t) {
                    masterStateCompletableFuture.completeExceptionally(t);
                }
            }, (Executor)this.timer);
        }
        return masterStateCompletableFuture;
    }

    private void snapshotTaskState(long timestamp, long checkpointID, CheckpointStorageLocation checkpointStorageLocation, CheckpointProperties props, Execution[] executions) {
        CheckpointOptions checkpointOptions = CheckpointOptions.create(props.getCheckpointType(), checkpointStorageLocation.getLocationReference(), this.isExactlyOnceMode, this.unalignedCheckpointsEnabled, this.alignmentTimeout);
        for (Execution execution : executions) {
            if (props.isSynchronous()) {
                execution.triggerSynchronousSavepoint(checkpointID, timestamp, checkpointOptions);
                continue;
            }
            execution.triggerCheckpoint(checkpointID, timestamp, checkpointOptions);
        }
    }

    private void onTriggerSuccess() {
        this.isTriggering = false;
        this.numUnsuccessfulCheckpointsTriggers.set(0);
        this.executeQueuedRequest();
    }

    private void onTriggerFailure(CheckpointTriggerRequest onCompletionPromise, Throwable throwable) {
        CheckpointException checkpointException = CheckpointCoordinator.getCheckpointException(CheckpointFailureReason.TRIGGER_CHECKPOINT_FAILURE, throwable);
        onCompletionPromise.completeExceptionally(checkpointException);
        this.onTriggerFailure((PendingCheckpoint)null, (Throwable)checkpointException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTriggerFailure(@Nullable PendingCheckpoint checkpoint, Throwable throwable) {
        block6: {
            throwable = ExceptionUtils.stripCompletionException((Throwable)throwable);
            try {
                this.coordinatorsToCheckpoint.forEach(OperatorCoordinatorCheckpointContext::abortCurrentTriggering);
                if (checkpoint == null || checkpoint.isDisposed()) break block6;
                int numUnsuccessful = this.numUnsuccessfulCheckpointsTriggers.incrementAndGet();
                LOG.warn("Failed to trigger checkpoint {} for job {}. ({} consecutive failed attempts so far)", new Object[]{checkpoint.getCheckpointId(), this.job, numUnsuccessful, throwable});
                CheckpointException cause = CheckpointCoordinator.getCheckpointException(CheckpointFailureReason.TRIGGER_CHECKPOINT_FAILURE, throwable);
                Object object = this.lock;
                synchronized (object) {
                    this.abortPendingCheckpoint(checkpoint, cause);
                }
            }
            finally {
                this.isTriggering = false;
                this.executeQueuedRequest();
            }
        }
    }

    private void executeQueuedRequest() {
        this.chooseQueuedRequestToExecute().ifPresent(this::startTriggeringCheckpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CheckpointTriggerRequest> chooseQueuedRequestToExecute() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestDecider.chooseQueuedRequestToExecute(this.isTriggering, this.lastCheckpointCompletionRelativeTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CheckpointTriggerRequest> chooseRequestToExecute(CheckpointTriggerRequest request) {
        Object object = this.lock;
        synchronized (object) {
            return this.requestDecider.chooseRequestToExecute(request, this.isTriggering, this.lastCheckpointCompletionRelativeTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeCompleteCheckpoint(PendingCheckpoint checkpoint) {
        Object object = this.lock;
        synchronized (object) {
            if (checkpoint.isFullyAcknowledged()) {
                try {
                    if (this.shutdown) {
                        return false;
                    }
                    this.completePendingCheckpoint(checkpoint);
                }
                catch (CheckpointException ce) {
                    this.onTriggerFailure(checkpoint, (Throwable)ce);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveDeclineMessage(DeclineCheckpoint message, String taskManagerLocationInfo) {
        if (this.shutdown || message == null) {
            return;
        }
        if (!this.job.equals((Object)message.getJob())) {
            throw new IllegalArgumentException("Received DeclineCheckpoint message for job " + message.getJob() + " from " + taskManagerLocationInfo + " while this coordinator handles job " + this.job);
        }
        long checkpointId = message.getCheckpointId();
        CheckpointException checkpointException = message.getSerializedCheckpointException().unwrap();
        String reason = checkpointException.getMessage();
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            PendingCheckpoint checkpoint = this.pendingCheckpoints.get(checkpointId);
            if (checkpoint != null) {
                Preconditions.checkState((!checkpoint.isDisposed() ? 1 : 0) != 0, (Object)("Received message for discarded but non-removed checkpoint " + checkpointId));
                LOG.info("Decline checkpoint {} by task {} of job {} at {}.", new Object[]{checkpointId, message.getTaskExecutionId(), this.job, taskManagerLocationInfo, checkpointException.getCause()});
                this.abortPendingCheckpoint(checkpoint, checkpointException, message.getTaskExecutionId());
            } else if (LOG.isDebugEnabled()) {
                if (this.recentPendingCheckpoints.contains(checkpointId)) {
                    LOG.debug("Received another decline message for now expired checkpoint attempt {} from task {} of job {} at {} : {}", new Object[]{checkpointId, message.getTaskExecutionId(), this.job, taskManagerLocationInfo, reason});
                } else {
                    LOG.debug("Received decline message for unknown (too old?) checkpoint attempt {} from task {} of job {} at {} : {}", new Object[]{checkpointId, message.getTaskExecutionId(), this.job, taskManagerLocationInfo, reason});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receiveAcknowledgeMessage(AcknowledgeCheckpoint message, String taskManagerLocationInfo) throws CheckpointException {
        if (this.shutdown || message == null) {
            return false;
        }
        if (!this.job.equals((Object)message.getJob())) {
            LOG.error("Received wrong AcknowledgeCheckpoint message for job {} from {} : {}", new Object[]{this.job, taskManagerLocationInfo, message});
            return false;
        }
        long checkpointId = message.getCheckpointId();
        Object object = this.lock;
        synchronized (object) {
            boolean wasPendingCheckpoint;
            if (this.shutdown) {
                return false;
            }
            PendingCheckpoint checkpoint = this.pendingCheckpoints.get(checkpointId);
            if (checkpoint != null && !checkpoint.isDisposed()) {
                switch (checkpoint.acknowledgeTask(message.getTaskExecutionId(), message.getSubtaskState(), message.getCheckpointMetrics())) {
                    case SUCCESS: {
                        LOG.debug("Received acknowledge message for checkpoint {} from task {} of job {} at {}.", new Object[]{checkpointId, message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
                        if (!checkpoint.isFullyAcknowledged()) break;
                        this.completePendingCheckpoint(checkpoint);
                        break;
                    }
                    case DUPLICATE: {
                        LOG.debug("Received a duplicate acknowledge message for checkpoint {}, task {}, job {}, location {}.", new Object[]{message.getCheckpointId(), message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
                        break;
                    }
                    case UNKNOWN: {
                        LOG.warn("Could not acknowledge the checkpoint {} for task {} of job {} at {}, because the task's execution attempt id was unknown. Discarding the state handle to avoid lingering state.", new Object[]{message.getCheckpointId(), message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
                        this.discardSubtaskState(message.getJob(), message.getTaskExecutionId(), message.getCheckpointId(), message.getSubtaskState());
                        break;
                    }
                    case DISCARDED: {
                        LOG.warn("Could not acknowledge the checkpoint {} for task {} of job {} at {}, because the pending checkpoint had been discarded. Discarding the state handle tp avoid lingering state.", new Object[]{message.getCheckpointId(), message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
                        this.discardSubtaskState(message.getJob(), message.getTaskExecutionId(), message.getCheckpointId(), message.getSubtaskState());
                    }
                }
                return true;
            }
            if (checkpoint != null) {
                throw new IllegalStateException("Received message for discarded but non-removed checkpoint " + checkpointId);
            }
            if (this.recentPendingCheckpoints.contains(checkpointId)) {
                wasPendingCheckpoint = true;
                LOG.warn("Received late message for now expired checkpoint attempt {} from task {} of job {} at {}.", new Object[]{checkpointId, message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
            } else {
                LOG.debug("Received message for an unknown checkpoint {} from task {} of job {} at {}.", new Object[]{checkpointId, message.getTaskExecutionId(), message.getJob(), taskManagerLocationInfo});
                wasPendingCheckpoint = false;
            }
            this.discardSubtaskState(message.getJob(), message.getTaskExecutionId(), message.getCheckpointId(), message.getSubtaskState());
            return wasPendingCheckpoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completePendingCheckpoint(PendingCheckpoint pendingCheckpoint) throws CheckpointException {
        CompletedCheckpoint completedCheckpoint;
        long checkpointId = pendingCheckpoint.getCheckpointId();
        Map<OperatorID, OperatorState> operatorStates = pendingCheckpoint.getOperatorStates();
        this.sharedStateRegistry.registerAll(operatorStates.values());
        try {
            try {
                completedCheckpoint = pendingCheckpoint.finalizeCheckpoint(this.checkpointsCleaner, this::scheduleTriggerRequest, this.executor);
                this.failureManager.handleCheckpointSuccess(pendingCheckpoint.getCheckpointId());
            }
            catch (Exception e1) {
                if (!pendingCheckpoint.isDisposed()) {
                    this.abortPendingCheckpoint(pendingCheckpoint, new CheckpointException(CheckpointFailureReason.FINALIZE_CHECKPOINT_FAILURE, (Throwable)e1));
                }
                throw new CheckpointException("Could not finalize the pending checkpoint " + checkpointId + '.', CheckpointFailureReason.FINALIZE_CHECKPOINT_FAILURE, e1);
            }
            Preconditions.checkState((pendingCheckpoint.isDisposed() && completedCheckpoint != null ? 1 : 0) != 0);
            try {
                this.completedCheckpointStore.addCheckpoint(completedCheckpoint, this.checkpointsCleaner, this::scheduleTriggerRequest);
            }
            catch (Exception exception) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            completedCheckpoint.discardOnFailedStoring();
                        }
                        catch (Throwable t) {
                            LOG.warn("Could not properly discard completed checkpoint {}.", (Object)completedCheckpoint.getCheckpointID(), (Object)t);
                        }
                    }
                });
                this.sendAbortedMessages(checkpointId, pendingCheckpoint.getCheckpointTimestamp());
                throw new CheckpointException("Could not complete the pending checkpoint " + checkpointId + '.', CheckpointFailureReason.FINALIZE_CHECKPOINT_FAILURE, exception);
            }
        }
        finally {
            this.pendingCheckpoints.remove(checkpointId);
            this.scheduleTriggerRequest();
        }
        this.rememberRecentCheckpointId(checkpointId);
        this.dropSubsumedCheckpoints(checkpointId);
        this.lastCheckpointCompletionRelativeTime = this.clock.relativeTimeMillis();
        LOG.info("Completed checkpoint {} for job {} ({} bytes in {} ms).", new Object[]{checkpointId, this.job, completedCheckpoint.getStateSize(), completedCheckpoint.getDuration()});
        if (LOG.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Checkpoint state: ");
            for (OperatorState state : completedCheckpoint.getOperatorStates().values()) {
                builder.append(state);
                builder.append(", ");
            }
            builder.setLength(builder.length() - 2);
            LOG.debug(builder.toString());
        }
        this.sendAcknowledgeMessages(checkpointId, completedCheckpoint.getTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleTriggerRequest() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutdown()) {
                LOG.debug("Skip scheduling trigger request because the CheckpointCoordinator is shut down");
            } else {
                this.timer.execute(this::executeQueuedRequest);
            }
        }
    }

    private void sendAcknowledgeMessages(long checkpointId, long timestamp) {
        for (ExecutionVertex ev : this.tasksToCommitTo) {
            Execution ee = ev.getCurrentExecutionAttempt();
            if (ee == null) continue;
            ee.notifyCheckpointComplete(checkpointId, timestamp);
        }
        for (OperatorCoordinatorCheckpointContext coordinatorContext : this.coordinatorsToCheckpoint) {
            coordinatorContext.notifyCheckpointComplete(checkpointId);
        }
    }

    private void sendAbortedMessages(long checkpointId, long timeStamp) {
        this.executor.execute(() -> {
            for (ExecutionVertex ev : this.tasksToCommitTo) {
                Execution ee = ev.getCurrentExecutionAttempt();
                if (ee == null) continue;
                ee.notifyCheckpointAborted(checkpointId, timeStamp);
            }
        });
        for (OperatorCoordinatorCheckpointContext coordinatorContext : this.coordinatorsToCheckpoint) {
            coordinatorContext.notifyCheckpointAborted(checkpointId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failUnacknowledgedPendingCheckpointsFor(ExecutionAttemptID executionAttemptId, Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            this.abortPendingCheckpoints(checkpoint -> !checkpoint.isAcknowledgedBy(executionAttemptId), new CheckpointException(CheckpointFailureReason.TASK_FAILURE, cause));
        }
    }

    private void rememberRecentCheckpointId(long id) {
        if (this.recentPendingCheckpoints.size() >= 16) {
            this.recentPendingCheckpoints.removeFirst();
        }
        this.recentPendingCheckpoints.addLast(id);
    }

    private void dropSubsumedCheckpoints(long checkpointId) {
        this.abortPendingCheckpoints(checkpoint -> checkpoint.getCheckpointId() < checkpointId && checkpoint.canBeSubsumed(), new CheckpointException(CheckpointFailureReason.CHECKPOINT_SUBSUMED));
    }

    @Deprecated
    public boolean restoreLatestCheckpointedState(Map<JobVertexID, ExecutionJobVertex> tasks, boolean errorIfNoCheckpoint, boolean allowNonRestoredState) throws Exception {
        OptionalLong restoredCheckpointId = this.restoreLatestCheckpointedStateInternal(new HashSet<ExecutionJobVertex>(tasks.values()), OperatorCoordinatorRestoreBehavior.RESTORE_OR_RESET, errorIfNoCheckpoint, allowNonRestoredState);
        return restoredCheckpointId.isPresent();
    }

    public OptionalLong restoreLatestCheckpointedStateToSubtasks(Set<ExecutionJobVertex> tasks) throws Exception {
        return this.restoreLatestCheckpointedStateInternal(tasks, OperatorCoordinatorRestoreBehavior.SKIP, false, true);
    }

    public boolean restoreLatestCheckpointedStateToAll(Set<ExecutionJobVertex> tasks, boolean allowNonRestoredState) throws Exception {
        OptionalLong restoredCheckpointId = this.restoreLatestCheckpointedStateInternal(tasks, OperatorCoordinatorRestoreBehavior.RESTORE_OR_RESET, false, allowNonRestoredState);
        return restoredCheckpointId.isPresent();
    }

    public boolean restoreInitialCheckpointIfPresent(Set<ExecutionJobVertex> tasks) throws Exception {
        OptionalLong restoredCheckpointId = this.restoreLatestCheckpointedStateInternal(tasks, OperatorCoordinatorRestoreBehavior.RESTORE_IF_CHECKPOINT_PRESENT, false, false);
        return restoredCheckpointId.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OptionalLong restoreLatestCheckpointedStateInternal(Set<ExecutionJobVertex> tasks, OperatorCoordinatorRestoreBehavior operatorCoordinatorRestoreBehavior, boolean errorIfNoCheckpoint, boolean allowNonRestoredState) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalStateException("CheckpointCoordinator is shut down");
            }
            this.sharedStateRegistry.close();
            this.sharedStateRegistry = this.sharedStateRegistryFactory.create(this.executor);
            this.completedCheckpointStore.recover();
            for (CompletedCheckpoint completedCheckpoint : this.completedCheckpointStore.getAllCheckpoints()) {
                completedCheckpoint.registerSharedStatesAfterRestored(this.sharedStateRegistry);
            }
            LOG.debug("Status of the shared state registry of job {} after restore: {}.", (Object)this.job, (Object)this.sharedStateRegistry);
            CompletedCheckpoint latest = this.completedCheckpointStore.getLatestCheckpoint(this.isPreferCheckpointForRecovery);
            if (latest == null) {
                LOG.info("No checkpoint found during restore.");
                if (errorIfNoCheckpoint) {
                    throw new IllegalStateException("No completed checkpoint available");
                }
                LOG.debug("Resetting the master hooks.");
                MasterHooks.reset(this.masterHooks.values(), LOG);
                if (operatorCoordinatorRestoreBehavior == OperatorCoordinatorRestoreBehavior.RESTORE_OR_RESET) {
                    LOG.info("Resetting the Operator Coordinators to an empty state.");
                    this.restoreStateToCoordinators(-1L, Collections.emptyMap());
                }
                return OptionalLong.empty();
            }
            LOG.info("Restoring job {} from {}.", (Object)this.job, (Object)latest);
            Map<OperatorID, OperatorState> operatorStates = latest.getOperatorStates();
            StateAssignmentOperation stateAssignmentOperation = new StateAssignmentOperation(latest.getCheckpointID(), tasks, operatorStates, allowNonRestoredState);
            stateAssignmentOperation.assignStates();
            MasterHooks.restoreMasterHooks(this.masterHooks, latest.getMasterHookStates(), latest.getCheckpointID(), allowNonRestoredState, LOG);
            if (operatorCoordinatorRestoreBehavior != OperatorCoordinatorRestoreBehavior.SKIP) {
                this.restoreStateToCoordinators(latest.getCheckpointID(), operatorStates);
            }
            if (this.statsTracker != null) {
                long restoreTimestamp = System.currentTimeMillis();
                RestoredCheckpointStats restored = new RestoredCheckpointStats(latest.getCheckpointID(), latest.getProperties(), restoreTimestamp, latest.getExternalPointer());
                this.statsTracker.reportRestoredCheckpoint(restored);
            }
            return OptionalLong.of(latest.getCheckpointID());
        }
    }

    public boolean restoreSavepoint(String savepointPointer, boolean allowNonRestored, Map<JobVertexID, ExecutionJobVertex> tasks, ClassLoader userClassLoader) throws Exception {
        Preconditions.checkNotNull((Object)savepointPointer, (String)"The savepoint path cannot be null.");
        LOG.info("Starting job {} from savepoint {} ({})", new Object[]{this.job, savepointPointer, allowNonRestored ? "allowing non restored state" : ""});
        CompletedCheckpointStorageLocation checkpointLocation = this.checkpointStorage.resolveCheckpoint(savepointPointer);
        CompletedCheckpoint savepoint = Checkpoints.loadAndValidateCheckpoint(this.job, tasks, checkpointLocation, userClassLoader, allowNonRestored);
        this.completedCheckpointStore.addCheckpoint(savepoint, this.checkpointsCleaner, this::scheduleTriggerRequest);
        long nextCheckpointId = savepoint.getCheckpointID() + 1L;
        this.checkpointIdCounter.setCount(nextCheckpointId);
        LOG.info("Reset the checkpoint ID of job {} to {}.", (Object)this.job, (Object)nextCheckpointId);
        OptionalLong restoredCheckpointId = this.restoreLatestCheckpointedStateInternal(new HashSet<ExecutionJobVertex>(tasks.values()), OperatorCoordinatorRestoreBehavior.RESTORE_IF_CHECKPOINT_PRESENT, true, allowNonRestored);
        return restoredCheckpointId.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfPendingCheckpoints() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingCheckpoints.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfRetainedSuccessfulCheckpoints() {
        Object object = this.lock;
        synchronized (object) {
            return this.completedCheckpointStore.getNumberOfRetainedCheckpoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, PendingCheckpoint> getPendingCheckpoints() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<Long, PendingCheckpoint>(this.pendingCheckpoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompletedCheckpoint> getSuccessfulCheckpoints() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            return this.completedCheckpointStore.getAllCheckpoints();
        }
    }

    public CheckpointStorageCoordinatorView getCheckpointStorage() {
        return this.checkpointStorage;
    }

    public CompletedCheckpointStore getCheckpointStore() {
        return this.completedCheckpointStore;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @VisibleForTesting
    PriorityQueue<CheckpointTriggerRequest> getTriggerRequestQueue() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestDecider.getTriggerRequestQueue();
        }
    }

    public boolean isTriggering() {
        return this.isTriggering;
    }

    @VisibleForTesting
    boolean isCurrentPeriodicTriggerAvailable() {
        return this.currentPeriodicTrigger != null;
    }

    public boolean isPeriodicCheckpointingConfigured() {
        return this.baseInterval != Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCheckpointScheduler() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalArgumentException("Checkpoint coordinator is shut down");
            }
            this.stopCheckpointScheduler();
            this.periodicScheduling = true;
            this.currentPeriodicTrigger = this.scheduleTriggerWithDelay(this.getRandomInitDelay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCheckpointScheduler() {
        Object object = this.lock;
        synchronized (object) {
            this.periodicScheduling = false;
            this.cancelPeriodicTrigger();
            CheckpointException reason = new CheckpointException(CheckpointFailureReason.CHECKPOINT_COORDINATOR_SUSPEND);
            this.abortPendingAndQueuedCheckpoints(reason);
            this.numUnsuccessfulCheckpointsTriggers.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortPendingCheckpoints(CheckpointException exception) {
        Object object = this.lock;
        synchronized (object) {
            this.abortPendingCheckpoints(ignored -> true, exception);
        }
    }

    private void abortPendingCheckpoints(Predicate<PendingCheckpoint> checkpointToFailPredicate, CheckpointException exception) {
        PendingCheckpoint[] pendingCheckpointsToFail;
        assert (Thread.holdsLock(this.lock));
        for (PendingCheckpoint pendingCheckpoint : pendingCheckpointsToFail = (PendingCheckpoint[])this.pendingCheckpoints.values().stream().filter(checkpointToFailPredicate).toArray(PendingCheckpoint[]::new)) {
            this.abortPendingCheckpoint(pendingCheckpoint, exception);
        }
    }

    private void rescheduleTrigger(long tillNextMillis) {
        this.cancelPeriodicTrigger();
        this.currentPeriodicTrigger = this.scheduleTriggerWithDelay(tillNextMillis);
    }

    private void cancelPeriodicTrigger() {
        if (this.currentPeriodicTrigger != null) {
            this.currentPeriodicTrigger.cancel(false);
            this.currentPeriodicTrigger = null;
        }
    }

    private long getRandomInitDelay() {
        return ThreadLocalRandom.current().nextLong(this.minPauseBetweenCheckpoints, this.baseInterval + 1L);
    }

    private ScheduledFuture<?> scheduleTriggerWithDelay(long initDelay) {
        return this.timer.scheduleAtFixedRate(new ScheduledTrigger(), initDelay, this.baseInterval, TimeUnit.MILLISECONDS);
    }

    private void restoreStateToCoordinators(long checkpointId, Map<OperatorID, OperatorState> operatorStates) throws Exception {
        for (OperatorCoordinatorCheckpointContext coordContext : this.coordinatorsToCheckpoint) {
            OperatorState state = operatorStates.get((Object)coordContext.operatorId());
            ByteStreamStateHandle coordinatorState = state == null ? null : state.getCoordinatorState();
            byte[] bytes = coordinatorState == null ? null : coordinatorState.getData();
            coordContext.resetToCheckpoint(checkpointId, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobStatusListener createActivatorDeactivator() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalArgumentException("Checkpoint coordinator is shut down");
            }
            if (this.jobStatusListener == null) {
                this.jobStatusListener = new CheckpointCoordinatorDeActivator(this);
            }
            return this.jobStatusListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumQueuedRequests() {
        Object object = this.lock;
        synchronized (object) {
            return this.requestDecider.getNumQueuedRequests();
        }
    }

    private void discardSubtaskState(final JobID jobId, final ExecutionAttemptID executionAttemptID, final long checkpointId, final TaskStateSnapshot subtaskState) {
        if (subtaskState != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        subtaskState.discardState();
                    }
                    catch (Throwable t2) {
                        LOG.warn("Could not properly discard state object of checkpoint {} belonging to task {} of job {}.", new Object[]{checkpointId, executionAttemptID, jobId, t2});
                    }
                }
            });
        }
    }

    private void abortPendingCheckpoint(PendingCheckpoint pendingCheckpoint, CheckpointException exception) {
        this.abortPendingCheckpoint(pendingCheckpoint, exception, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortPendingCheckpoint(PendingCheckpoint pendingCheckpoint, CheckpointException exception, @Nullable ExecutionAttemptID executionAttemptID) {
        assert (Thread.holdsLock(this.lock));
        if (!pendingCheckpoint.isDisposed()) {
            try {
                pendingCheckpoint.abort(exception.getCheckpointFailureReason(), exception.getCause(), this.checkpointsCleaner, this::scheduleTriggerRequest, this.executor);
                if (pendingCheckpoint.getProps().isSavepoint() && pendingCheckpoint.getProps().isSynchronous()) {
                    this.failureManager.handleSynchronousSavepointFailure(exception);
                } else if (executionAttemptID != null) {
                    this.failureManager.handleTaskLevelCheckpointException(exception, pendingCheckpoint.getCheckpointId(), executionAttemptID);
                } else {
                    this.failureManager.handleJobLevelCheckpointException(exception, pendingCheckpoint.getCheckpointId());
                }
            }
            finally {
                this.sendAbortedMessages(pendingCheckpoint.getCheckpointId(), pendingCheckpoint.getCheckpointTimestamp());
                this.pendingCheckpoints.remove(pendingCheckpoint.getCheckpointId());
                this.rememberRecentCheckpointId(pendingCheckpoint.getCheckpointId());
                this.scheduleTriggerRequest();
            }
        }
    }

    private void preCheckGlobalState(boolean isPeriodic) throws CheckpointException {
        if (this.shutdown) {
            throw new CheckpointException(CheckpointFailureReason.CHECKPOINT_COORDINATOR_SHUTDOWN);
        }
        if (isPeriodic && !this.periodicScheduling) {
            throw new CheckpointException(CheckpointFailureReason.PERIODIC_SCHEDULER_SHUTDOWN);
        }
    }

    private Execution[] getTriggerExecutions() throws CheckpointException {
        Execution[] executions = new Execution[this.tasksToTrigger.length];
        for (int i = 0; i < this.tasksToTrigger.length; ++i) {
            Execution ee = this.tasksToTrigger[i].getCurrentExecutionAttempt();
            if (ee == null) {
                LOG.info("Checkpoint triggering task {} of job {} is not being executed at the moment. Aborting checkpoint.", (Object)this.tasksToTrigger[i].getTaskNameWithSubtaskIndex(), (Object)this.job);
                throw new CheckpointException(CheckpointFailureReason.NOT_ALL_REQUIRED_TASKS_RUNNING);
            }
            if (ee.getState() != ExecutionState.RUNNING) {
                LOG.info("Checkpoint triggering task {} of job {} is not in state {} but {} instead. Aborting checkpoint.", new Object[]{this.tasksToTrigger[i].getTaskNameWithSubtaskIndex(), this.job, ExecutionState.RUNNING, ee.getState()});
                throw new CheckpointException(CheckpointFailureReason.NOT_ALL_REQUIRED_TASKS_RUNNING);
            }
            executions[i] = ee;
        }
        return executions;
    }

    private Map<ExecutionAttemptID, ExecutionVertex> getAckTasks() throws CheckpointException {
        HashMap<ExecutionAttemptID, ExecutionVertex> ackTasks = new HashMap<ExecutionAttemptID, ExecutionVertex>(this.tasksToWaitFor.length);
        for (ExecutionVertex ev : this.tasksToWaitFor) {
            Execution ee = ev.getCurrentExecutionAttempt();
            if (ee == null) {
                LOG.info("Checkpoint acknowledging task {} of job {} is not being executed at the moment. Aborting checkpoint.", (Object)ev.getTaskNameWithSubtaskIndex(), (Object)this.job);
                throw new CheckpointException(CheckpointFailureReason.NOT_ALL_REQUIRED_TASKS_RUNNING);
            }
            ackTasks.put(ee.getAttemptId(), ev);
        }
        return ackTasks;
    }

    private void abortPendingAndQueuedCheckpoints(CheckpointException exception) {
        assert (Thread.holdsLock(this.lock));
        this.requestDecider.abortAll(exception);
        this.abortPendingCheckpoints(exception);
    }

    private static CheckpointException getCheckpointException(CheckpointFailureReason defaultReason, Throwable throwable) {
        Optional checkpointExceptionOptional = ExceptionUtils.findThrowable((Throwable)throwable, CheckpointException.class);
        return checkpointExceptionOptional.orElseGet(() -> new CheckpointException(defaultReason, throwable));
    }

    private /* synthetic */ Object lambda$startTriggeringCheckpoint$7(CompletableFuture pendingCheckpointCompletableFuture, CheckpointTriggerRequest request, long timestamp, Execution[] executions, Void ignored, Throwable throwable) {
        PendingCheckpoint checkpoint = (PendingCheckpoint)FutureUtils.getWithoutException(pendingCheckpointCompletableFuture);
        Preconditions.checkState((checkpoint != null || throwable != null ? 1 : 0) != 0, (Object)"Either the pending checkpoint needs to be created or an error must have been occurred.");
        if (throwable != null) {
            if (checkpoint == null) {
                this.onTriggerFailure(request, throwable);
            } else {
                this.onTriggerFailure(checkpoint, throwable);
            }
        } else if (checkpoint.isDisposed()) {
            this.onTriggerFailure(checkpoint, (Throwable)new CheckpointException(CheckpointFailureReason.TRIGGER_CHECKPOINT_FAILURE, (Throwable)checkpoint.getFailureCause()));
        } else {
            long checkpointId = checkpoint.getCheckpointId();
            this.snapshotTaskState(timestamp, checkpointId, checkpoint.getCheckpointStorageLocation(), request.props, executions);
            this.coordinatorsToCheckpoint.forEach(ctx -> ctx.afterSourceBarrierInjection(checkpointId));
            if (!this.maybeCompleteCheckpoint(checkpoint)) {
                return null;
            }
            this.onTriggerSuccess();
        }
        return null;
    }

    private /* synthetic */ CompletionStage lambda$startTriggeringCheckpoint$5(CompletableFuture pendingCheckpointCompletableFuture, Object ignored) {
        PendingCheckpoint checkpoint = (PendingCheckpoint)FutureUtils.getWithoutException(pendingCheckpointCompletableFuture);
        return this.snapshotMasterState(checkpoint);
    }

    private static enum OperatorCoordinatorRestoreBehavior {
        RESTORE_OR_RESET,
        RESTORE_IF_CHECKPOINT_PRESENT,
        SKIP;

    }

    static class CheckpointTriggerRequest {
        final long timestamp;
        final CheckpointProperties props;
        @Nullable
        final String externalSavepointLocation;
        final boolean isPeriodic;
        private final CompletableFuture<CompletedCheckpoint> onCompletionPromise = new CompletableFuture();

        CheckpointTriggerRequest(CheckpointProperties props, @Nullable String externalSavepointLocation, boolean isPeriodic) {
            this.timestamp = System.currentTimeMillis();
            this.props = (CheckpointProperties)Preconditions.checkNotNull((Object)props);
            this.externalSavepointLocation = externalSavepointLocation;
            this.isPeriodic = isPeriodic;
        }

        CompletableFuture<CompletedCheckpoint> getOnCompletionFuture() {
            return this.onCompletionPromise;
        }

        public void completeExceptionally(CheckpointException exception) {
            this.onCompletionPromise.completeExceptionally(exception);
        }

        public boolean isForce() {
            return this.props.forceCheckpoint();
        }
    }

    private static class CheckpointIdAndStorageLocation {
        private final long checkpointId;
        private final CheckpointStorageLocation checkpointStorageLocation;

        CheckpointIdAndStorageLocation(long checkpointId, CheckpointStorageLocation checkpointStorageLocation) {
            this.checkpointId = checkpointId;
            this.checkpointStorageLocation = (CheckpointStorageLocation)Preconditions.checkNotNull((Object)checkpointStorageLocation);
        }
    }

    private class CheckpointCanceller
    implements Runnable {
        private final PendingCheckpoint pendingCheckpoint;

        private CheckpointCanceller(PendingCheckpoint pendingCheckpoint) {
            this.pendingCheckpoint = (PendingCheckpoint)Preconditions.checkNotNull((Object)pendingCheckpoint);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = CheckpointCoordinator.this.lock;
            synchronized (object) {
                if (!this.pendingCheckpoint.isDisposed()) {
                    LOG.info("Checkpoint {} of job {} expired before completing.", (Object)this.pendingCheckpoint.getCheckpointId(), (Object)CheckpointCoordinator.this.job);
                    CheckpointCoordinator.this.abortPendingCheckpoint(this.pendingCheckpoint, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED));
                }
            }
        }
    }

    private final class ScheduledTrigger
    implements Runnable {
        private ScheduledTrigger() {
        }

        @Override
        public void run() {
            try {
                CheckpointCoordinator.this.triggerCheckpoint(true);
            }
            catch (Exception e) {
                LOG.error("Exception while triggering checkpoint for job {}.", (Object)CheckpointCoordinator.this.job, (Object)e);
            }
        }
    }
}

