/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.shaded.guava18.com.google.common.collect.Sets;

@Internal
public enum SubtaskStateMapper {
    ARBITRARY{

        @Override
        public Set<Integer> getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            return ROUND_ROBIN.getOldSubtasks(newSubtaskIndex, oldNumberOfSubtasks, newNumberOfSubtasks);
        }
    }
    ,
    DISCARD_EXTRA_STATE{

        @Override
        public Set<Integer> getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            return newSubtaskIndex >= oldNumberOfSubtasks ? Collections.emptySet() : Collections.singleton(newSubtaskIndex);
        }
    }
    ,
    FIRST{

        @Override
        public Set<Integer> getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            return newSubtaskIndex == 0 ? IntStream.range(0, oldNumberOfSubtasks).boxed().collect(Collectors.toSet()) : Collections.emptySet();
        }
    }
    ,
    FULL{

        @Override
        public Set<Integer> getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            return IntStream.range(0, oldNumberOfSubtasks).boxed().collect(Collectors.toSet());
        }
    }
    ,
    RANGE{

        @Override
        public Set<Integer> getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            int maxParallelism = 32768;
            KeyGroupRange newRange = KeyGroupRangeAssignment.computeKeyGroupRangeForOperatorIndex(maxParallelism, newNumberOfSubtasks, newSubtaskIndex);
            int start = KeyGroupRangeAssignment.computeOperatorIndexForKeyGroup(maxParallelism, oldNumberOfSubtasks, newRange.getStartKeyGroup());
            int end = KeyGroupRangeAssignment.computeOperatorIndexForKeyGroup(maxParallelism, oldNumberOfSubtasks, newRange.getEndKeyGroup());
            return IntStream.range(start, end + 1).boxed().collect(Collectors.toSet());
        }
    }
    ,
    ROUND_ROBIN{

        @Override
        public Set<Integer> getOldSubtasks(int newSubtaskIndex, int oldNumberOfSubtasks, int newNumberOfSubtasks) {
            HashSet subtasks = Sets.newHashSetWithExpectedSize((int)(newNumberOfSubtasks / oldNumberOfSubtasks + 1));
            for (int subtask = newSubtaskIndex; subtask < oldNumberOfSubtasks; subtask += newNumberOfSubtasks) {
                subtasks.add(subtask);
            }
            return subtasks;
        }
    };


    public abstract Set<Integer> getOldSubtasks(int var1, int var2, int var3);

    public Map<Integer, Set<Integer>> getNewToOldSubtasksMapping(int oldParallelism, int newParallelism) {
        return IntStream.range(0, newParallelism).boxed().collect(Collectors.toMap(Function.identity(), channelIndex -> this.getOldSubtasks((int)channelIndex, oldParallelism, newParallelism)));
    }
}

