/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentProvider;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class BufferManager
implements BufferListener,
BufferRecycler {
    private final AvailableBufferQueue bufferQueue = new AvailableBufferQueue();
    private final MemorySegmentProvider globalPool;
    private final InputChannel inputChannel;
    @GuardedBy(value="bufferQueue")
    private boolean isWaitingForFloatingBuffers;
    @GuardedBy(value="bufferQueue")
    private int numRequiredBuffers;

    public BufferManager(MemorySegmentProvider globalPool, InputChannel inputChannel, int numRequiredBuffers) {
        this.globalPool = (MemorySegmentProvider)Preconditions.checkNotNull((Object)globalPool);
        this.inputChannel = (InputChannel)Preconditions.checkNotNull((Object)inputChannel);
        Preconditions.checkArgument((numRequiredBuffers >= 0 ? 1 : 0) != 0);
        this.numRequiredBuffers = numRequiredBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Buffer requestBuffer() {
        AvailableBufferQueue availableBufferQueue = this.bufferQueue;
        synchronized (availableBufferQueue) {
            return this.bufferQueue.takeBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Buffer requestBufferBlocking() throws InterruptedException {
        AvailableBufferQueue availableBufferQueue = this.bufferQueue;
        synchronized (availableBufferQueue) {
            Buffer buffer;
            while ((buffer = this.bufferQueue.takeBuffer()) == null) {
                BufferPool bufferPool;
                if (this.inputChannel.isReleased()) {
                    throw new CancelTaskException("Input channel [" + this.inputChannel.channelInfo + "] has already been released.");
                }
                if (!this.isWaitingForFloatingBuffers && (buffer = (bufferPool = this.inputChannel.inputGate.getBufferPool()).requestBuffer()) == null && this.shouldContinueRequest(bufferPool)) continue;
                if (buffer != null) {
                    return buffer;
                }
                this.bufferQueue.wait();
            }
            return buffer;
        }
    }

    private boolean shouldContinueRequest(BufferPool bufferPool) {
        if (bufferPool.addBufferListener(this)) {
            this.isWaitingForFloatingBuffers = true;
            this.numRequiredBuffers = 1;
            return false;
        }
        if (bufferPool.isDestroyed()) {
            throw new CancelTaskException("Local buffer pool has already been released.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestExclusiveBuffers(int numExclusiveBuffers) throws IOException {
        Collection segments = this.globalPool.requestMemorySegments(numExclusiveBuffers);
        Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"The number of exclusive buffers per channel should be larger than 0.");
        AvailableBufferQueue availableBufferQueue = this.bufferQueue;
        synchronized (availableBufferQueue) {
            for (MemorySegment segment : segments) {
                this.bufferQueue.addExclusiveBuffer(new NetworkBuffer(segment, this), this.numRequiredBuffers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int requestFloatingBuffers(int numRequired) {
        int numRequestedBuffers = 0;
        AvailableBufferQueue availableBufferQueue = this.bufferQueue;
        synchronized (availableBufferQueue) {
            if (this.inputChannel.isReleased()) {
                return numRequestedBuffers;
            }
            this.numRequiredBuffers = numRequired;
            while (this.bufferQueue.getAvailableBufferSize() < this.numRequiredBuffers && !this.isWaitingForFloatingBuffers) {
                BufferPool bufferPool = this.inputChannel.inputGate.getBufferPool();
                Buffer buffer = bufferPool.requestBuffer();
                if (buffer != null) {
                    this.bufferQueue.addFloatingBuffer(buffer);
                    ++numRequestedBuffers;
                    continue;
                }
                if (!bufferPool.addBufferListener(this)) continue;
                this.isWaitingForFloatingBuffers = true;
                break;
            }
        }
        return numRequestedBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(MemorySegment segment) {
        int numAddedBuffers = 0;
        AvailableBufferQueue availableBufferQueue = this.bufferQueue;
        synchronized (availableBufferQueue) {
            try {
                if (this.inputChannel.isReleased()) {
                    this.globalPool.recycleMemorySegments(Collections.singletonList(segment));
                } else {
                    numAddedBuffers = this.bufferQueue.addExclusiveBuffer(new NetworkBuffer(segment, this), this.numRequiredBuffers);
                }
            }
            catch (Throwable t) {
                ExceptionUtils.rethrow((Throwable)t);
            }
            finally {
                this.bufferQueue.notifyAll();
            }
        }
        try {
            this.inputChannel.notifyBufferAvailable(numAddedBuffers);
        }
        catch (Throwable t) {
            ExceptionUtils.rethrow((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFloatingBuffers() {
        AvailableBufferQueue availableBufferQueue = this.bufferQueue;
        synchronized (availableBufferQueue) {
            this.numRequiredBuffers = 0;
            this.bufferQueue.releaseFloatingBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseAllBuffers(ArrayDeque<Buffer> buffers) throws IOException {
        Buffer buffer;
        ArrayList<MemorySegment> exclusiveRecyclingSegments = new ArrayList<MemorySegment>();
        while ((buffer = buffers.poll()) != null) {
            if (buffer.getRecycler() == this) {
                exclusiveRecyclingSegments.add(buffer.getMemorySegment());
                continue;
            }
            buffer.recycleBuffer();
        }
        AvailableBufferQueue availableBufferQueue = this.bufferQueue;
        synchronized (availableBufferQueue) {
            this.bufferQueue.releaseAll(exclusiveRecyclingSegments);
            this.bufferQueue.notifyAll();
        }
        if (exclusiveRecyclingSegments.size() > 0) {
            this.globalPool.recycleMemorySegments(exclusiveRecyclingSegments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferListener.NotificationResult notifyBufferAvailable(Buffer buffer) {
        BufferListener.NotificationResult notificationResult = BufferListener.NotificationResult.BUFFER_NOT_USED;
        if (this.inputChannel.isReleased()) {
            return notificationResult;
        }
        try {
            AvailableBufferQueue availableBufferQueue = this.bufferQueue;
            synchronized (availableBufferQueue) {
                Preconditions.checkState((boolean)this.isWaitingForFloatingBuffers, (Object)"This channel should be waiting for floating buffers.");
                if (this.inputChannel.isReleased() || this.bufferQueue.getAvailableBufferSize() >= this.numRequiredBuffers) {
                    this.isWaitingForFloatingBuffers = false;
                    return notificationResult;
                }
                this.bufferQueue.addFloatingBuffer(buffer);
                this.bufferQueue.notifyAll();
                if (this.bufferQueue.getAvailableBufferSize() == this.numRequiredBuffers) {
                    this.isWaitingForFloatingBuffers = false;
                    notificationResult = BufferListener.NotificationResult.BUFFER_USED_NO_NEED_MORE;
                } else {
                    notificationResult = BufferListener.NotificationResult.BUFFER_USED_NEED_MORE;
                }
            }
            if (notificationResult != BufferListener.NotificationResult.BUFFER_NOT_USED) {
                this.inputChannel.notifyBufferAvailable(1);
            }
        }
        catch (Throwable t) {
            this.inputChannel.setError(t);
        }
        return notificationResult;
    }

    @Override
    public void notifyBufferDestroyed() {
    }

    @VisibleForTesting
    int unsynchronizedGetNumberOfRequiredBuffers() {
        return this.numRequiredBuffers;
    }

    @VisibleForTesting
    boolean unsynchronizedIsWaitingForFloatingBuffers() {
        return this.isWaitingForFloatingBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNumberOfAvailableBuffers() {
        AvailableBufferQueue availableBufferQueue = this.bufferQueue;
        synchronized (availableBufferQueue) {
            return this.bufferQueue.getAvailableBufferSize();
        }
    }

    int unsynchronizedGetAvailableExclusiveBuffers() {
        return this.bufferQueue.exclusiveBuffers.size();
    }

    int unsynchronizedGetFloatingBuffersAvailable() {
        return this.bufferQueue.floatingBuffers.size();
    }

    static final class AvailableBufferQueue {
        final ArrayDeque<Buffer> floatingBuffers;
        final ArrayDeque<Buffer> exclusiveBuffers = new ArrayDeque();

        AvailableBufferQueue() {
            this.floatingBuffers = new ArrayDeque();
        }

        int addExclusiveBuffer(Buffer buffer, int numRequiredBuffers) {
            Buffer floatingBuffer;
            this.exclusiveBuffers.add(buffer);
            if (this.getAvailableBufferSize() > numRequiredBuffers && (floatingBuffer = this.floatingBuffers.poll()) != null) {
                floatingBuffer.recycleBuffer();
                return 0;
            }
            return 1;
        }

        void addFloatingBuffer(Buffer buffer) {
            this.floatingBuffers.add(buffer);
        }

        @Nullable
        Buffer takeBuffer() {
            if (this.floatingBuffers.size() > 0) {
                return this.floatingBuffers.poll();
            }
            return this.exclusiveBuffers.poll();
        }

        void releaseAll(List<MemorySegment> exclusiveSegments) {
            Buffer buffer;
            while ((buffer = this.floatingBuffers.poll()) != null) {
                buffer.recycleBuffer();
            }
            while ((buffer = this.exclusiveBuffers.poll()) != null) {
                exclusiveSegments.add(buffer.getMemorySegment());
            }
        }

        void releaseFloatingBuffers() {
            Buffer buffer;
            while ((buffer = this.floatingBuffers.poll()) != null) {
                buffer.recycleBuffer();
            }
        }

        int getAvailableBufferSize() {
            return this.floatingBuffers.size() + this.exclusiveBuffers.size();
        }
    }
}

