/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import org.apache.flink.runtime.operators.sort.HeapSort;
import org.apache.flink.runtime.operators.sort.IndexedSortable;
import org.apache.flink.runtime.operators.sort.IndexedSorter;

public final class QuickSort
implements IndexedSorter {
    private static final IndexedSorter alt = new HeapSort();

    private static void fix(IndexedSortable s, int pN, int pO, int rN, int rO) {
        if (s.compare(pN, pO, rN, rO) > 0) {
            s.swap(pN, pO, rN, rO);
        }
    }

    protected static int getMaxDepth(int x) {
        if (x <= 0) {
            throw new IllegalArgumentException("Undefined for " + x);
        }
        return 32 - Integer.numberOfLeadingZeros(x - 1) << 2;
    }

    @Override
    public void sort(IndexedSortable s, int p, int r) {
        int recordsPerSegment = s.recordsPerSegment();
        int recordSize = s.recordSize();
        int maxOffset = recordSize * (recordsPerSegment - 1);
        int pN = p / recordsPerSegment;
        int pO = p % recordsPerSegment * recordSize;
        int rN = r / recordsPerSegment;
        int rO = r % recordsPerSegment * recordSize;
        QuickSort.sortInternal(s, recordsPerSegment, recordSize, maxOffset, p, pN, pO, r, rN, rO, QuickSort.getMaxDepth(r - p));
    }

    @Override
    public void sort(IndexedSortable s) {
        this.sort(s, 0, s.size());
    }

    private static void sortInternal(IndexedSortable s, int recordsPerSegment, int recordSize, int maxOffset, int p, int pN, int pO, int r, int rN, int rO, int depth) {
        while (true) {
            int rdO;
            int rdN;
            if (r - p < 13) {
                int iO;
                int iN;
                int i = p + 1;
                if (pO == maxOffset) {
                    iN = pN + 1;
                    iO = 0;
                } else {
                    iN = pN;
                    iO = pO + recordSize;
                }
                while (i < r) {
                    int jdO;
                    int jdN;
                    int j = i;
                    int jN = iN;
                    int jO = iO;
                    int jd = j - 1;
                    if (jO == 0) {
                        jdN = jN - 1;
                        jdO = maxOffset;
                    } else {
                        jdN = jN;
                        jdO = jO - recordSize;
                    }
                    while (j > p && s.compare(jdN, jdO, jN, jO) > 0) {
                        s.swap(jN, jO, jdN, jdO);
                        j = jd--;
                        jN = jdN--;
                        jO = jdO;
                        if (jdO == 0) {
                            jdO = maxOffset;
                            continue;
                        }
                        jdO -= recordSize;
                    }
                    ++i;
                    if (iO == maxOffset) {
                        ++iN;
                        iO = 0;
                        continue;
                    }
                    iO += recordSize;
                }
                return;
            }
            if (--depth < 0) {
                alt.sort(s, p, r);
                return;
            }
            if (rO == 0) {
                rdN = rN - 1;
                rdO = maxOffset;
            } else {
                rdN = rN;
                rdO = rO - recordSize;
            }
            int m = p + r >>> 1;
            int mN = m / recordsPerSegment;
            int mO = m % recordsPerSegment * recordSize;
            QuickSort.fix(s, mN, mO, pN, pO);
            QuickSort.fix(s, mN, mO, rdN, rdO);
            QuickSort.fix(s, pN, pO, rdN, rdO);
            int i = p;
            int iN = pN;
            int iO = pO;
            int j = r;
            int jN = rN;
            int jO = rO;
            int ll = p;
            int llN = pN;
            int llO = pO;
            int rr = r;
            int rrN = rN;
            int rrO = rO;
            while (true) {
                int cr;
                ++i;
                if (iO == maxOffset) {
                    ++iN;
                    iO = 0;
                } else {
                    iO += recordSize;
                }
                while (i < j && (cr = s.compare(iN, iO, pN, pO)) <= 0) {
                    if (0 == cr) {
                        ++ll;
                        if (llO == maxOffset) {
                            ++llN;
                            llO = 0;
                        } else {
                            llO += recordSize;
                        }
                        if (ll != i) {
                            s.swap(llN, llO, iN, iO);
                        }
                    }
                    ++i;
                    if (iO == maxOffset) {
                        ++iN;
                        iO = 0;
                        continue;
                    }
                    iO += recordSize;
                }
                --j;
                if (jO == 0) {
                    --jN;
                    jO = maxOffset;
                } else {
                    jO -= recordSize;
                }
                while (j > i && (cr = s.compare(pN, pO, jN, jO)) <= 0) {
                    if (0 == cr) {
                        --rr;
                        if (rrO == 0) {
                            --rrN;
                            rrO = maxOffset;
                        } else {
                            rrO -= recordSize;
                        }
                        if (rr != j) {
                            s.swap(rrN, rrO, jN, jO);
                        }
                    }
                    --j;
                    if (jO == 0) {
                        --jN;
                        jO = maxOffset;
                        continue;
                    }
                    jO -= recordSize;
                }
                if (i >= j) break;
                s.swap(iN, iO, jN, jO);
            }
            j = i;
            jN = iN;
            jO = iO;
            while (ll >= p) {
                --i;
                if (iO == 0) {
                    --iN;
                    iO = maxOffset;
                } else {
                    iO -= recordSize;
                }
                s.swap(llN, llO, iN, iO);
                --ll;
                if (llO == 0) {
                    --llN;
                    llO = maxOffset;
                    continue;
                }
                llO -= recordSize;
            }
            while (rr < r) {
                s.swap(rrN, rrO, jN, jO);
                ++rr;
                if (rrO == maxOffset) {
                    ++rrN;
                    rrO = 0;
                } else {
                    rrO += recordSize;
                }
                ++j;
                if (jO == maxOffset) {
                    ++jN;
                    jO = 0;
                    continue;
                }
                jO += recordSize;
            }
            assert (i != j);
            if (i - p < r - j) {
                QuickSort.sortInternal(s, recordsPerSegment, recordSize, maxOffset, p, pN, pO, i, iN, iO, depth);
                p = j;
                pN = jN;
                pO = jO;
                continue;
            }
            QuickSort.sortInternal(s, recordsPerSegment, recordSize, maxOffset, j, jN, jO, r, rN, rO, depth);
            r = i;
            rN = iN;
            rO = iO;
        }
    }
}

