/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.active;

import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.resourcemanager.active.ResourceEventHandler;
import org.apache.flink.runtime.resourcemanager.active.ResourceManagerDriver;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceManagerDriver<WorkerType extends ResourceIDRetrievable>
implements ResourceManagerDriver<WorkerType> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Configuration flinkConfig;
    protected final Configuration flinkClientConfig;
    private ResourceEventHandler<WorkerType> resourceEventHandler = null;
    private ScheduledExecutor mainThreadExecutor = null;
    private Executor ioExecutor = null;

    public AbstractResourceManagerDriver(Configuration flinkConfig, Configuration flinkClientConfig) {
        this.flinkConfig = (Configuration)Preconditions.checkNotNull((Object)flinkConfig);
        this.flinkClientConfig = (Configuration)Preconditions.checkNotNull((Object)flinkClientConfig);
    }

    protected final ResourceEventHandler<WorkerType> getResourceEventHandler() {
        Preconditions.checkState((this.resourceEventHandler != null ? 1 : 0) != 0, (Object)"Cannot get resource event handler. Resource manager driver is not initialized.");
        return this.resourceEventHandler;
    }

    protected final ScheduledExecutor getMainThreadExecutor() {
        Preconditions.checkState((this.mainThreadExecutor != null ? 1 : 0) != 0, (Object)"Cannot get main thread executor. Resource manager driver is not initialized.");
        return this.mainThreadExecutor;
    }

    protected final Executor getIoExecutor() {
        Preconditions.checkState((this.ioExecutor != null ? 1 : 0) != 0, (Object)"Cannot get the io executor. Resource manager driver is not initialized.");
        return this.ioExecutor;
    }

    @Override
    public final void initialize(ResourceEventHandler<WorkerType> resourceEventHandler, ScheduledExecutor mainThreadExecutor, Executor ioExecutor) throws Exception {
        this.resourceEventHandler = (ResourceEventHandler)Preconditions.checkNotNull(resourceEventHandler);
        this.mainThreadExecutor = (ScheduledExecutor)Preconditions.checkNotNull((Object)mainThreadExecutor);
        this.ioExecutor = (Executor)Preconditions.checkNotNull((Object)ioExecutor);
        this.initializeInternal();
    }

    protected abstract void initializeInternal() throws Exception;
}

