/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.akka.org.jboss.netty.handler.codec.http;

import java.util.Set;
import java.util.TreeSet;
import org.apache.flink.shaded.akka.org.jboss.netty.handler.codec.http.Cookie;
import org.apache.flink.shaded.akka.org.jboss.netty.handler.codec.http.DefaultCookie;
import org.apache.flink.shaded.akka.org.jboss.netty.handler.codec.http.cookie.ClientCookieEncoder;
import org.apache.flink.shaded.akka.org.jboss.netty.handler.codec.http.cookie.ServerCookieEncoder;

public class CookieEncoder {
    private final Set<Cookie> cookies = new TreeSet<Cookie>();
    private final boolean server;
    private final boolean strict;

    public CookieEncoder(boolean server) {
        this(server, false);
    }

    public CookieEncoder(boolean server, boolean strict) {
        this.server = server;
        this.strict = strict;
    }

    public void addCookie(String name, String value) {
        this.cookies.add(new DefaultCookie(name, value));
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public String encode() {
        String answer = this.server ? this.encodeServerSide() : this.encodeClientSide();
        this.cookies.clear();
        return answer;
    }

    private String encodeServerSide() {
        if (this.cookies.size() > 1) {
            throw new IllegalStateException("encode() can encode only one cookie on server mode: " + this.cookies.size() + " cookies added");
        }
        Cookie cookie = this.cookies.isEmpty() ? null : this.cookies.iterator().next();
        ServerCookieEncoder encoder = this.strict ? ServerCookieEncoder.STRICT : ServerCookieEncoder.LAX;
        return encoder.encode((org.apache.flink.shaded.akka.org.jboss.netty.handler.codec.http.cookie.Cookie)cookie);
    }

    private String encodeClientSide() {
        ClientCookieEncoder encoder = this.strict ? ClientCookieEncoder.STRICT : ClientCookieEncoder.LAX;
        return encoder.encode(this.cookies);
    }
}

