/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.MinMaxAvgStats;
import org.apache.flink.util.Preconditions;

public class CompletedCheckpointStatsSummary
implements Serializable {
    private static final long serialVersionUID = 5784360461635814038L;
    private final MinMaxAvgStats stateSize;
    private final MinMaxAvgStats duration;
    private final MinMaxAvgStats processedData;
    private final MinMaxAvgStats persistedData;

    CompletedCheckpointStatsSummary() {
        this(new MinMaxAvgStats(), new MinMaxAvgStats(), new MinMaxAvgStats(), new MinMaxAvgStats());
    }

    private CompletedCheckpointStatsSummary(MinMaxAvgStats stateSize, MinMaxAvgStats duration, MinMaxAvgStats processedData, MinMaxAvgStats persistedData) {
        this.stateSize = (MinMaxAvgStats)Preconditions.checkNotNull((Object)stateSize);
        this.duration = (MinMaxAvgStats)Preconditions.checkNotNull((Object)duration);
        this.processedData = (MinMaxAvgStats)Preconditions.checkNotNull((Object)processedData);
        this.persistedData = (MinMaxAvgStats)Preconditions.checkNotNull((Object)persistedData);
    }

    void updateSummary(CompletedCheckpointStats completed) {
        this.stateSize.add(completed.getStateSize());
        this.duration.add(completed.getEndToEndDuration());
        this.processedData.add(completed.getProcessedData());
        this.persistedData.add(completed.getPersistedData());
    }

    CompletedCheckpointStatsSummary createSnapshot() {
        return new CompletedCheckpointStatsSummary(this.stateSize.createSnapshot(), this.duration.createSnapshot(), this.processedData.createSnapshot(), this.persistedData.createSnapshot());
    }

    public MinMaxAvgStats getStateSizeStats() {
        return this.stateSize;
    }

    public MinMaxAvgStats getEndToEndDurationStats() {
        return this.duration;
    }

    public MinMaxAvgStats getProcessedDataStats() {
        return this.processedData;
    }

    public MinMaxAvgStats getPersistedDataStats() {
        return this.persistedData;
    }
}

