/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class ArchivedExecutionGraph
implements AccessExecutionGraph,
Serializable {
    private static final long serialVersionUID = 7231383912742578428L;
    private final JobID jobID;
    private final String jobName;
    private final Map<JobVertexID, ArchivedExecutionJobVertex> tasks;
    private final List<ArchivedExecutionJobVertex> verticesInCreationOrder;
    private final long[] stateTimestamps;
    private final JobStatus state;
    @Nullable
    private final ErrorInfo failureCause;
    private final String jsonPlan;
    private final StringifiedAccumulatorResult[] archivedUserAccumulators;
    private final ArchivedExecutionConfig archivedExecutionConfig;
    private final boolean isStoppable;
    private final Map<String, SerializedValue<OptionalFailure<Object>>> serializedUserAccumulators;
    @Nullable
    private final CheckpointCoordinatorConfiguration jobCheckpointingConfiguration;
    @Nullable
    private final CheckpointStatsSnapshot checkpointStatsSnapshot;
    @Nullable
    private final String stateBackendName;

    public ArchivedExecutionGraph(JobID jobID, String jobName, Map<JobVertexID, ArchivedExecutionJobVertex> tasks, List<ArchivedExecutionJobVertex> verticesInCreationOrder, long[] stateTimestamps, JobStatus state, @Nullable ErrorInfo failureCause, String jsonPlan, StringifiedAccumulatorResult[] archivedUserAccumulators, Map<String, SerializedValue<OptionalFailure<Object>>> serializedUserAccumulators, ArchivedExecutionConfig executionConfig, boolean isStoppable, @Nullable CheckpointCoordinatorConfiguration jobCheckpointingConfiguration, @Nullable CheckpointStatsSnapshot checkpointStatsSnapshot, @Nullable String stateBackendName) {
        this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
        this.jobName = (String)Preconditions.checkNotNull((Object)jobName);
        this.tasks = (Map)Preconditions.checkNotNull(tasks);
        this.verticesInCreationOrder = (List)Preconditions.checkNotNull(verticesInCreationOrder);
        this.stateTimestamps = (long[])Preconditions.checkNotNull((Object)stateTimestamps);
        this.state = (JobStatus)Preconditions.checkNotNull((Object)state);
        this.failureCause = failureCause;
        this.jsonPlan = (String)Preconditions.checkNotNull((Object)jsonPlan);
        this.archivedUserAccumulators = (StringifiedAccumulatorResult[])Preconditions.checkNotNull((Object)archivedUserAccumulators);
        this.serializedUserAccumulators = (Map)Preconditions.checkNotNull(serializedUserAccumulators);
        this.archivedExecutionConfig = (ArchivedExecutionConfig)Preconditions.checkNotNull((Object)executionConfig);
        this.isStoppable = isStoppable;
        this.jobCheckpointingConfiguration = jobCheckpointingConfiguration;
        this.checkpointStatsSnapshot = checkpointStatsSnapshot;
        this.stateBackendName = stateBackendName;
    }

    @Override
    public String getJsonPlan() {
        return this.jsonPlan;
    }

    @Override
    public JobID getJobID() {
        return this.jobID;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public JobStatus getState() {
        return this.state;
    }

    @Override
    @Nullable
    public ErrorInfo getFailureInfo() {
        return this.failureCause;
    }

    @Override
    public ArchivedExecutionJobVertex getJobVertex(JobVertexID id) {
        return this.tasks.get(id);
    }

    public Map<JobVertexID, AccessExecutionJobVertex> getAllVertices() {
        return Collections.unmodifiableMap(this.tasks);
    }

    public Iterable<ArchivedExecutionJobVertex> getVerticesTopologically() {
        final int numElements = this.verticesInCreationOrder.size();
        return new Iterable<ArchivedExecutionJobVertex>(){

            @Override
            public Iterator<ArchivedExecutionJobVertex> iterator() {
                return new Iterator<ArchivedExecutionJobVertex>(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < numElements;
                    }

                    @Override
                    public ArchivedExecutionJobVertex next() {
                        if (this.hasNext()) {
                            return (ArchivedExecutionJobVertex)ArchivedExecutionGraph.this.verticesInCreationOrder.get(this.pos++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<ArchivedExecutionVertex> getAllExecutionVertices() {
        return new Iterable<ArchivedExecutionVertex>(){

            @Override
            public Iterator<ArchivedExecutionVertex> iterator() {
                return new AllVerticesIterator(ArchivedExecutionGraph.this.getVerticesTopologically().iterator());
            }
        };
    }

    @Override
    public long getStatusTimestamp(JobStatus status) {
        return this.stateTimestamps[status.ordinal()];
    }

    @Override
    public CheckpointCoordinatorConfiguration getCheckpointCoordinatorConfiguration() {
        return this.jobCheckpointingConfiguration;
    }

    @Override
    public CheckpointStatsSnapshot getCheckpointStatsSnapshot() {
        return this.checkpointStatsSnapshot;
    }

    @Override
    public boolean isArchived() {
        return true;
    }

    @Override
    public ArchivedExecutionConfig getArchivedExecutionConfig() {
        return this.archivedExecutionConfig;
    }

    @Override
    public boolean isStoppable() {
        return this.isStoppable;
    }

    @Override
    public StringifiedAccumulatorResult[] getAccumulatorResultsStringified() {
        return this.archivedUserAccumulators;
    }

    @Override
    public Map<String, SerializedValue<OptionalFailure<Object>>> getAccumulatorsSerialized() {
        return this.serializedUserAccumulators;
    }

    @Override
    public Optional<String> getStateBackendName() {
        return Optional.ofNullable(this.stateBackendName);
    }

    public static ArchivedExecutionGraph createFrom(ExecutionGraph executionGraph) {
        int numberVertices = executionGraph.getTotalNumberOfVertices();
        HashMap<JobVertexID, ArchivedExecutionJobVertex> archivedTasks = new HashMap<JobVertexID, ArchivedExecutionJobVertex>(numberVertices);
        ArrayList<ArchivedExecutionJobVertex> archivedVerticesInCreationOrder = new ArrayList<ArchivedExecutionJobVertex>(numberVertices);
        for (ExecutionJobVertex task : executionGraph.getVerticesTopologically()) {
            ArchivedExecutionJobVertex archivedTask = task.archive();
            archivedVerticesInCreationOrder.add(archivedTask);
            archivedTasks.put(task.getJobVertexId(), archivedTask);
        }
        Map<String, SerializedValue<OptionalFailure<Object>>> serializedUserAccumulators = executionGraph.getAccumulatorsSerialized();
        long[] timestamps = new long[JobStatus.values().length];
        for (JobStatus jobStatus : JobStatus.values()) {
            int ordinal = jobStatus.ordinal();
            timestamps[ordinal] = executionGraph.getStatusTimestamp(jobStatus);
        }
        return new ArchivedExecutionGraph(executionGraph.getJobID(), executionGraph.getJobName(), archivedTasks, archivedVerticesInCreationOrder, timestamps, executionGraph.getState(), executionGraph.getFailureInfo(), executionGraph.getJsonPlan(), executionGraph.getAccumulatorResultsStringified(), serializedUserAccumulators, executionGraph.getArchivedExecutionConfig(), executionGraph.isStoppable(), executionGraph.getCheckpointCoordinatorConfiguration(), executionGraph.getCheckpointStatsSnapshot(), executionGraph.getStateBackendName().orElse(null));
    }

    public static ArchivedExecutionGraph createFromInitializingJob(JobID jobId, String jobName, JobStatus jobStatus, @Nullable Throwable throwable, long initializationTimestamp) {
        Map<JobVertexID, ArchivedExecutionJobVertex> archivedTasks = Collections.emptyMap();
        List<ArchivedExecutionJobVertex> archivedVerticesInCreationOrder = Collections.emptyList();
        Map<String, SerializedValue<OptionalFailure<Object>>> serializedUserAccumulators = Collections.emptyMap();
        StringifiedAccumulatorResult[] archivedUserAccumulators = new StringifiedAccumulatorResult[]{};
        long[] timestamps = new long[JobStatus.values().length];
        timestamps[JobStatus.INITIALIZING.ordinal()] = initializationTimestamp;
        String jsonPlan = "{}";
        ErrorInfo failureInfo = null;
        if (throwable != null) {
            Preconditions.checkState((jobStatus == JobStatus.FAILED ? 1 : 0) != 0);
            long failureTime = System.currentTimeMillis();
            failureInfo = new ErrorInfo(throwable, failureTime);
            timestamps[JobStatus.FAILED.ordinal()] = failureTime;
        }
        return new ArchivedExecutionGraph(jobId, jobName, archivedTasks, archivedVerticesInCreationOrder, timestamps, jobStatus, failureInfo, jsonPlan, archivedUserAccumulators, serializedUserAccumulators, new ExecutionConfig().archive(), false, null, null, null);
    }

    class AllVerticesIterator
    implements Iterator<ArchivedExecutionVertex> {
        private final Iterator<ArchivedExecutionJobVertex> jobVertices;
        private ArchivedExecutionVertex[] currVertices;
        private int currPos;

        public AllVerticesIterator(Iterator<ArchivedExecutionJobVertex> jobVertices) {
            this.jobVertices = jobVertices;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.currVertices != null) {
                    if (this.currPos < this.currVertices.length) {
                        return true;
                    }
                    this.currVertices = null;
                    continue;
                }
                if (!this.jobVertices.hasNext()) break;
                this.currVertices = this.jobVertices.next().getTaskVertices();
                this.currPos = 0;
            }
            return false;
        }

        @Override
        public ArchivedExecutionVertex next() {
            if (this.hasNext()) {
                return this.currVertices[this.currPos++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

