/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public interface SlotPoolFactory {
    @Nonnull
    public SlotPool createSlotPool(@Nonnull JobID var1);

    public static SlotPoolFactory fromConfiguration(Configuration configuration) {
        Time rpcTimeout = AkkaUtils.getTimeoutAsTime(configuration);
        Time slotIdleTimeout = Time.milliseconds((long)configuration.getLong(JobManagerOptions.SLOT_IDLE_TIMEOUT));
        Time batchSlotTimeout = Time.milliseconds((long)configuration.getLong(JobManagerOptions.SLOT_REQUEST_TIMEOUT));
        if (ClusterOptions.isDeclarativeResourceManagementEnabled((Configuration)configuration)) {
            throw new UnsupportedOperationException("Declarative slot pool is not yet implemented.");
        }
        return new DefaultSlotPoolFactory((Clock)SystemClock.getInstance(), rpcTimeout, slotIdleTimeout, batchSlotTimeout);
    }
}

