/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorResourceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutorResourceUtils.class);
    static final List<ConfigOption<?>> CONFIG_OPTIONS = Arrays.asList(TaskManagerOptions.CPU_CORES, TaskManagerOptions.TASK_HEAP_MEMORY, TaskManagerOptions.TASK_OFF_HEAP_MEMORY, TaskManagerOptions.NETWORK_MEMORY_MIN, TaskManagerOptions.NETWORK_MEMORY_MAX, TaskManagerOptions.MANAGED_MEMORY_SIZE);
    private static final List<ConfigOption<?>> UNUSED_CONFIG_OPTIONS = Arrays.asList(TaskManagerOptions.TOTAL_PROCESS_MEMORY, TaskManagerOptions.TOTAL_FLINK_MEMORY, TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, TaskManagerOptions.JVM_METASPACE, TaskManagerOptions.JVM_OVERHEAD_MIN, TaskManagerOptions.JVM_OVERHEAD_MAX, TaskManagerOptions.JVM_OVERHEAD_FRACTION);
    private static final MemorySize LOCAL_EXECUTION_TASK_MEMORY = MemorySize.ofMebiBytes((long)0x100000L);
    private static final double LOCAL_EXECUTION_CPU_CORES = 1000000.0;
    static final MemorySize DEFAULT_SHUFFLE_MEMORY_SIZE = MemorySize.parse((String)"64m");
    static final MemorySize DEFAULT_MANAGED_MEMORY_SIZE = MemorySize.parse((String)"128m");

    private TaskExecutorResourceUtils() {
    }

    static TaskExecutorResourceSpec resourceSpecFromConfig(Configuration config) {
        try {
            TaskExecutorResourceUtils.checkTaskExecutorResourceConfigSet(config);
        }
        catch (IllegalConfigurationException e) {
            throw new IllegalConfigurationException("Failed to create TaskExecutorResourceSpec", (Throwable)e);
        }
        return new TaskExecutorResourceSpec(new CPUResource(config.getDouble(TaskManagerOptions.CPU_CORES)), (MemorySize)config.get(TaskManagerOptions.TASK_HEAP_MEMORY), (MemorySize)config.get(TaskManagerOptions.TASK_OFF_HEAP_MEMORY), (MemorySize)config.get(TaskManagerOptions.NETWORK_MEMORY_MIN), (MemorySize)config.get(TaskManagerOptions.MANAGED_MEMORY_SIZE));
    }

    private static void checkTaskExecutorResourceConfigSet(Configuration config) {
        CONFIG_OPTIONS.forEach(option -> TaskExecutorResourceUtils.checkConfigOptionIsSet(config, option));
        TaskExecutorResourceUtils.checkTaskExecutorNetworkConfigSet((ReadableConfig)config);
    }

    private static void checkConfigOptionIsSet(Configuration config, ConfigOption<?> option) {
        if (!config.contains(option) && !option.hasDefaultValue()) {
            throw new IllegalConfigurationException("The required configuration option %s is not set", new Object[]{option});
        }
    }

    private static void checkTaskExecutorNetworkConfigSet(ReadableConfig config) {
        if (!((MemorySize)config.get(TaskManagerOptions.NETWORK_MEMORY_MIN)).equals(config.get(TaskManagerOptions.NETWORK_MEMORY_MAX))) {
            throw new IllegalConfigurationException("The network memory min (%s) and max (%s) mismatch, the network memory has to be resolved and set to a fixed value before task executor starts", new Object[]{config.get(TaskManagerOptions.NETWORK_MEMORY_MIN), config.get(TaskManagerOptions.NETWORK_MEMORY_MAX)});
        }
    }

    static ResourceProfile generateDefaultSlotResourceProfile(TaskExecutorResourceSpec taskExecutorResourceSpec, int numberOfSlots) {
        return ResourceProfile.newBuilder().setCpuCores(taskExecutorResourceSpec.getCpuCores().divide(numberOfSlots)).setTaskHeapMemory(taskExecutorResourceSpec.getTaskHeapSize().divide((long)numberOfSlots)).setTaskOffHeapMemory(taskExecutorResourceSpec.getTaskOffHeapSize().divide((long)numberOfSlots)).setManagedMemory(taskExecutorResourceSpec.getManagedMemorySize().divide((long)numberOfSlots)).setNetworkMemory(taskExecutorResourceSpec.getNetworkMemSize().divide((long)numberOfSlots)).build();
    }

    static ResourceProfile generateTotalAvailableResourceProfile(TaskExecutorResourceSpec taskExecutorResourceSpec) {
        return ResourceProfile.newBuilder().setCpuCores((Resource)taskExecutorResourceSpec.getCpuCores()).setTaskHeapMemory(taskExecutorResourceSpec.getTaskHeapSize()).setTaskOffHeapMemory(taskExecutorResourceSpec.getTaskOffHeapSize()).setManagedMemory(taskExecutorResourceSpec.getManagedMemorySize()).setNetworkMemory(taskExecutorResourceSpec.getNetworkMemSize()).build();
    }

    @VisibleForTesting
    public static TaskExecutorResourceSpec resourceSpecFromConfigForLocalExecution(Configuration config) {
        return TaskExecutorResourceUtils.resourceSpecFromConfig(TaskExecutorResourceUtils.adjustForLocalExecution(config));
    }

    public static long calculateTotalFlinkMemoryFromComponents(Configuration config) {
        Preconditions.checkArgument((boolean)config.contains(TaskManagerOptions.TASK_HEAP_MEMORY));
        Preconditions.checkArgument((boolean)config.contains(TaskManagerOptions.TASK_OFF_HEAP_MEMORY));
        Preconditions.checkArgument((boolean)config.contains(TaskManagerOptions.NETWORK_MEMORY_MAX));
        Preconditions.checkArgument((boolean)config.contains(TaskManagerOptions.NETWORK_MEMORY_MIN));
        Preconditions.checkArgument((boolean)config.contains(TaskManagerOptions.MANAGED_MEMORY_SIZE));
        Preconditions.checkArgument((boolean)config.contains(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY));
        Preconditions.checkArgument((boolean)config.contains(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY));
        Preconditions.checkArgument((boolean)((MemorySize)config.get(TaskManagerOptions.NETWORK_MEMORY_MAX)).equals(config.get(TaskManagerOptions.NETWORK_MEMORY_MIN)));
        return ((MemorySize)config.get(TaskManagerOptions.TASK_HEAP_MEMORY)).add((MemorySize)config.get(TaskManagerOptions.TASK_OFF_HEAP_MEMORY)).add((MemorySize)config.get(TaskManagerOptions.NETWORK_MEMORY_MAX)).add((MemorySize)config.get(TaskManagerOptions.MANAGED_MEMORY_SIZE)).add((MemorySize)config.get(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY)).add((MemorySize)config.get(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY)).getBytes();
    }

    public static long calculateTotalProcessMemoryFromComponents(Configuration config) {
        Preconditions.checkArgument((boolean)config.contains(TaskManagerOptions.JVM_METASPACE));
        Preconditions.checkArgument((boolean)config.contains(TaskManagerOptions.JVM_OVERHEAD_MAX));
        Preconditions.checkArgument((boolean)config.contains(TaskManagerOptions.JVM_OVERHEAD_MIN));
        Preconditions.checkArgument((boolean)((MemorySize)config.get(TaskManagerOptions.JVM_OVERHEAD_MAX)).equals(config.get(TaskManagerOptions.JVM_OVERHEAD_MIN)));
        return TaskExecutorResourceUtils.calculateTotalFlinkMemoryFromComponents(config) + ((MemorySize)config.get(TaskManagerOptions.JVM_METASPACE)).add((MemorySize)config.get(TaskManagerOptions.JVM_OVERHEAD_MAX)).getBytes();
    }

    public static Configuration adjustForLocalExecution(Configuration config) {
        UNUSED_CONFIG_OPTIONS.forEach(option -> TaskExecutorResourceUtils.warnOptionHasNoEffectIfSet(config, option));
        TaskExecutorResourceUtils.setConfigOptionToPassedMaxIfNotSet(config, TaskManagerOptions.CPU_CORES, 1000000.0);
        TaskExecutorResourceUtils.setConfigOptionToPassedMaxIfNotSet(config, TaskManagerOptions.TASK_HEAP_MEMORY, LOCAL_EXECUTION_TASK_MEMORY);
        TaskExecutorResourceUtils.setConfigOptionToPassedMaxIfNotSet(config, TaskManagerOptions.TASK_OFF_HEAP_MEMORY, LOCAL_EXECUTION_TASK_MEMORY);
        TaskExecutorResourceUtils.adjustNetworkMemoryForLocalExecution(config);
        TaskExecutorResourceUtils.setConfigOptionToDefaultIfNotSet(config, TaskManagerOptions.MANAGED_MEMORY_SIZE, DEFAULT_MANAGED_MEMORY_SIZE);
        TaskExecutorResourceUtils.silentlySetConfigOptionIfNotSet(config, TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, TaskManagerOptions.FRAMEWORK_HEAP_MEMORY.defaultValue());
        TaskExecutorResourceUtils.silentlySetConfigOptionIfNotSet(config, TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY.defaultValue());
        TaskExecutorResourceUtils.silentlySetConfigOptionIfNotSet(config, TaskManagerOptions.JVM_METASPACE, TaskManagerOptions.JVM_METASPACE.defaultValue());
        TaskExecutorResourceUtils.silentlySetConfigOptionIfNotSet(config, TaskManagerOptions.JVM_OVERHEAD_MAX, TaskManagerOptions.JVM_OVERHEAD_MAX.defaultValue());
        TaskExecutorResourceUtils.silentlySetConfigOptionIfNotSet(config, TaskManagerOptions.JVM_OVERHEAD_MIN, TaskManagerOptions.JVM_OVERHEAD_MAX.defaultValue());
        return config;
    }

    private static void adjustNetworkMemoryForLocalExecution(Configuration config) {
        if (!config.contains(TaskManagerOptions.NETWORK_MEMORY_MIN) && config.contains(TaskManagerOptions.NETWORK_MEMORY_MAX)) {
            config.set(TaskManagerOptions.NETWORK_MEMORY_MIN, config.get(TaskManagerOptions.NETWORK_MEMORY_MAX));
        }
        if (!config.contains(TaskManagerOptions.NETWORK_MEMORY_MAX) && config.contains(TaskManagerOptions.NETWORK_MEMORY_MIN)) {
            config.set(TaskManagerOptions.NETWORK_MEMORY_MAX, config.get(TaskManagerOptions.NETWORK_MEMORY_MIN));
        }
        TaskExecutorResourceUtils.setConfigOptionToDefaultIfNotSet(config, TaskManagerOptions.NETWORK_MEMORY_MIN, DEFAULT_SHUFFLE_MEMORY_SIZE);
        TaskExecutorResourceUtils.setConfigOptionToDefaultIfNotSet(config, TaskManagerOptions.NETWORK_MEMORY_MAX, DEFAULT_SHUFFLE_MEMORY_SIZE);
    }

    private static void warnOptionHasNoEffectIfSet(Configuration config, ConfigOption<?> option) {
        if (config.contains(option)) {
            LOG.warn("The resource configuration option {} is set but it will have no effect for local execution, only the following options matter for the resource configuration: {}", option, UNUSED_CONFIG_OPTIONS);
        }
    }

    private static <T> void silentlySetConfigOptionIfNotSet(Configuration config, ConfigOption<T> option, T value) {
        if (!config.contains(option)) {
            config.set(option, value);
        }
    }

    private static <T> void setConfigOptionToDefaultIfNotSet(Configuration config, ConfigOption<T> option, T defaultValue) {
        TaskExecutorResourceUtils.setConfigOptionToDefaultIfNotSet(config, option, defaultValue, "its default value " + defaultValue);
    }

    private static <T> void setConfigOptionToPassedMaxIfNotSet(Configuration config, ConfigOption<T> option, T maxValue) {
        TaskExecutorResourceUtils.setConfigOptionToDefaultIfNotSet(config, option, maxValue, "the maximal possible value");
    }

    private static <T> void setConfigOptionToDefaultIfNotSet(Configuration config, ConfigOption<T> option, T defaultValue, String defaultValueLogExt) {
        if (!config.contains(option)) {
            LOG.info("The configuration option {} required for local execution is not set, setting it to {}.", (Object)option.key(), (Object)defaultValueLogExt);
            config.set(option, defaultValue);
        }
    }
}

