/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.AllocatedSlotReport;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotActions;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotInfoWithUtilization;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public interface SlotPool
extends AllocatedSlotActions,
AutoCloseable {
    public void start(JobMasterId var1, String var2, ComponentMainThreadExecutor var3) throws Exception;

    @Override
    public void close();

    public void connectToResourceManager(ResourceManagerGateway var1);

    public void disconnectResourceManager();

    public boolean registerTaskManager(ResourceID var1);

    public boolean releaseTaskManager(ResourceID var1, Exception var2);

    public Collection<SlotOffer> offerSlots(TaskManagerLocation var1, TaskManagerGateway var2, Collection<SlotOffer> var3);

    public Optional<ResourceID> failAllocation(AllocationID var1, Exception var2);

    @Nonnull
    public Collection<SlotInfoWithUtilization> getAvailableSlotsInformation();

    public Collection<SlotInfo> getAllocatedSlotsInformation();

    public Optional<PhysicalSlot> allocateAvailableSlot(@Nonnull SlotRequestId var1, @Nonnull AllocationID var2, @Nonnull ResourceProfile var3);

    @Nonnull
    public CompletableFuture<PhysicalSlot> requestNewAllocatedSlot(@Nonnull SlotRequestId var1, @Nonnull ResourceProfile var2, @Nullable Time var3);

    @Nonnull
    public CompletableFuture<PhysicalSlot> requestNewAllocatedBatchSlot(@Nonnull SlotRequestId var1, @Nonnull ResourceProfile var2);

    public void disableBatchSlotRequestTimeoutCheck();

    public AllocatedSlotReport createAllocatedSlotReport(ResourceID var1);
}

