/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.File;
import java.io.IOException;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionFactory;

public enum BoundedBlockingSubpartitionType {
    FILE{

        @Override
        public BoundedBlockingSubpartition create(int index, ResultPartition parent, File tempFile, int readBufferSize, boolean sslEnabled) throws IOException {
            return BoundedBlockingSubpartition.createWithFileChannel(index, parent, tempFile, readBufferSize, sslEnabled);
        }
    }
    ,
    MMAP{

        @Override
        public BoundedBlockingSubpartition create(int index, ResultPartition parent, File tempFile, int readBufferSize, boolean sslEnabled) throws IOException {
            return BoundedBlockingSubpartition.createWithMemoryMappedFile(index, parent, tempFile);
        }
    }
    ,
    FILE_MMAP{

        @Override
        public BoundedBlockingSubpartition create(int index, ResultPartition parent, File tempFile, int readBufferSize, boolean sslEnabled) throws IOException {
            return BoundedBlockingSubpartition.createWithFileAndMemoryMappedReader(index, parent, tempFile);
        }
    }
    ,
    AUTO{

        @Override
        public BoundedBlockingSubpartition create(int index, ResultPartition parent, File tempFile, int readBufferSize, boolean sslEnabled) throws IOException {
            return ResultPartitionFactory.getBoundedBlockingType().create(index, parent, tempFile, readBufferSize, sslEnabled);
        }
    };


    public abstract BoundedBlockingSubpartition create(int var1, ResultPartition var2, File var3, int var4, boolean var5) throws IOException;
}

