/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PartitionedFileReader;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;

class SortMergeSubpartitionReader
implements ResultSubpartitionView,
Comparable<SortMergeSubpartitionReader> {
    private final Object lock = new Object();
    private final CompletableFuture<?> releaseFuture = new CompletableFuture();
    private final BufferAvailabilityListener availabilityListener;
    @GuardedBy(value="lock")
    private final Queue<Buffer> buffersRead = new ArrayDeque<Buffer>();
    private final PartitionedFileReader fileReader;
    @GuardedBy(value="lock")
    private int dataBufferBacklog;
    @GuardedBy(value="lock")
    private boolean isReleased;
    @GuardedBy(value="lock")
    private Throwable failureCause;
    private int sequenceNumber;

    SortMergeSubpartitionReader(BufferAvailabilityListener listener, PartitionedFileReader fileReader) {
        this.availabilityListener = (BufferAvailabilityListener)Preconditions.checkNotNull((Object)listener);
        this.fileReader = (PartitionedFileReader)Preconditions.checkNotNull((Object)fileReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResultSubpartition.BufferAndBacklog getNextBuffer() {
        Object object = this.lock;
        synchronized (object) {
            Buffer lookAhead;
            Buffer buffer = this.buffersRead.poll();
            if (buffer == null) {
                return null;
            }
            if (buffer.isBuffer()) {
                --this.dataBufferBacklog;
            }
            Buffer.DataType dataType = (lookAhead = this.buffersRead.peek()) == null ? Buffer.DataType.NONE : lookAhead.getDataType();
            return ResultSubpartition.BufferAndBacklog.fromBufferAndLookahead(buffer, dataType, this.dataBufferBacklog, this.sequenceNumber++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuffer(Buffer buffer) {
        boolean notifyAvailable;
        Object object = this.lock;
        synchronized (object) {
            if (this.isReleased) {
                buffer.recycleBuffer();
                throw new IllegalStateException("Subpartition reader has been already released.");
            }
            notifyAvailable = this.buffersRead.isEmpty();
            this.buffersRead.add(buffer);
            if (buffer.isBuffer()) {
                ++this.dataBufferBacklog;
            }
        }
        if (notifyAvailable) {
            this.notifyDataAvailable();
        }
    }

    boolean readBuffers(Queue<MemorySegment> buffers, BufferRecycler recycler) throws IOException {
        while (!buffers.isEmpty()) {
            Buffer buffer;
            MemorySegment segment = buffers.poll();
            try {
                buffer = this.fileReader.readCurrentRegion(segment, recycler);
                if (buffer == null) {
                    buffers.add(segment);
                    break;
                }
            }
            catch (Throwable throwable) {
                buffers.add(segment);
                throw throwable;
            }
            this.addBuffer(buffer);
        }
        return this.fileReader.hasRemaining();
    }

    CompletableFuture<?> getReleaseFuture() {
        return this.releaseFuture;
    }

    void fail(Throwable throwable) {
        Preconditions.checkArgument((throwable != null ? 1 : 0) != 0, (Object)"Must be not null.");
        this.releaseInternal(throwable);
        this.notifyDataAvailable();
    }

    @Override
    public void notifyDataAvailable() {
        this.availabilityListener.notifyDataAvailable();
    }

    @Override
    public int compareTo(SortMergeSubpartitionReader that) {
        long thatPriority;
        long thisPriority = this.fileReader.getPriority();
        if (thisPriority == (thatPriority = that.fileReader.getPriority())) {
            return 0;
        }
        return thisPriority > thatPriority ? 1 : -1;
    }

    @Override
    public void releaseAllResources() {
        this.releaseInternal(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInternal(@Nullable Throwable throwable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isReleased) {
                return;
            }
            this.isReleased = true;
            if (this.failureCause == null) {
                this.failureCause = throwable;
            }
            for (Buffer buffer : this.buffersRead) {
                buffer.recycleBuffer();
            }
            this.buffersRead.clear();
        }
        this.releaseFuture.complete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReleased() {
        Object object = this.lock;
        synchronized (object) {
            return this.isReleased;
        }
    }

    @Override
    public void resumeConsumption() {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Throwable getFailureCause() {
        Object object = this.lock;
        synchronized (object) {
            return this.failureCause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable(int numCreditsAvailable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isReleased) {
                return true;
            }
            if (this.buffersRead.isEmpty()) {
                return false;
            }
            return numCreditsAvailable > 0 || !this.buffersRead.peek().isBuffer();
        }
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return Math.max(0, this.buffersRead.size());
    }
}

