/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.core.memory.SeekableDataInputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.runtime.memory.ListMemorySegmentSource;

public class InMemoryPartition<T> {
    protected MemorySegment[] overflowSegments = new MemorySegment[2];
    protected int numOverflowSegments = 0;
    protected int nextOverflowBucket = 0;
    private final TypeSerializer<T> serializer;
    private final ArrayList<MemorySegment> partitionPages;
    private final ListMemorySegmentSource availableMemory;
    private WriteView writeView;
    private ReadView readView;
    private long recordCounter;
    private int partitionNumber;
    private boolean compacted;
    private int pageSize;
    private int pageSizeInBits;

    public InMemoryPartition(TypeSerializer<T> serializer, int partitionNumber, ListMemorySegmentSource memSource, int pageSize, int pageSizeInBits) {
        this.serializer = serializer;
        this.partitionPages = new ArrayList(64);
        this.availableMemory = memSource;
        this.partitionNumber = partitionNumber;
        this.partitionPages.add(memSource.nextSegment());
        this.compacted = true;
        this.pageSize = pageSize;
        this.pageSizeInBits = pageSizeInBits;
        this.writeView = new WriteView(this.partitionPages, memSource, pageSize, pageSizeInBits);
        this.readView = new ReadView(this.partitionPages, pageSize, pageSizeInBits);
    }

    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public void setPartitionNumber(int number) {
        this.partitionNumber = number;
    }

    public int getBlockCount() {
        return this.partitionPages.size();
    }

    public long getRecordCount() {
        return this.recordCounter;
    }

    public void resetRecordCounter() {
        this.recordCounter = 0L;
    }

    public void resetRWViews() {
        this.writeView.resetTo(0L);
        this.readView.setReadPosition(0L);
    }

    public void pushDownPages() {
        this.writeView = new WriteView(this.partitionPages, this.availableMemory, this.pageSize, this.pageSizeInBits);
        this.readView = new ReadView(this.partitionPages, this.pageSize, this.pageSizeInBits);
    }

    public ArrayList<MemorySegment> resetOverflowBuckets() {
        this.numOverflowSegments = 0;
        this.nextOverflowBucket = 0;
        ArrayList<MemorySegment> result = new ArrayList<MemorySegment>(this.overflowSegments.length);
        for (int i = 0; i < this.overflowSegments.length; ++i) {
            if (this.overflowSegments[i] == null) continue;
            result.add(this.overflowSegments[i]);
        }
        this.overflowSegments = new MemorySegment[2];
        return result;
    }

    public boolean isCompacted() {
        return this.compacted;
    }

    public void setIsCompacted(boolean compacted) {
        this.compacted = compacted;
    }

    public final long appendRecord(T record) throws IOException {
        long pointer = this.writeView.getCurrentPointer();
        try {
            this.serializer.serialize(record, (DataOutputView)this.writeView);
            ++this.recordCounter;
            return pointer;
        }
        catch (EOFException e) {
            this.writeView.resetTo(pointer);
            throw e;
        }
    }

    public T readRecordAt(long pointer, T reuse) throws IOException {
        this.readView.setReadPosition(pointer);
        return (T)this.serializer.deserialize(reuse, (DataInputView)this.readView);
    }

    public T readRecordAt(long pointer) throws IOException {
        this.readView.setReadPosition(pointer);
        return (T)this.serializer.deserialize((DataInputView)this.readView);
    }

    @Deprecated
    public void overwriteRecordAt(long pointer, T record) throws IOException {
        long tmpPointer = this.writeView.getCurrentPointer();
        this.writeView.resetTo(pointer);
        this.serializer.serialize(record, (DataOutputView)this.writeView);
        this.writeView.resetTo(tmpPointer);
    }

    public void clearAllMemory(List<MemorySegment> target) {
        if (this.overflowSegments != null) {
            for (int k = 0; k < this.numOverflowSegments; ++k) {
                target.add(this.overflowSegments[k]);
            }
        }
        target.addAll(this.partitionPages);
        this.partitionPages.clear();
    }

    public void allocateSegments(int numberOfSegments) {
        while (this.getBlockCount() < numberOfSegments) {
            MemorySegment next = this.availableMemory.nextSegment();
            if (next != null) {
                this.partitionPages.add(next);
                continue;
            }
            return;
        }
    }

    public String toString() {
        return String.format("Partition %d - %d records, %d partition blocks, %d bucket overflow blocks", this.getPartitionNumber(), this.getRecordCount(), this.getBlockCount(), this.numOverflowSegments);
    }

    private static final class ReadView
    extends AbstractPagedInputView
    implements SeekableDataInputView {
        private final ArrayList<MemorySegment> segments;
        private final int segmentSizeBits;
        private final int segmentSizeMask;
        private int currentSegmentIndex;
        private int segmentNumberOffset;

        public ReadView(ArrayList<MemorySegment> segments, int segmentSize, int segmentSizeBits) {
            super(segments.get(0), segmentSize, 0);
            if ((segmentSize & segmentSize - 1) != 0) {
                throw new IllegalArgumentException("Segment size must be a power of 2!");
            }
            this.segments = segments;
            this.segmentSizeBits = segmentSizeBits;
            this.segmentSizeMask = segmentSize - 1;
            this.segmentNumberOffset = 0;
        }

        @Override
        protected MemorySegment nextSegment(MemorySegment current) throws EOFException {
            if (++this.currentSegmentIndex < this.segments.size()) {
                return this.segments.get(this.currentSegmentIndex);
            }
            throw new EOFException();
        }

        @Override
        protected int getLimitForSegment(MemorySegment segment) {
            return this.segmentSizeMask + 1;
        }

        public void setReadPosition(long position) {
            int bufferNum = (int)(position >>> this.segmentSizeBits) - this.segmentNumberOffset;
            int offset = (int)(position & (long)this.segmentSizeMask);
            this.currentSegmentIndex = bufferNum;
            this.seekInput(this.segments.get(bufferNum), offset, this.segmentSizeMask + 1);
        }

        public void setSegmentNumberOffset(int offset) {
            this.segmentNumberOffset = offset;
        }
    }

    private static final class WriteView
    extends AbstractPagedOutputView {
        private final ArrayList<MemorySegment> pages;
        private final MemorySegmentSource memSource;
        private final int sizeBits;
        private final int sizeMask;
        private int currentPageNumber;
        private int segmentNumberOffset;

        private WriteView(ArrayList<MemorySegment> pages, MemorySegmentSource memSource, int pageSize, int pageSizeBits) {
            super(pages.get(0), pageSize, 0);
            this.pages = pages;
            this.memSource = memSource;
            this.sizeBits = pageSizeBits;
            this.sizeMask = pageSize - 1;
            this.segmentNumberOffset = 0;
        }

        @Override
        protected MemorySegment nextSegment(MemorySegment current, int bytesUsed) throws IOException {
            MemorySegment next = this.memSource.nextSegment();
            if (next == null) {
                throw new EOFException();
            }
            this.pages.add(next);
            ++this.currentPageNumber;
            return next;
        }

        private long getCurrentPointer() {
            return ((long)this.currentPageNumber << this.sizeBits) + (long)this.getCurrentPositionInSegment();
        }

        private int resetTo(long pointer) {
            int pageNum = (int)(pointer >>> this.sizeBits);
            int offset = (int)(pointer & (long)this.sizeMask);
            this.currentPageNumber = pageNum;
            int posInArray = pageNum - this.segmentNumberOffset;
            this.seekOutput(this.pages.get(posInArray), offset);
            return posInArray;
        }

        public void setSegmentNumberOffset(int offset) {
            this.segmentNumberOffset = offset;
        }
    }
}

