/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.client.JobInitializationException;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmaster.JobManagerRunnerResult;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterService;
import org.apache.flink.runtime.jobmaster.JobMasterServiceProcess;
import org.apache.flink.runtime.jobmaster.JobNotFinishedException;
import org.apache.flink.runtime.jobmaster.factories.JobMasterServiceFactory;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJobMasterServiceProcess
implements JobMasterServiceProcess,
OnCompletionActions {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJobMasterServiceProcess.class);
    private final Object lock = new Object();
    private final JobID jobId;
    private final UUID leaderSessionId;
    private final CompletableFuture<JobMasterService> jobMasterServiceFuture;
    private final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    private final CompletableFuture<JobManagerRunnerResult> resultFuture = new CompletableFuture();
    private final CompletableFuture<JobMasterGateway> jobMasterGatewayFuture = new CompletableFuture();
    private final CompletableFuture<String> leaderAddressFuture = new CompletableFuture();
    @GuardedBy(value="lock")
    private boolean isRunning = true;

    public DefaultJobMasterServiceProcess(JobID jobId, UUID leaderSessionId, JobMasterServiceFactory jobMasterServiceFactory, Function<Throwable, ArchivedExecutionGraph> failedArchivedExecutionGraphFactory) {
        this.jobId = jobId;
        this.leaderSessionId = leaderSessionId;
        this.jobMasterServiceFuture = jobMasterServiceFactory.createJobMasterService(leaderSessionId, this);
        this.jobMasterServiceFuture.whenComplete((jobMasterService, throwable) -> {
            if (throwable != null) {
                JobInitializationException jobInitializationException = new JobInitializationException(jobId, "Could not start the JobMaster.", (Throwable)throwable);
                LOG.debug("Initialization of the JobMasterService for job {} under leader id {} failed.", new Object[]{jobId, leaderSessionId, jobInitializationException});
                this.resultFuture.complete(JobManagerRunnerResult.forInitializationFailure(new ExecutionGraphInfo((ArchivedExecutionGraph)failedArchivedExecutionGraphFactory.apply((Throwable)((Object)jobInitializationException))), (Throwable)((Object)jobInitializationException)));
            } else {
                this.registerJobMasterServiceFutures((JobMasterService)jobMasterService);
            }
        });
    }

    private void registerJobMasterServiceFutures(JobMasterService jobMasterService) {
        LOG.debug("Successfully created the JobMasterService for job {} under leader id {}.", (Object)this.jobId, (Object)this.leaderSessionId);
        this.jobMasterGatewayFuture.complete(jobMasterService.getGateway());
        this.leaderAddressFuture.complete(jobMasterService.getAddress());
        jobMasterService.getTerminationFuture().whenComplete((unused, throwable) -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.isRunning) {
                    LOG.warn("Unexpected termination of the JobMasterService for job {} under leader id {}.", (Object)this.jobId, (Object)this.leaderSessionId);
                    this.jobMasterFailed((Throwable)new FlinkException("Unexpected termination of the JobMasterService.", throwable));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning) {
                this.isRunning = false;
                LOG.debug("Terminating the JobMasterService process for job {} under leader id {}.", (Object)this.jobId, (Object)this.leaderSessionId);
                this.resultFuture.completeExceptionally((Throwable)((Object)new JobNotFinishedException(this.jobId)));
                this.jobMasterGatewayFuture.completeExceptionally((Throwable)new FlinkException("Process has been closed."));
                this.jobMasterServiceFuture.whenComplete((jobMasterService, throwable) -> {
                    if (throwable != null) {
                        this.terminationFuture.complete(null);
                    } else {
                        FutureUtils.forward(jobMasterService.closeAsync(), this.terminationFuture);
                    }
                });
                this.terminationFuture.whenComplete((unused, throwable) -> LOG.debug("JobMasterService process for job {} under leader id {} has been terminated.", (Object)this.jobId, (Object)this.leaderSessionId));
            }
        }
        return this.terminationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitializedAndRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.jobMasterServiceFuture.isDone() && !this.jobMasterServiceFuture.isCompletedExceptionally() && this.isRunning;
        }
    }

    @Override
    public CompletableFuture<JobMasterGateway> getJobMasterGatewayFuture() {
        return this.jobMasterGatewayFuture;
    }

    @Override
    public CompletableFuture<JobManagerRunnerResult> getResultFuture() {
        return this.resultFuture;
    }

    @Override
    public CompletableFuture<String> getLeaderAddressFuture() {
        return this.leaderAddressFuture;
    }

    @Override
    public void jobReachedGloballyTerminalState(ExecutionGraphInfo executionGraphInfo) {
        LOG.debug("Job {} under leader id {} reached a globally terminal state {}.", new Object[]{this.jobId, this.leaderSessionId, executionGraphInfo.getArchivedExecutionGraph().getState()});
        this.resultFuture.complete(JobManagerRunnerResult.forSuccess(executionGraphInfo));
    }

    @Override
    public void jobMasterFailed(Throwable cause) {
        LOG.debug("Job {} under leader id {} failed.", (Object)this.jobId, (Object)this.leaderSessionId);
        this.resultFuture.completeExceptionally(cause);
    }
}

