/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.router;

import java.util.Map;
import org.apache.flink.util.Preconditions;

final class PathPattern {
    private final String pattern;
    private final String[] tokens;

    public PathPattern(String pattern) {
        if (pattern.contains("?")) {
            throw new IllegalArgumentException("Path pattern must not contain query");
        }
        this.pattern = PathPattern.removeSlashesAtBothEnds((String)Preconditions.checkNotNull((Object)pattern, (String)"pattern"));
        this.tokens = this.pattern.split("/");
    }

    public static String removeSlashesAtBothEnds(String path) {
        int endIndex;
        int beginIndex;
        Preconditions.checkNotNull((Object)path, (String)"path");
        if (path.isEmpty()) {
            return path;
        }
        for (beginIndex = 0; beginIndex < path.length() && path.charAt(beginIndex) == '/'; ++beginIndex) {
        }
        if (beginIndex == path.length()) {
            return "";
        }
        for (endIndex = path.length() - 1; endIndex > beginIndex && path.charAt(endIndex) == '/'; --endIndex) {
        }
        return path.substring(beginIndex, endIndex + 1);
    }

    public String pattern() {
        return this.pattern;
    }

    public String[] tokens() {
        return this.tokens;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathPattern)) {
            return false;
        }
        PathPattern otherPathPattern = (PathPattern)o;
        return this.pattern.equals(otherPathPattern.pattern);
    }

    public boolean match(String[] requestPathTokens, Map<String, String> params) {
        if (this.tokens.length == requestPathTokens.length) {
            for (int i = 0; i < this.tokens.length; ++i) {
                String key = this.tokens[i];
                String value = requestPathTokens[i];
                if (key.length() > 0 && key.charAt(0) == ':') {
                    params.put(key.substring(1), value);
                    continue;
                }
                if (key.equals(value)) continue;
                return false;
            }
            return true;
        }
        if (this.tokens.length > 0 && this.tokens[this.tokens.length - 1].equals(":*") && this.tokens.length <= requestPathTokens.length) {
            for (int i = 0; i < this.tokens.length - 2; ++i) {
                String key = this.tokens[i];
                String value = requestPathTokens[i];
                if (key.length() > 0 && key.charAt(0) == ':') {
                    params.put(key.substring(1), value);
                    continue;
                }
                if (key.equals(value)) continue;
                return false;
            }
            StringBuilder b = new StringBuilder(requestPathTokens[this.tokens.length - 1]);
            for (int i = this.tokens.length; i < requestPathTokens.length; ++i) {
                b.append('/');
                b.append(requestPathTokens[i]);
            }
            params.put("*", b.toString());
            return true;
        }
        return false;
    }
}

