/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.dispatcher.ArchivedExecutionGraphStore;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.HistoryServerArchivist;
import org.apache.flink.runtime.dispatcher.SingleJobSubmittedJobGraphStore;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class MiniDispatcher
extends Dispatcher {
    private final ClusterEntrypoint.ExecutionMode executionMode;
    private final CompletableFuture<ApplicationStatus> jobTerminationFuture;

    public MiniDispatcher(RpcService rpcService, String endpointId, Configuration configuration, HighAvailabilityServices highAvailabilityServices, ResourceManagerGateway resourceManagerGateway, BlobServer blobServer, HeartbeatServices heartbeatServices, JobManagerMetricGroup jobManagerMetricGroup, @Nullable String metricQueryServicePath, ArchivedExecutionGraphStore archivedExecutionGraphStore, Dispatcher.JobManagerRunnerFactory jobManagerRunnerFactory, FatalErrorHandler fatalErrorHandler, @Nullable String restAddress, HistoryServerArchivist historyServerArchivist, JobGraph jobGraph, ClusterEntrypoint.ExecutionMode executionMode) throws Exception {
        super(rpcService, endpointId, configuration, highAvailabilityServices, new SingleJobSubmittedJobGraphStore(jobGraph), resourceManagerGateway, blobServer, heartbeatServices, jobManagerMetricGroup, metricQueryServicePath, archivedExecutionGraphStore, jobManagerRunnerFactory, fatalErrorHandler, restAddress, historyServerArchivist);
        this.executionMode = (ClusterEntrypoint.ExecutionMode)((Object)Preconditions.checkNotNull((Object)((Object)executionMode)));
        this.jobTerminationFuture = new CompletableFuture();
    }

    public CompletableFuture<ApplicationStatus> getJobTerminationFuture() {
        return this.jobTerminationFuture;
    }

    @Override
    public CompletableFuture<Acknowledge> submitJob(JobGraph jobGraph, Time timeout) {
        CompletableFuture<Acknowledge> acknowledgeCompletableFuture = super.submitJob(jobGraph, timeout);
        acknowledgeCompletableFuture.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                this.onFatalError(new FlinkException("Failed to submit job " + jobGraph.getJobID() + " in job mode.", throwable));
            }
        });
        return acknowledgeCompletableFuture;
    }

    @Override
    public CompletableFuture<JobResult> requestJobResult(JobID jobId, Time timeout) {
        CompletableFuture<JobResult> jobResultFuture = super.requestJobResult(jobId, timeout);
        if (this.executionMode == ClusterEntrypoint.ExecutionMode.NORMAL) {
            jobResultFuture.thenAccept(result -> {
                ApplicationStatus status = result.getSerializedThrowable().isPresent() ? ApplicationStatus.FAILED : ApplicationStatus.SUCCEEDED;
                this.jobTerminationFuture.complete(status);
            });
        }
        return jobResultFuture;
    }

    @Override
    protected void jobReachedGloballyTerminalState(ArchivedExecutionGraph archivedExecutionGraph) {
        super.jobReachedGloballyTerminalState(archivedExecutionGraph);
        if (this.executionMode == ClusterEntrypoint.ExecutionMode.DETACHED) {
            this.jobTerminationFuture.complete(ApplicationStatus.fromJobStatus(archivedExecutionGraph.getState()));
        }
    }

    @Override
    protected void jobNotFinished(JobID jobId) {
        super.jobNotFinished(jobId);
        this.jobTerminationFuture.complete(ApplicationStatus.UNKNOWN);
    }
}

