/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;

public class IntermediateResult {
    private final IntermediateDataSetID id;
    private final ExecutionJobVertex producer;
    private final IntermediateResultPartition[] partitions;
    private final HashMap<IntermediateResultPartitionID, Integer> partitionLookupHelper = new HashMap();
    private final int numParallelProducers;
    private final AtomicInteger numberOfRunningProducers;
    private int partitionsAssigned;
    private int numConsumers;
    private final int connectionIndex;
    private final ResultPartitionType resultType;

    public IntermediateResult(IntermediateDataSetID id, ExecutionJobVertex producer, int numParallelProducers, ResultPartitionType resultType) {
        this.id = (IntermediateDataSetID)((Object)Preconditions.checkNotNull((Object)((Object)id)));
        this.producer = (ExecutionJobVertex)Preconditions.checkNotNull((Object)producer);
        Preconditions.checkArgument((numParallelProducers >= 1 ? 1 : 0) != 0);
        this.numParallelProducers = numParallelProducers;
        this.partitions = new IntermediateResultPartition[numParallelProducers];
        this.numberOfRunningProducers = new AtomicInteger(numParallelProducers);
        this.connectionIndex = (int)(Math.random() * 2.147483647E9);
        this.resultType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)resultType)));
    }

    public void setPartition(int partitionNumber, IntermediateResultPartition partition) {
        if (partition == null || partitionNumber < 0 || partitionNumber >= this.numParallelProducers) {
            throw new IllegalArgumentException();
        }
        if (this.partitions[partitionNumber] != null) {
            throw new IllegalStateException("Partition #" + partitionNumber + " has already been assigned.");
        }
        this.partitions[partitionNumber] = partition;
        this.partitionLookupHelper.put(partition.getPartitionId(), partitionNumber);
        ++this.partitionsAssigned;
    }

    public IntermediateDataSetID getId() {
        return this.id;
    }

    public ExecutionJobVertex getProducer() {
        return this.producer;
    }

    public IntermediateResultPartition[] getPartitions() {
        return this.partitions;
    }

    public IntermediateResultPartition getPartitionById(IntermediateResultPartitionID resultPartitionId) {
        Integer partitionNumber = this.partitionLookupHelper.get(Preconditions.checkNotNull((Object)((Object)resultPartitionId), (String)"IntermediateResultPartitionID"));
        if (partitionNumber != null) {
            return this.partitions[partitionNumber];
        }
        throw new IllegalArgumentException("Unknown intermediate result partition ID " + (Object)((Object)resultPartitionId));
    }

    public int getNumberOfAssignedPartitions() {
        return this.partitionsAssigned;
    }

    public ResultPartitionType getResultType() {
        return this.resultType;
    }

    public int registerConsumer() {
        int index = this.numConsumers++;
        for (IntermediateResultPartition p : this.partitions) {
            if (p.addConsumerGroup() == index) continue;
            throw new RuntimeException("Inconsistent consumer mapping between intermediate result partitions.");
        }
        return index;
    }

    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    void resetForNewExecution() {
        this.numberOfRunningProducers.set(this.numParallelProducers);
    }

    int decrementNumberOfRunningProducersAndGetRemaining() {
        return this.numberOfRunningProducers.decrementAndGet();
    }

    boolean isConsumable() {
        if (this.resultType.isPipelined()) {
            return true;
        }
        return this.numberOfRunningProducers.get() == 0;
    }

    public String toString() {
        return "IntermediateResult " + this.id.toString();
    }
}

