/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.checkpoint;

import java.io.Serializable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.checkpoint.AbstractCheckpointMessage;

public class AcknowledgeCheckpoint
extends AbstractCheckpointMessage
implements Serializable {
    private static final long serialVersionUID = -7606214777192401493L;
    private final TaskStateSnapshot subtaskState;
    private final CheckpointMetrics checkpointMetrics;

    public AcknowledgeCheckpoint(JobID job, ExecutionAttemptID taskExecutionId, long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot subtaskState) {
        super(job, taskExecutionId, checkpointId);
        this.subtaskState = subtaskState;
        this.checkpointMetrics = checkpointMetrics;
    }

    @VisibleForTesting
    public AcknowledgeCheckpoint(JobID jobId, ExecutionAttemptID taskExecutionId, long checkpointId) {
        this(jobId, taskExecutionId, checkpointId, new CheckpointMetrics(), null);
    }

    public TaskStateSnapshot getSubtaskState() {
        return this.subtaskState;
    }

    public CheckpointMetrics getCheckpointMetrics() {
        return this.checkpointMetrics;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AcknowledgeCheckpoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AcknowledgeCheckpoint that = (AcknowledgeCheckpoint)o;
        return this.subtaskState != null ? this.subtaskState.equals(that.subtaskState) : that.subtaskState == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.subtaskState != null ? this.subtaskState.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return String.format("Confirm Task Checkpoint %d for (%s/%s) - state=%s", new Object[]{this.getCheckpointId(), this.getJob(), this.getTaskExecutionId(), this.subtaskState});
    }
}

