/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.util;

import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.runtime.rest.handler.util.MimeTypes;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class HandlerRedirectUtils {
    public static final Charset ENCODING = ConfigConstants.DEFAULT_CHARSET;

    public static CompletableFuture<Optional<String>> getRedirectAddress(String localRestAddress, RestfulGateway restfulGateway, Time timeout) {
        return restfulGateway.requestRestAddress(timeout).thenApply(remoteRestAddress -> {
            if (Objects.equals(localRestAddress, remoteRestAddress)) {
                return Optional.empty();
            }
            return Optional.of(remoteRestAddress);
        });
    }

    public static HttpResponse getRedirectResponse(String redirectAddress, String path) {
        return HandlerRedirectUtils.getRedirectResponse(redirectAddress, path, HttpResponseStatus.TEMPORARY_REDIRECT);
    }

    public static HttpResponse getRedirectResponse(String redirectAddress, String path, HttpResponseStatus code) {
        Preconditions.checkNotNull((Object)redirectAddress, (String)"Redirect address");
        Preconditions.checkNotNull((Object)path, (String)"Path");
        String newLocation = String.format("%s%s", redirectAddress, path);
        DefaultFullHttpResponse redirectResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, code);
        redirectResponse.headers().set("Location", (Object)newLocation);
        redirectResponse.headers().set("Content-Length", (Object)0);
        return redirectResponse;
    }

    public static HttpResponse getUnavailableResponse() {
        String result = "Service temporarily unavailable due to an ongoing leader election. Please refresh.";
        byte[] bytes = result.getBytes(ConfigConstants.DEFAULT_CHARSET);
        DefaultFullHttpResponse unavailableResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SERVICE_UNAVAILABLE, Unpooled.wrappedBuffer((byte[])bytes));
        unavailableResponse.headers().set("Content-Length", (Object)bytes.length);
        unavailableResponse.headers().set("Content-Type", (Object)MimeTypes.getMimeTypeForExtension("txt"));
        return unavailableResponse;
    }

    public static HttpResponse getResponse(HttpResponseStatus status, @Nullable String message) {
        ByteBuf messageByteBuf = message == null ? Unpooled.buffer((int)0) : Unpooled.wrappedBuffer((byte[])message.getBytes(ENCODING));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, messageByteBuf);
        response.headers().set("Content-Type", (Object)("text/plain; charset=" + ENCODING.name()));
        response.headers().set("Content-Length", (Object)response.content().readableBytes());
        return response;
    }

    public static HttpResponse getErrorResponse(Throwable throwable) {
        return HandlerRedirectUtils.getErrorResponse(throwable, HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    public static HttpResponse getErrorResponse(Throwable throwable, HttpResponseStatus status) {
        byte[] bytes = ExceptionUtils.stringifyException((Throwable)throwable).getBytes(ENCODING);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.wrappedBuffer((byte[])bytes));
        response.headers().set("Content-Type", (Object)("text/plain; charset=" + ENCODING.name()));
        response.headers().set("Content-Length", (Object)response.content().readableBytes());
        return response;
    }
}

