/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;

public class RegisteredKeyValueStateBackendMetaInfo<N, S>
extends RegisteredStateMetaInfoBase {
    @Nonnull
    private final StateDescriptor.Type stateType;
    @Nonnull
    private final TypeSerializer<N> namespaceSerializer;
    @Nonnull
    private final TypeSerializer<S> stateSerializer;
    @Nullable
    private final StateSnapshotTransformer<S> snapshotTransformer;

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull StateDescriptor.Type stateType, @Nonnull String name, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull TypeSerializer<S> stateSerializer) {
        this(stateType, name, namespaceSerializer, stateSerializer, null);
    }

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull StateDescriptor.Type stateType, @Nonnull String name, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull TypeSerializer<S> stateSerializer, @Nullable StateSnapshotTransformer<S> snapshotTransformer) {
        super(name);
        this.stateType = stateType;
        this.namespaceSerializer = namespaceSerializer;
        this.stateSerializer = stateSerializer;
        this.snapshotTransformer = snapshotTransformer;
    }

    public RegisteredKeyValueStateBackendMetaInfo(@Nonnull StateMetaInfoSnapshot snapshot) {
        this(StateDescriptor.Type.valueOf((String)snapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE)), snapshot.getName(), (TypeSerializer)Preconditions.checkNotNull(snapshot.restoreTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER)), (TypeSerializer)Preconditions.checkNotNull(snapshot.restoreTypeSerializer(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER)), null);
        Preconditions.checkState((StateMetaInfoSnapshot.BackendStateType.KEY_VALUE == snapshot.getBackendStateType() ? 1 : 0) != 0);
    }

    @Nonnull
    public StateDescriptor.Type getStateType() {
        return this.stateType;
    }

    @Nonnull
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    @Nonnull
    public TypeSerializer<S> getStateSerializer() {
        return this.stateSerializer;
    }

    @Nullable
    public StateSnapshotTransformer<S> getSnapshotTransformer() {
        return this.snapshotTransformer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredKeyValueStateBackendMetaInfo that = (RegisteredKeyValueStateBackendMetaInfo)o;
        if (!this.stateType.equals((Object)that.stateType)) {
            return false;
        }
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        return this.getStateSerializer().equals(that.getStateSerializer()) && this.getNamespaceSerializer().equals(that.getNamespaceSerializer());
    }

    public String toString() {
        return "RegisteredKeyedBackendStateMetaInfo{stateType=" + this.stateType + ", name='" + this.name + '\'' + ", namespaceSerializer=" + this.namespaceSerializer + ", stateSerializer=" + this.stateSerializer + '}';
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getStateType().hashCode();
        result = 31 * result + this.getNamespaceSerializer().hashCode();
        result = 31 * result + this.getStateSerializer().hashCode();
        return result;
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    public static void checkStateMetaInfo(StateMetaInfoSnapshot stateMetaInfoSnapshot, StateDescriptor<?, ?> stateDesc) {
        Preconditions.checkState((stateMetaInfoSnapshot != null ? 1 : 0) != 0, (Object)"Requested to check compatibility of a restored RegisteredKeyedBackendStateMetaInfo, but its corresponding restored snapshot cannot be found.");
        Preconditions.checkState((stateMetaInfoSnapshot.getBackendStateType() == StateMetaInfoSnapshot.BackendStateType.KEY_VALUE ? 1 : 0) != 0, (Object)("Incompatible state types. Was [" + (Object)((Object)stateMetaInfoSnapshot.getBackendStateType()) + "], registered as [" + (Object)((Object)StateMetaInfoSnapshot.BackendStateType.KEY_VALUE) + "]."));
        Preconditions.checkState((boolean)Objects.equals(stateDesc.getName(), stateMetaInfoSnapshot.getName()), (Object)("Incompatible state names. Was [" + stateMetaInfoSnapshot.getName() + "], registered with [" + stateDesc.getName() + "]."));
        StateDescriptor.Type restoredType = StateDescriptor.Type.valueOf((String)stateMetaInfoSnapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE));
        if (stateDesc.getType() != StateDescriptor.Type.UNKNOWN && restoredType != StateDescriptor.Type.UNKNOWN) {
            Preconditions.checkState((stateDesc.getType() == restoredType ? 1 : 0) != 0, (Object)("Incompatible key/value state types. Was [" + restoredType + "], registered with [" + stateDesc.getType() + "]."));
        }
    }

    @Nonnull
    private StateMetaInfoSnapshot computeSnapshot() {
        Map<String, String> optionsMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE.toString(), this.stateType.toString());
        HashMap serializerMap = new HashMap(2);
        HashMap serializerConfigSnapshotsMap = new HashMap(2);
        String namespaceSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER.toString();
        String valueSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString();
        serializerMap.put(namespaceSerializerKey, this.namespaceSerializer.duplicate());
        serializerConfigSnapshotsMap.put(namespaceSerializerKey, this.namespaceSerializer.snapshotConfiguration());
        serializerMap.put(valueSerializerKey, this.stateSerializer.duplicate());
        serializerConfigSnapshotsMap.put(valueSerializerKey, this.stateSerializer.snapshotConfiguration());
        return new StateMetaInfoSnapshot(this.name, StateMetaInfoSnapshot.BackendStateType.KEY_VALUE, optionsMap, serializerConfigSnapshotsMap, serializerMap);
    }
}

