/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.registration.RegisteredRpcConnection;
import org.apache.flink.runtime.registration.RegistrationConnectionListener;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationSuccess;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class TaskExecutorToResourceManagerConnection
extends RegisteredRpcConnection<ResourceManagerId, ResourceManagerGateway, TaskExecutorRegistrationSuccess> {
    private final RpcService rpcService;
    private final String taskManagerAddress;
    private final ResourceID taskManagerResourceId;
    private final int dataPort;
    private final HardwareDescription hardwareDescription;
    private final RegistrationConnectionListener<TaskExecutorToResourceManagerConnection, TaskExecutorRegistrationSuccess> registrationListener;

    public TaskExecutorToResourceManagerConnection(Logger log, RpcService rpcService, String taskManagerAddress, ResourceID taskManagerResourceId, int dataPort, HardwareDescription hardwareDescription, String resourceManagerAddress, ResourceManagerId resourceManagerId, Executor executor, RegistrationConnectionListener<TaskExecutorToResourceManagerConnection, TaskExecutorRegistrationSuccess> registrationListener) {
        super(log, resourceManagerAddress, resourceManagerId, executor);
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService);
        this.taskManagerAddress = (String)Preconditions.checkNotNull((Object)taskManagerAddress);
        this.taskManagerResourceId = (ResourceID)Preconditions.checkNotNull((Object)taskManagerResourceId);
        this.dataPort = dataPort;
        this.hardwareDescription = (HardwareDescription)Preconditions.checkNotNull((Object)hardwareDescription);
        this.registrationListener = (RegistrationConnectionListener)Preconditions.checkNotNull(registrationListener);
    }

    @Override
    protected RetryingRegistration<ResourceManagerId, ResourceManagerGateway, TaskExecutorRegistrationSuccess> generateRegistration() {
        return new ResourceManagerRegistration(this.log, this.rpcService, this.getTargetAddress(), (ResourceManagerId)((Object)this.getTargetLeaderId()), this.taskManagerAddress, this.taskManagerResourceId, this.dataPort, this.hardwareDescription);
    }

    @Override
    protected void onRegistrationSuccess(TaskExecutorRegistrationSuccess success) {
        this.log.info("Successful registration at resource manager {} under registration id {}.", (Object)this.getTargetAddress(), (Object)success.getRegistrationId());
        this.registrationListener.onRegistrationSuccess(this, success);
    }

    @Override
    protected void onRegistrationFailure(Throwable failure) {
        this.log.info("Failed to register at resource manager {}.", (Object)this.getTargetAddress(), (Object)failure);
        this.registrationListener.onRegistrationFailure(failure);
    }

    private static class ResourceManagerRegistration
    extends RetryingRegistration<ResourceManagerId, ResourceManagerGateway, TaskExecutorRegistrationSuccess> {
        private final String taskExecutorAddress;
        private final ResourceID resourceID;
        private final int dataPort;
        private final HardwareDescription hardwareDescription;

        ResourceManagerRegistration(Logger log, RpcService rpcService, String targetAddress, ResourceManagerId resourceManagerId, String taskExecutorAddress, ResourceID resourceID, int dataPort, HardwareDescription hardwareDescription) {
            super(log, rpcService, "ResourceManager", ResourceManagerGateway.class, targetAddress, resourceManagerId);
            this.taskExecutorAddress = (String)Preconditions.checkNotNull((Object)taskExecutorAddress);
            this.resourceID = (ResourceID)Preconditions.checkNotNull((Object)resourceID);
            this.dataPort = dataPort;
            this.hardwareDescription = (HardwareDescription)Preconditions.checkNotNull((Object)hardwareDescription);
        }

        @Override
        protected CompletableFuture<RegistrationResponse> invokeRegistration(ResourceManagerGateway resourceManager, ResourceManagerId fencingToken, long timeoutMillis) throws Exception {
            Time timeout = Time.milliseconds((long)timeoutMillis);
            return resourceManager.registerTaskExecutor(this.taskExecutorAddress, this.resourceID, this.dataPort, this.hardwareDescription, timeout);
        }
    }
}

