/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobmaster.KvStateLocationOracle;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.query.KvStateMessage;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;

public class ActorGatewayKvStateLocationOracle
implements KvStateLocationOracle {
    private final ActorGateway jobManagerActorGateway;
    private final FiniteDuration timeout;

    public ActorGatewayKvStateLocationOracle(ActorGateway jobManagerActorGateway, Time timeout) {
        this.jobManagerActorGateway = (ActorGateway)Preconditions.checkNotNull((Object)jobManagerActorGateway);
        Preconditions.checkNotNull((Object)timeout);
        this.timeout = FiniteDuration.apply((long)timeout.toMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableFuture<KvStateLocation> requestKvStateLocation(JobID jobId, String registrationName) {
        KvStateMessage.LookupKvStateLocation lookupKvStateLocation = new KvStateMessage.LookupKvStateLocation(jobId, registrationName);
        return FutureUtils.toJava(this.jobManagerActorGateway.ask(lookupKvStateLocation, this.timeout).mapTo(ClassTag$.MODULE$.apply(KvStateLocation.class)));
    }
}

