/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public class CheckpointMetrics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long bytesBufferedInAlignment;
    private long alignmentDurationNanos;
    private long syncDurationMillis;
    private long asyncDurationMillis;

    public CheckpointMetrics() {
        this(-1L, -1L, -1L, -1L);
    }

    public CheckpointMetrics(long bytesBufferedInAlignment, long alignmentDurationNanos, long syncDurationMillis, long asyncDurationMillis) {
        Preconditions.checkArgument((syncDurationMillis >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((asyncDurationMillis >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((bytesBufferedInAlignment >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((alignmentDurationNanos >= -1L ? 1 : 0) != 0);
        this.bytesBufferedInAlignment = bytesBufferedInAlignment;
        this.alignmentDurationNanos = alignmentDurationNanos;
        this.syncDurationMillis = syncDurationMillis;
        this.asyncDurationMillis = asyncDurationMillis;
    }

    public long getBytesBufferedInAlignment() {
        return this.bytesBufferedInAlignment;
    }

    public CheckpointMetrics setBytesBufferedInAlignment(long bytesBufferedInAlignment) {
        this.bytesBufferedInAlignment = bytesBufferedInAlignment;
        return this;
    }

    public long getAlignmentDurationNanos() {
        return this.alignmentDurationNanos;
    }

    public CheckpointMetrics setAlignmentDurationNanos(long alignmentDurationNanos) {
        this.alignmentDurationNanos = alignmentDurationNanos;
        return this;
    }

    public long getSyncDurationMillis() {
        return this.syncDurationMillis;
    }

    public CheckpointMetrics setSyncDurationMillis(long syncDurationMillis) {
        this.syncDurationMillis = syncDurationMillis;
        return this;
    }

    public long getAsyncDurationMillis() {
        return this.asyncDurationMillis;
    }

    public CheckpointMetrics setAsyncDurationMillis(long asyncDurationMillis) {
        this.asyncDurationMillis = asyncDurationMillis;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointMetrics that = (CheckpointMetrics)o;
        return this.bytesBufferedInAlignment == that.bytesBufferedInAlignment && this.alignmentDurationNanos == that.alignmentDurationNanos && this.syncDurationMillis == that.syncDurationMillis && this.asyncDurationMillis == that.asyncDurationMillis;
    }

    public int hashCode() {
        int result = (int)(this.bytesBufferedInAlignment ^ this.bytesBufferedInAlignment >>> 32);
        result = 31 * result + (int)(this.alignmentDurationNanos ^ this.alignmentDurationNanos >>> 32);
        result = 31 * result + (int)(this.syncDurationMillis ^ this.syncDurationMillis >>> 32);
        result = 31 * result + (int)(this.asyncDurationMillis ^ this.asyncDurationMillis >>> 32);
        return result;
    }

    public String toString() {
        return "CheckpointMetrics{bytesBufferedInAlignment=" + this.bytesBufferedInAlignment + ", alignmentDurationNanos=" + this.alignmentDurationNanos + ", syncDurationMillis=" + this.syncDurationMillis + ", asyncDurationMillis=" + this.asyncDurationMillis + '}';
    }
}

