/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import org.apache.flink.runtime.deployment.InputChannelDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionLocation;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class PartialInputChannelDeploymentDescriptor {
    private final IntermediateDataSetID resultId;
    private final ResultPartitionID partitionID;
    private final TaskManagerLocation partitionTaskManagerLocation;
    private final int partitionConnectionIndex;

    public PartialInputChannelDeploymentDescriptor(IntermediateDataSetID resultId, ResultPartitionID partitionID, TaskManagerLocation partitionTaskManagerLocation, int partitionConnectionIndex) {
        this.resultId = (IntermediateDataSetID)((Object)Preconditions.checkNotNull((Object)((Object)resultId)));
        this.partitionID = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionID);
        this.partitionTaskManagerLocation = (TaskManagerLocation)Preconditions.checkNotNull((Object)partitionTaskManagerLocation);
        this.partitionConnectionIndex = partitionConnectionIndex;
    }

    public InputChannelDeploymentDescriptor createInputChannelDeploymentDescriptor(Execution consumerExecution) {
        Preconditions.checkNotNull((Object)consumerExecution, (String)"consumerExecution");
        TaskManagerLocation consumerLocation = consumerExecution.getAssignedResourceLocation();
        Preconditions.checkNotNull((Object)consumerLocation, (String)"Consumer connection info null");
        ResultPartitionLocation partitionLocation = consumerLocation.equals(this.partitionTaskManagerLocation) ? ResultPartitionLocation.createLocal() : ResultPartitionLocation.createRemote(new ConnectionID(this.partitionTaskManagerLocation, this.partitionConnectionIndex));
        return new InputChannelDeploymentDescriptor(this.partitionID, partitionLocation);
    }

    public IntermediateDataSetID getResultId() {
        return this.resultId;
    }

    public static PartialInputChannelDeploymentDescriptor fromEdge(IntermediateResultPartition partition, Execution producer) {
        ResultPartitionID partitionId = new ResultPartitionID(partition.getPartitionId(), producer.getAttemptId());
        IntermediateResult result = partition.getIntermediateResult();
        IntermediateDataSetID resultId = result.getId();
        TaskManagerLocation partitionConnectionInfo = producer.getAssignedResourceLocation();
        int partitionConnectionIndex = result.getConnectionIndex();
        return new PartialInputChannelDeploymentDescriptor(resultId, partitionId, partitionConnectionInfo, partitionConnectionIndex);
    }
}

