/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.util.Optional;
import java.util.Random;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.api.writer.RoundRobinChannelSelector;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.XORShiftRandom;

public class RecordWriter<T extends IOReadableWritable> {
    protected final ResultPartitionWriter targetPartition;
    private final ChannelSelector<T> channelSelector;
    private final int numChannels;
    private final int[] broadcastChannels;
    private final RecordSerializer<T> serializer;
    private final Optional<BufferBuilder>[] bufferBuilders;
    private final Random rng = new XORShiftRandom();
    private final boolean flushAlways;
    private Counter numBytesOut = new SimpleCounter();
    private Counter numBuffersOut = new SimpleCounter();

    public RecordWriter(ResultPartitionWriter writer) {
        this(writer, new RoundRobinChannelSelector());
    }

    public RecordWriter(ResultPartitionWriter writer, ChannelSelector<T> channelSelector) {
        this(writer, channelSelector, false);
    }

    public RecordWriter(ResultPartitionWriter writer, ChannelSelector<T> channelSelector, boolean flushAlways) {
        this.flushAlways = flushAlways;
        this.targetPartition = writer;
        this.channelSelector = channelSelector;
        this.numChannels = writer.getNumberOfSubpartitions();
        this.serializer = new SpanningRecordSerializer();
        this.bufferBuilders = new Optional[this.numChannels];
        this.broadcastChannels = new int[this.numChannels];
        for (int i = 0; i < this.numChannels; ++i) {
            this.broadcastChannels[i] = i;
            this.bufferBuilders[i] = Optional.empty();
        }
    }

    public void emit(T record) throws IOException, InterruptedException {
        this.emit(record, this.channelSelector.selectChannels(record, this.numChannels));
    }

    public void broadcastEmit(T record) throws IOException, InterruptedException {
        this.emit(record, this.broadcastChannels);
    }

    public void randomEmit(T record) throws IOException, InterruptedException {
        this.serializer.serializeRecord(record);
        if (this.copyFromSerializerToTargetChannel(this.rng.nextInt(this.numChannels))) {
            this.serializer.prune();
        }
    }

    private void emit(T record, int[] targetChannels) throws IOException, InterruptedException {
        this.serializer.serializeRecord(record);
        boolean pruneAfterCopying = false;
        for (int channel : targetChannels) {
            if (!this.copyFromSerializerToTargetChannel(channel)) continue;
            pruneAfterCopying = true;
        }
        if (pruneAfterCopying) {
            this.serializer.prune();
        }
    }

    private boolean copyFromSerializerToTargetChannel(int targetChannel) throws IOException, InterruptedException {
        this.serializer.reset();
        boolean pruneTriggered = false;
        BufferBuilder bufferBuilder = this.getBufferBuilder(targetChannel);
        RecordSerializer.SerializationResult result = this.serializer.copyToBufferBuilder(bufferBuilder);
        while (result.isFullBuffer()) {
            this.numBytesOut.inc((long)bufferBuilder.finish());
            this.numBuffersOut.inc();
            if (result.isFullRecord()) {
                pruneTriggered = true;
                this.bufferBuilders[targetChannel] = Optional.empty();
                break;
            }
            bufferBuilder = this.requestNewBufferBuilder(targetChannel);
            result = this.serializer.copyToBufferBuilder(bufferBuilder);
        }
        Preconditions.checkState((!this.serializer.hasSerializedData() ? 1 : 0) != 0, (Object)"All data should be written at once");
        if (this.flushAlways) {
            this.targetPartition.flush(targetChannel);
        }
        return pruneTriggered;
    }

    public void broadcastEvent(AbstractEvent event) throws IOException {
        try (BufferConsumer eventBufferConsumer = EventSerializer.toBufferConsumer(event);){
            for (int targetChannel = 0; targetChannel < this.numChannels; ++targetChannel) {
                this.tryFinishCurrentBufferBuilder(targetChannel);
                this.targetPartition.addBufferConsumer(eventBufferConsumer.copy(), targetChannel);
            }
            if (this.flushAlways) {
                this.flushAll();
            }
        }
    }

    public void flushAll() {
        this.targetPartition.flushAll();
    }

    public void clearBuffers() {
        for (int targetChannel = 0; targetChannel < this.numChannels; ++targetChannel) {
            this.closeBufferBuilder(targetChannel);
        }
    }

    public void setMetricGroup(TaskIOMetricGroup metrics) {
        this.numBytesOut = metrics.getNumBytesOutCounter();
        this.numBuffersOut = metrics.getNumBuffersOutCounter();
    }

    private void tryFinishCurrentBufferBuilder(int targetChannel) {
        if (!this.bufferBuilders[targetChannel].isPresent()) {
            return;
        }
        BufferBuilder bufferBuilder = this.bufferBuilders[targetChannel].get();
        this.bufferBuilders[targetChannel] = Optional.empty();
        this.numBytesOut.inc((long)bufferBuilder.finish());
        this.numBuffersOut.inc();
    }

    private BufferBuilder getBufferBuilder(int targetChannel) throws IOException, InterruptedException {
        if (this.bufferBuilders[targetChannel].isPresent()) {
            return this.bufferBuilders[targetChannel].get();
        }
        return this.requestNewBufferBuilder(targetChannel);
    }

    private BufferBuilder requestNewBufferBuilder(int targetChannel) throws IOException, InterruptedException {
        Preconditions.checkState((!this.bufferBuilders[targetChannel].isPresent() || this.bufferBuilders[targetChannel].get().isFinished() ? 1 : 0) != 0);
        BufferBuilder bufferBuilder = this.targetPartition.getBufferProvider().requestBufferBuilderBlocking();
        this.bufferBuilders[targetChannel] = Optional.of(bufferBuilder);
        this.targetPartition.addBufferConsumer(bufferBuilder.createBufferConsumer(), targetChannel);
        return bufferBuilder;
    }

    private void closeBufferBuilder(int targetChannel) {
        if (this.bufferBuilders[targetChannel].isPresent()) {
            this.bufferBuilders[targetChannel].get().finish();
            this.bufferBuilders[targetChannel] = Optional.empty();
        }
    }
}

