/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;

public class SSLHandlerFactory {
    private final SSLContext sslContext;
    private final String[] enabledProtocols;
    private final String[] enabledCipherSuites;
    private final boolean clientMode;
    private final boolean clientAuthentication;
    private final int handshakeTimeoutMs;
    private final int closeNotifyFlushTimeoutMs;

    public SSLHandlerFactory(SSLContext sslContext, String[] enabledProtocols, String[] enabledCipherSuites, boolean clientMode, boolean clientAuthentication, int handshakeTimeoutMs, int closeNotifyFlushTimeoutMs) {
        this.sslContext = Objects.requireNonNull(sslContext, "sslContext must not be null");
        this.enabledProtocols = Objects.requireNonNull(enabledProtocols, "enabledProtocols must not be null");
        this.enabledCipherSuites = Objects.requireNonNull(enabledCipherSuites, "cipherSuites must not be null");
        this.clientMode = clientMode;
        this.clientAuthentication = clientAuthentication;
        this.handshakeTimeoutMs = handshakeTimeoutMs;
        this.closeNotifyFlushTimeoutMs = closeNotifyFlushTimeoutMs;
    }

    public SslHandler createNettySSLHandler() {
        return this.createNettySSLHandler(this.createSSLEngine());
    }

    public SslHandler createNettySSLHandler(String hostname, int port) {
        return this.createNettySSLHandler(this.createSSLEngine(hostname, port));
    }

    private SslHandler createNettySSLHandler(SSLEngine sslEngine) {
        SslHandler sslHandler = new SslHandler(sslEngine);
        if (this.handshakeTimeoutMs >= 0) {
            sslHandler.setHandshakeTimeoutMillis((long)this.handshakeTimeoutMs);
        }
        if (this.closeNotifyFlushTimeoutMs >= 0) {
            sslHandler.setCloseNotifyFlushTimeoutMillis((long)this.closeNotifyFlushTimeoutMs);
        }
        return sslHandler;
    }

    private SSLEngine createSSLEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        this.configureSSLEngine(sslEngine);
        return sslEngine;
    }

    private SSLEngine createSSLEngine(String hostname, int port) {
        SSLEngine sslEngine = this.sslContext.createSSLEngine(hostname, port);
        this.configureSSLEngine(sslEngine);
        return sslEngine;
    }

    private void configureSSLEngine(SSLEngine sslEngine) {
        sslEngine.setEnabledProtocols(this.enabledProtocols);
        sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        sslEngine.setUseClientMode(this.clientMode);
        if (!this.clientMode) {
            sslEngine.setNeedClientAuth(this.clientAuthentication);
        }
    }
}

