/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexMessageParameters;
import org.apache.flink.runtime.rest.messages.JobVertexTaskManagersInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public class JobVertexTaskManagersHandler
extends AbstractExecutionGraphHandler<JobVertexTaskManagersInfo, JobVertexMessageParameters>
implements JsonArchivist {
    private MetricFetcher<?> metricFetcher;

    public JobVertexTaskManagersHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobVertexTaskManagersInfo, JobVertexMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor, MetricFetcher<?> metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
        this.metricFetcher = (MetricFetcher)Preconditions.checkNotNull(metricFetcher);
    }

    @Override
    protected JobVertexTaskManagersInfo handleRequest(HandlerRequest<EmptyRequestBody, JobVertexMessageParameters> request, AccessExecutionGraph executionGraph) throws RestHandlerException {
        JobID jobID = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID jobVertexID = (JobVertexID)((Object)request.getPathParameter(JobVertexIdPathParameter.class));
        AccessExecutionJobVertex jobVertex = executionGraph.getJobVertex(jobVertexID);
        if (jobVertex == null) {
            throw new NotFoundException(String.format("JobVertex %s not found", new Object[]{jobVertexID}));
        }
        return JobVertexTaskManagersHandler.createJobVertexTaskManagersInfo(jobVertex, jobID, this.metricFetcher);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        Collection<? extends AccessExecutionJobVertex> vertices = graph.getAllVertices().values();
        ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>(vertices.size());
        for (AccessExecutionJobVertex accessExecutionJobVertex : vertices) {
            JobVertexTaskManagersInfo json = JobVertexTaskManagersHandler.createJobVertexTaskManagersInfo(accessExecutionJobVertex, graph.getJobID(), null);
            String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString());
            archive.add(new ArchivedJson(path, json));
        }
        return archive;
    }

    private static JobVertexTaskManagersInfo createJobVertexTaskManagersInfo(AccessExecutionJobVertex jobVertex, JobID jobID, @Nullable MetricFetcher<?> metricFetcher) {
        HashMap<String, List> taskManagerVertices = new HashMap<String, List>();
        for (AccessExecutionVertex vertex : jobVertex.getTaskVertices()) {
            TaskManagerLocation location = vertex.getCurrentAssignedResourceLocation();
            String taskManager = location == null ? "(unassigned)" : location.getHostname() + ':' + location.dataPort();
            List vertices = taskManagerVertices.computeIfAbsent(taskManager, ignored -> new ArrayList(4));
            vertices.add(vertex);
        }
        long now = System.currentTimeMillis();
        ArrayList<JobVertexTaskManagersInfo.TaskManagersInfo> taskManagersInfoList = new ArrayList<JobVertexTaskManagersInfo.TaskManagersInfo>(4);
        for (Map.Entry entry : taskManagerVertices.entrySet()) {
            long duration;
            String host = (String)entry.getKey();
            List taskVertices = (List)entry.getValue();
            int[] tasksPerState = new int[ExecutionState.values().length];
            long startTime = Long.MAX_VALUE;
            long endTime = 0L;
            boolean allFinished = true;
            MutableIOMetrics counts = new MutableIOMetrics();
            for (AccessExecutionVertex vertex : taskVertices) {
                ExecutionState state = vertex.getExecutionState();
                int n = state.ordinal();
                tasksPerState[n] = tasksPerState[n] + 1;
                long started = vertex.getStateTimestamp(ExecutionState.DEPLOYING);
                if (started > 0L) {
                    startTime = Math.min(startTime, started);
                }
                allFinished &= state.isTerminal();
                endTime = Math.max(endTime, vertex.getStateTimestamp(state));
                counts.addIOMetrics(vertex.getCurrentExecutionAttempt(), metricFetcher, jobID.toString(), jobVertex.getJobVertexId().toString());
            }
            if (startTime < Long.MAX_VALUE) {
                if (allFinished) {
                    duration = endTime - startTime;
                } else {
                    endTime = -1L;
                    duration = now - startTime;
                }
            } else {
                startTime = -1L;
                endTime = -1L;
                duration = -1L;
            }
            ExecutionState jobVertexState = ExecutionJobVertex.getAggregateJobVertexState(tasksPerState, taskVertices.size());
            IOMetricsInfo jobVertexMetrics = new IOMetricsInfo(counts.getNumBytesInLocal() + counts.getNumBytesInRemote(), counts.isNumBytesInLocalComplete() && counts.isNumBytesInRemoteComplete(), counts.getNumBytesOut(), counts.isNumBytesOutComplete(), counts.getNumRecordsIn(), counts.isNumRecordsInComplete(), counts.getNumRecordsOut(), counts.isNumRecordsOutComplete());
            HashMap<ExecutionState, Integer> statusCounts = new HashMap<ExecutionState, Integer>(ExecutionState.values().length);
            for (ExecutionState state : ExecutionState.values()) {
                statusCounts.put(state, tasksPerState[state.ordinal()]);
            }
            taskManagersInfoList.add(new JobVertexTaskManagersInfo.TaskManagersInfo(host, jobVertexState, startTime, endTime, duration, jobVertexMetrics, statusCounts));
        }
        return new JobVertexTaskManagersInfo(jobVertex.getJobVertexId(), jobVertex.getName(), now, taskManagersInfoList);
    }
}

