/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.api.common.typeutils.CompositeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.ArrayListSerializer;
import org.apache.flink.util.Preconditions;

public class ArrayListSerializerSnapshot<T>
implements TypeSerializerSnapshot<ArrayList<T>> {
    private static final int CURRENT_VERSION = 1;
    private CompositeSerializerSnapshot nestedElementSerializerSnapshot;

    public ArrayListSerializerSnapshot() {
    }

    public ArrayListSerializerSnapshot(TypeSerializer<T> elementSerializer) {
        this.nestedElementSerializerSnapshot = new CompositeSerializerSnapshot(new TypeSerializer[]{elementSerializer});
    }

    public int getCurrentVersion() {
        return 1;
    }

    public TypeSerializer<ArrayList<T>> restoreSerializer() {
        return new ArrayListSerializer(this.nestedElementSerializerSnapshot.getRestoreSerializer(0));
    }

    public TypeSerializerSchemaCompatibility<ArrayList<T>> resolveSchemaCompatibility(TypeSerializer<ArrayList<T>> newSerializer) {
        Preconditions.checkState((this.nestedElementSerializerSnapshot != null ? 1 : 0) != 0);
        if (newSerializer instanceof ArrayListSerializer) {
            ArrayListSerializer serializer = (ArrayListSerializer)newSerializer;
            return this.nestedElementSerializerSnapshot.resolveCompatibilityWithNested(TypeSerializerSchemaCompatibility.compatibleAsIs(), new TypeSerializer[]{serializer.getElementSerializer()});
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }

    public void writeSnapshot(DataOutputView out) throws IOException {
        this.nestedElementSerializerSnapshot.writeCompositeSnapshot(out);
    }

    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.nestedElementSerializerSnapshot = CompositeSerializerSnapshot.readCompositeSnapshot((DataInputView)in, (ClassLoader)userCodeClassLoader);
    }
}

