/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.BackwardsCompatibleSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoReader;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshotReadersWriters;
import org.apache.flink.util.Preconditions;

public class KeyedBackendSerializationProxy<K>
extends VersionedIOReadableWritable {
    public static final int VERSION = 6;
    private static final Map<Integer, Integer> META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER = new HashMap<Integer, Integer>();
    private boolean usingKeyGroupCompression;
    private TypeSerializer<K> keySerializer;
    private TypeSerializerSnapshot<K> keySerializerConfigSnapshot;
    private List<StateMetaInfoSnapshot> stateMetaInfoSnapshots;
    private ClassLoader userCodeClassLoader;

    public KeyedBackendSerializationProxy(ClassLoader userCodeClassLoader) {
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
    }

    public KeyedBackendSerializationProxy(TypeSerializer<K> keySerializer, List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, boolean compression) {
        this.usingKeyGroupCompression = compression;
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer);
        this.keySerializerConfigSnapshot = (TypeSerializerSnapshot)Preconditions.checkNotNull((Object)keySerializer.snapshotConfiguration());
        Preconditions.checkNotNull(stateMetaInfoSnapshots);
        Preconditions.checkArgument((stateMetaInfoSnapshots.size() <= Short.MAX_VALUE ? 1 : 0) != 0);
        this.stateMetaInfoSnapshots = stateMetaInfoSnapshots;
    }

    public List<StateMetaInfoSnapshot> getStateMetaInfoSnapshots() {
        return this.stateMetaInfoSnapshots;
    }

    public TypeSerializerSnapshot<K> getKeySerializerConfigSnapshot() {
        return this.keySerializerConfigSnapshot;
    }

    public boolean isUsingKeyGroupCompression() {
        return this.usingKeyGroupCompression;
    }

    public int getVersion() {
        return 6;
    }

    public int[] getCompatibleVersions() {
        return new int[]{6, 5, 4, 3, 2, 1};
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeBoolean(this.usingKeyGroupCompression);
        TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)out, this.keySerializerConfigSnapshot, this.keySerializer);
        out.writeShort(this.stateMetaInfoSnapshots.size());
        for (StateMetaInfoSnapshot metaInfoSnapshot : this.stateMetaInfoSnapshots) {
            StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(metaInfoSnapshot, out);
        }
    }

    public void read(DataInputView in) throws IOException {
        super.read(in);
        int readVersion = this.getReadVersion();
        this.usingKeyGroupCompression = readVersion >= 4 ? in.readBoolean() : false;
        if (readVersion >= 6) {
            this.keySerializerConfigSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)in, (ClassLoader)this.userCodeClassLoader, null);
        } else if (readVersion >= 3) {
            Tuple2 keySerializerAndConfig = (Tuple2)TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience((DataInputView)in, (ClassLoader)this.userCodeClassLoader).get(0);
            this.keySerializerConfigSnapshot = (TypeSerializerSnapshot)keySerializerAndConfig.f1;
        } else {
            this.keySerializerConfigSnapshot = new BackwardsCompatibleSerializerSnapshot(TypeSerializerSerializationUtil.tryReadSerializer((DataInputView)in, (ClassLoader)this.userCodeClassLoader, (boolean)true));
        }
        this.keySerializer = null;
        Integer metaInfoSnapshotVersion = META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.get(readVersion);
        if (metaInfoSnapshotVersion == null) {
            throw new IOException("Cannot determine corresponding meta info snapshot version for keyed backend serialization readVersion=" + readVersion);
        }
        StateMetaInfoReader stateMetaInfoReader = StateMetaInfoSnapshotReadersWriters.getReader(metaInfoSnapshotVersion, StateMetaInfoSnapshotReadersWriters.StateTypeHint.KEYED_STATE);
        int numKvStates = in.readShort();
        this.stateMetaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>(numKvStates);
        for (int i = 0; i < numKvStates; ++i) {
            StateMetaInfoSnapshot snapshot = stateMetaInfoReader.readStateMetaInfoSnapshot(in, this.userCodeClassLoader);
            this.stateMetaInfoSnapshots.add(snapshot);
        }
    }

    static {
        META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.put(1, 1);
        META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.put(2, 2);
        META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.put(3, 3);
        META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.put(4, 4);
        META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.put(5, 5);
        META_INFO_SNAPSHOT_FORMAT_VERSION_MAPPER.put(6, 6);
    }
}

