/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.akka;

import akka.actor.ActorRef;
import akka.actor.Kill;
import akka.actor.PoisonPill;
import akka.pattern.Patterns;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;

public class ActorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ActorUtils.class);

    public static CompletableFuture<Void> nonBlockingShutDown(long gracePeriod, TimeUnit timeUnit, ActorRef ... actors) {
        ArrayList<CompletionStage> terminationFutures = new ArrayList<CompletionStage>(actors.length);
        FiniteDuration timeout = new FiniteDuration(gracePeriod, timeUnit);
        for (ActorRef actor : actors) {
            try {
                Future booleanFuture = Patterns.gracefulStop((ActorRef)actor, (FiniteDuration)timeout);
                CompletionStage terminationFuture = ((CompletableFuture)FutureUtils.toJava(booleanFuture).thenApply(ignored -> null)).exceptionally(throwable -> {
                    if (throwable instanceof TimeoutException) {
                        actor.tell((Object)Kill.getInstance(), ActorRef.noSender());
                        return null;
                    }
                    throw new CompletionException((Throwable)throwable);
                });
                terminationFutures.add(terminationFuture);
            }
            catch (IllegalStateException ignored2) {
                LOG.debug("The actor {} has already been stopped because the underlying ActorSystem has already been shut down.", (Object)actor.path());
            }
        }
        return FutureUtils.completeAll(terminationFutures);
    }

    public static void stopActor(AkkaActorGateway akkaActorGateway) {
        ActorUtils.stopActor(akkaActorGateway.actor());
    }

    public static void stopActor(ActorRef actorRef) {
        actorRef.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
    }

    private ActorUtils() {
    }
}

