/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Status;
import akka.actor.UntypedActor;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricQueryService
extends UntypedActor {
    private static final Logger LOG = LoggerFactory.getLogger(MetricQueryService.class);
    public static final String METRIC_QUERY_SERVICE_NAME = "MetricQueryService";
    private static final String SIZE_EXCEEDED_LOG_TEMPLATE = "{} will not be reported as the metric dump would exceed the maximum size of {} bytes.";
    private static final CharacterFilter FILTER = new CharacterFilter(){

        public String filterCharacters(String input) {
            return MetricQueryService.replaceInvalidChars(input);
        }
    };
    private final MetricDumpSerialization.MetricDumpSerializer serializer = new MetricDumpSerialization.MetricDumpSerializer();
    private final Map<Gauge<?>, Tuple2<QueryScopeInfo, String>> gauges = new HashMap();
    private final Map<Counter, Tuple2<QueryScopeInfo, String>> counters = new HashMap<Counter, Tuple2<QueryScopeInfo, String>>();
    private final Map<Histogram, Tuple2<QueryScopeInfo, String>> histograms = new HashMap<Histogram, Tuple2<QueryScopeInfo, String>>();
    private final Map<Meter, Tuple2<QueryScopeInfo, String>> meters = new HashMap<Meter, Tuple2<QueryScopeInfo, String>>();
    private final long messageSizeLimit;

    public MetricQueryService(long messageSizeLimit) {
        this.messageSizeLimit = messageSizeLimit;
    }

    public void postStop() {
        this.serializer.close();
    }

    public void onReceive(Object message) {
        try {
            if (message instanceof AddMetric) {
                AddMetric added = (AddMetric)message;
                String metricName = added.metricName;
                Metric metric = added.metric;
                AbstractMetricGroup group = added.group;
                QueryScopeInfo info = group.getQueryServiceMetricInfo(FILTER);
                if (metric instanceof Counter) {
                    this.counters.put((Counter)metric, (Tuple2<QueryScopeInfo, String>)new Tuple2((Object)info, (Object)FILTER.filterCharacters(metricName)));
                } else if (metric instanceof Gauge) {
                    this.gauges.put((Gauge)metric, (Tuple2<QueryScopeInfo, String>)new Tuple2((Object)info, (Object)FILTER.filterCharacters(metricName)));
                } else if (metric instanceof Histogram) {
                    this.histograms.put((Histogram)metric, (Tuple2<QueryScopeInfo, String>)new Tuple2((Object)info, (Object)FILTER.filterCharacters(metricName)));
                } else if (metric instanceof Meter) {
                    this.meters.put((Meter)metric, (Tuple2<QueryScopeInfo, String>)new Tuple2((Object)info, (Object)FILTER.filterCharacters(metricName)));
                }
            } else if (message instanceof RemoveMetric) {
                Metric metric = ((RemoveMetric)message).metric;
                if (metric instanceof Counter) {
                    this.counters.remove(metric);
                } else if (metric instanceof Gauge) {
                    this.gauges.remove(metric);
                } else if (metric instanceof Histogram) {
                    this.histograms.remove(metric);
                } else if (metric instanceof Meter) {
                    this.meters.remove(metric);
                }
            } else if (message instanceof CreateDump) {
                MetricDumpSerialization.MetricSerializationResult dump = this.serializer.serialize(this.counters, this.gauges, this.histograms, this.meters);
                dump = this.enforceSizeLimit(dump);
                this.getSender().tell((Object)dump, this.getSelf());
            } else {
                LOG.warn("MetricQueryServiceActor received an invalid message. " + message.toString());
                this.getSender().tell((Object)new Status.Failure((Throwable)new IOException("MetricQueryServiceActor received an invalid message. " + message.toString())), this.getSelf());
            }
        }
        catch (Exception e) {
            LOG.warn("An exception occurred while processing a message.", (Throwable)e);
        }
    }

    private MetricDumpSerialization.MetricSerializationResult enforceSizeLimit(MetricDumpSerialization.MetricSerializationResult serializationResult) {
        int currentLength = 0;
        boolean hasExceededBefore = false;
        byte[] serializedCounters = serializationResult.serializedCounters;
        int numCounters = serializationResult.numCounters;
        if (this.exceedsMessageSizeLimit(currentLength + serializationResult.serializedCounters.length)) {
            this.logDumpSizeWouldExceedLimit("Counters", hasExceededBefore);
            hasExceededBefore = true;
            serializedCounters = new byte[]{};
            numCounters = 0;
        } else {
            currentLength += serializedCounters.length;
        }
        byte[] serializedMeters = serializationResult.serializedMeters;
        int numMeters = serializationResult.numMeters;
        if (this.exceedsMessageSizeLimit(currentLength + serializationResult.serializedMeters.length)) {
            this.logDumpSizeWouldExceedLimit("Meters", hasExceededBefore);
            hasExceededBefore = true;
            serializedMeters = new byte[]{};
            numMeters = 0;
        } else {
            currentLength += serializedMeters.length;
        }
        byte[] serializedGauges = serializationResult.serializedGauges;
        int numGauges = serializationResult.numGauges;
        if (this.exceedsMessageSizeLimit(currentLength + serializationResult.serializedGauges.length)) {
            this.logDumpSizeWouldExceedLimit("Gauges", hasExceededBefore);
            hasExceededBefore = true;
            serializedGauges = new byte[]{};
            numGauges = 0;
        } else {
            currentLength += serializedGauges.length;
        }
        byte[] serializedHistograms = serializationResult.serializedHistograms;
        int numHistograms = serializationResult.numHistograms;
        if (this.exceedsMessageSizeLimit(currentLength + serializationResult.serializedHistograms.length)) {
            this.logDumpSizeWouldExceedLimit("Histograms", hasExceededBefore);
            hasExceededBefore = true;
            serializedHistograms = new byte[]{};
            numHistograms = 0;
        }
        return new MetricDumpSerialization.MetricSerializationResult(serializedCounters, serializedGauges, serializedMeters, serializedHistograms, numCounters, numGauges, numMeters, numHistograms);
    }

    private boolean exceedsMessageSizeLimit(int currentSize) {
        return (long)currentSize > this.messageSizeLimit;
    }

    private void logDumpSizeWouldExceedLimit(String metricType, boolean hasExceededBefore) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(SIZE_EXCEEDED_LOG_TEMPLATE, (Object)metricType, (Object)this.messageSizeLimit);
        } else if (!hasExceededBefore) {
            LOG.info(SIZE_EXCEEDED_LOG_TEMPLATE, (Object)"Some metrics", (Object)this.messageSizeLimit);
        }
    }

    static String replaceInvalidChars(String str) {
        char[] chars = null;
        int strLen = str.length();
        int pos = 0;
        block3: for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case ' ': 
                case ',': 
                case '.': 
                case ':': {
                    if (chars == null) {
                        chars = str.toCharArray();
                    }
                    chars[pos++] = 95;
                    continue block3;
                }
                default: {
                    if (chars != null) {
                        chars[pos] = c;
                    }
                    ++pos;
                }
            }
        }
        return chars == null ? str : new String(chars, 0, pos);
    }

    public static ActorRef startMetricQueryService(ActorSystem actorSystem, ResourceID resourceID, long maximumFramesize) {
        String actorName = resourceID == null ? METRIC_QUERY_SERVICE_NAME : "MetricQueryService_" + resourceID.getResourceIdString();
        return actorSystem.actorOf(Props.create(MetricQueryService.class, (Object[])new Object[]{maximumFramesize}), actorName);
    }

    public static void notifyOfAddedMetric(ActorRef service, Metric metric, String metricName, AbstractMetricGroup group) {
        service.tell((Object)new AddMetric(metricName, metric, group), null);
    }

    public static void notifyOfRemovedMetric(ActorRef service, Metric metric) {
        service.tell((Object)new RemoveMetric(metric), null);
    }

    public static Object getCreateDump() {
        return CreateDump.INSTANCE;
    }

    private static class CreateDump
    implements Serializable {
        private static final CreateDump INSTANCE = new CreateDump();

        private CreateDump() {
        }
    }

    private static class RemoveMetric {
        private final Metric metric;

        private RemoveMetric(Metric metric) {
            this.metric = metric;
        }
    }

    private static class AddMetric {
        private final String metricName;
        private final Metric metric;
        private final AbstractMetricGroup group;

        private AddMetric(String metricName, Metric metric, AbstractMetricGroup group) {
            this.metricName = metricName;
            this.metric = metric;
            this.group = group;
        }
    }
}

