/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.savepoints;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.async.AbstractAsynchronousOperationHandlers;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.TriggerId;
import org.apache.flink.runtime.rest.messages.TriggerIdPathParameter;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointInfo;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointStatusHeaders;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointStatusMessageParameters;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointTriggerHeaders;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointTriggerMessageParameters;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointTriggerRequestBody;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.SerializedThrowable;

public class SavepointHandlers
extends AbstractAsynchronousOperationHandlers<AsynchronousJobOperationKey, String> {
    @Nullable
    private final String defaultSavepointDir;

    public SavepointHandlers(@Nullable String defaultSavepointDir) {
        this.defaultSavepointDir = defaultSavepointDir;
    }

    public class SavepointStatusHandler
    extends AbstractAsynchronousOperationHandlers.StatusHandler<RestfulGateway, SavepointInfo, SavepointStatusMessageParameters> {
        public SavepointStatusHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
            super(leaderRetriever, timeout, responseHeaders, SavepointStatusHeaders.getInstance());
        }

        @Override
        protected AsynchronousJobOperationKey getOperationKey(HandlerRequest<EmptyRequestBody, SavepointStatusMessageParameters> request) {
            TriggerId triggerId = (TriggerId)((Object)request.getPathParameter(TriggerIdPathParameter.class));
            JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
            return AsynchronousJobOperationKey.of(triggerId, jobId);
        }

        @Override
        protected SavepointInfo exceptionalOperationResultResponse(Throwable throwable) {
            return new SavepointInfo(null, new SerializedThrowable(throwable));
        }

        @Override
        protected SavepointInfo operationResultResponse(String operationResult) {
            return new SavepointInfo(operationResult, null);
        }
    }

    public class SavepointTriggerHandler
    extends AbstractAsynchronousOperationHandlers.TriggerHandler<RestfulGateway, SavepointTriggerRequestBody, SavepointTriggerMessageParameters> {
        public SavepointTriggerHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
            super(leaderRetriever, timeout, responseHeaders, SavepointTriggerHeaders.getInstance());
        }

        @Override
        protected CompletableFuture<String> triggerOperation(HandlerRequest<SavepointTriggerRequestBody, SavepointTriggerMessageParameters> request, RestfulGateway gateway) throws RestHandlerException {
            JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
            String requestedTargetDirectory = request.getRequestBody().getTargetDirectory();
            if (requestedTargetDirectory == null && SavepointHandlers.this.defaultSavepointDir == null) {
                throw new RestHandlerException(String.format("Config key [%s] is not set. Property [%s] must be provided.", CheckpointingOptions.SAVEPOINT_DIRECTORY.key(), "target-directory"), HttpResponseStatus.BAD_REQUEST);
            }
            boolean cancelJob = request.getRequestBody().isCancelJob();
            String targetDirectory = requestedTargetDirectory != null ? requestedTargetDirectory : SavepointHandlers.this.defaultSavepointDir;
            return gateway.triggerSavepoint(jobId, targetDirectory, cancelJob, RpcUtils.INF_TIMEOUT);
        }

        @Override
        protected AsynchronousJobOperationKey createOperationKey(HandlerRequest<SavepointTriggerRequestBody, SavepointTriggerMessageParameters> request) {
            JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
            return AsynchronousJobOperationKey.of(new TriggerId(), jobId);
        }
    }
}

