/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.modules;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.security.auth.Subject;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopModule
implements SecurityModule {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopModule.class);
    private final SecurityConfiguration securityConfig;
    private final Configuration hadoopConfiguration;

    public HadoopModule(SecurityConfiguration securityConfiguration, Configuration hadoopConfiguration) {
        this.securityConfig = (SecurityConfiguration)Preconditions.checkNotNull((Object)securityConfiguration);
        this.hadoopConfiguration = (Configuration)Preconditions.checkNotNull((Object)hadoopConfiguration);
    }

    @VisibleForTesting
    public SecurityConfiguration getSecurityConfig() {
        return this.securityConfig;
    }

    @Override
    public void install() throws SecurityModule.SecurityInstallException {
        UserGroupInformation.setConfiguration((Configuration)this.hadoopConfiguration);
        try {
            UserGroupInformation loginUser;
            if (UserGroupInformation.isSecurityEnabled() && !StringUtils.isBlank((CharSequence)this.securityConfig.getKeytab()) && !StringUtils.isBlank((CharSequence)this.securityConfig.getPrincipal())) {
                String keytabPath = new File(this.securityConfig.getKeytab()).getAbsolutePath();
                UserGroupInformation.loginUserFromKeytab((String)this.securityConfig.getPrincipal(), (String)keytabPath);
                loginUser = UserGroupInformation.getLoginUser();
                String fileLocation = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
                if (fileLocation != null) {
                    try {
                        Method readTokenStorageFileMethod = Credentials.class.getMethod("readTokenStorageFile", File.class, Configuration.class);
                        Credentials cred = (Credentials)readTokenStorageFileMethod.invoke(null, new File(fileLocation), this.hadoopConfiguration);
                        Method getAllTokensMethod = Credentials.class.getMethod("getAllTokens", new Class[0]);
                        Credentials credentials = new Credentials();
                        Text hdfsDelegationTokenKind = new Text("HDFS_DELEGATION_TOKEN");
                        Collection usrTok = (Collection)getAllTokensMethod.invoke((Object)cred, new Object[0]);
                        for (Token token : usrTok) {
                            if (token.getKind().equals((Object)hdfsDelegationTokenKind)) continue;
                            Text id = new Text(token.getIdentifier());
                            credentials.addToken(id, token);
                        }
                        Method addCredentialsMethod = UserGroupInformation.class.getMethod("addCredentials", Credentials.class);
                        addCredentialsMethod.invoke((Object)loginUser, credentials);
                    }
                    catch (NoSuchMethodException e) {
                        LOG.warn("Could not find method implementations in the shaded jar. Exception: {}", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
            } else {
                try {
                    Method loginUserFromSubjectMethod = UserGroupInformation.class.getMethod("loginUserFromSubject", Subject.class);
                    loginUserFromSubjectMethod.invoke(null, new Object[]{null});
                }
                catch (NoSuchMethodException e) {
                    LOG.warn("Could not find method implementations in the shaded jar. Exception: {}", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                loginUser = UserGroupInformation.getLoginUser();
            }
            if (UserGroupInformation.isSecurityEnabled() && this.securityConfig.useTicketCache() && !loginUser.hasKerberosCredentials() && !HadoopUtils.hasHDFSDelegationToken()) {
                LOG.warn("Hadoop security is enabled but current login user does not have Kerberos credentials");
            }
            LOG.info("Hadoop user set to {}", (Object)loginUser);
        }
        catch (Throwable ex) {
            throw new SecurityModule.SecurityInstallException("Unable to set the Hadoop login user", ex);
        }
    }

    @Override
    public void uninstall() throws SecurityModule.SecurityInstallException {
        throw new UnsupportedOperationException();
    }
}

