/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.compress;

import akka.remote.artery.compress.CompressionTable$;
import akka.remote.artery.compress.DecompressionTable;
import akka.remote.artery.compress.DecompressionTable$;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005]h!B\u0001\u0003\u0005\u001aQ!\u0001E\"p[B\u0014Xm]:j_:$\u0016M\u00197f\u0015\t\u0019A!\u0001\u0005d_6\u0004(/Z:t\u0015\t)a!\u0001\u0004beR,'/\u001f\u0006\u0003\u000f!\taA]3n_R,'\"A\u0005\u0002\t\u0005\\7.Y\u000b\u0003\u0017e\u001aB\u0001\u0001\u0007\u0013+A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"!D\n\n\u0005Qq!a\u0002)s_\u0012,8\r\u001e\t\u0003\u001bYI!a\u0006\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011e\u0001!Q3A\u0005\u0002m\t\u0011b\u001c:jO&tW+\u001b3\u0004\u0001U\tA\u0004\u0005\u0002\u000e;%\u0011aD\u0004\u0002\u0005\u0019>tw\r\u0003\u0005!\u0001\tE\t\u0015!\u0003\u001d\u0003)y'/[4j]VKG\r\t\u0005\tE\u0001\u0011)\u001a!C\u0001G\u00059a/\u001a:tS>tW#\u0001\u0013\u0011\u00055)\u0013B\u0001\u0014\u000f\u0005\u0011\u0011\u0015\u0010^3\t\u0011!\u0002!\u0011#Q\u0001\n\u0011\n\u0001B^3sg&|g\u000e\t\u0005\tU\u0001\u0011)\u001a!C\u0001W\u0005QA-[2uS>t\u0017M]=\u0016\u00031\u0002B!\f\u001b8\u0005:\u0011aF\r\t\u0003_9i\u0011\u0001\r\u0006\u0003ci\ta\u0001\u0010:p_Rt\u0014BA\u001a\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0004\u001b\u0006\u0004(BA\u001a\u000f!\tA\u0014\b\u0004\u0001\u0005\u000bi\u0002!\u0019A\u001e\u0003\u0003Q\u000b\"\u0001P \u0011\u00055i\u0014B\u0001 \u000f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u0004!\n\u0005\u0005s!aA!osB\u0011QbQ\u0005\u0003\t:\u00111!\u00138u\u0011!1\u0005A!E!\u0002\u0013a\u0013a\u00033jGRLwN\\1ss\u0002BQ\u0001\u0013\u0001\u0005\u0002%\u000ba\u0001P5oSRtD\u0003\u0002&M\u001b:\u00032a\u0013\u00018\u001b\u0005\u0011\u0001\"B\rH\u0001\u0004a\u0002\"\u0002\u0012H\u0001\u0004!\u0003\"\u0002\u0016H\u0001\u0004a\u0003\"B\u0002\u0001\t\u0003\u0001FC\u0001\"R\u0011\u0015\u0011v\n1\u00018\u0003\u00151\u0018\r\\;f\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u0019IgN^3siV\ta\u000bE\u0002L/^J!\u0001\u0017\u0002\u0003%\u0011+7m\\7qe\u0016\u001c8/[8o)\u0006\u0014G.\u001a\u0005\b5\u0002\t\t\u0011\"\u0001\\\u0003\u0011\u0019w\u000e]=\u0016\u0005q{F\u0003B/aC\n\u00042a\u0013\u0001_!\tAt\fB\u0003;3\n\u00071\bC\u0004\u001a3B\u0005\t\u0019\u0001\u000f\t\u000f\tJ\u0006\u0013!a\u0001I!9!&\u0017I\u0001\u0002\u0004\u0019\u0007\u0003B\u00175=\nCq!\u001a\u0001\u0012\u0002\u0013\u0005a-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u001d\u0014X#\u00015+\u0005qI7&\u00016\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017!C;oG\",7m[3e\u0015\tyg\"\u0001\u0006b]:|G/\u0019;j_:L!!\u001d7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003;I\n\u00071\bC\u0004u\u0001E\u0005I\u0011A;\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011a\u000f_\u000b\u0002o*\u0012A%\u001b\u0003\u0006uM\u0014\ra\u000f\u0005\bu\u0002\t\n\u0011\"\u0001|\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"\u0001 @\u0016\u0003uT#\u0001L5\u0005\u000biJ(\u0019A\u001e\t\u0013\u0005\u0005\u0001!!A\u0005B\u0005\r\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0006A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011\u0001\u00027b]\u001eT!!a\u0004\u0002\t)\fg/Y\u0005\u0005\u0003'\tIA\u0001\u0004TiJLgn\u001a\u0005\n\u0003/\u0001\u0011\u0011!C\u0001\u00033\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012A\u0011\u0005\n\u0003;\u0001\u0011\u0011!C\u0001\u0003?\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002@\u0003CA\u0011\"a\t\u0002\u001c\u0005\u0005\t\u0019\u0001\"\u0002\u0007a$\u0013\u0007C\u0005\u0002(\u0001\t\t\u0011\"\u0011\u0002*\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002,A)\u0011QFA\u001a\u007f5\u0011\u0011q\u0006\u0006\u0004\u0003cq\u0011AC2pY2,7\r^5p]&!\u0011QGA\u0018\u0005!IE/\u001a:bi>\u0014\b\"CA\u001d\u0001\u0005\u0005I\u0011AA\u001e\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001f\u0003\u0007\u00022!DA \u0013\r\t\tE\u0004\u0002\b\u0005>|G.Z1o\u0011%\t\u0019#a\u000e\u0002\u0002\u0003\u0007q\bC\u0005\u0002H\u0001\t\t\u0011\"\u0011\u0002J\u0005A\u0001.Y:i\u0007>$W\rF\u0001C\u0011%\ti\u0005AA\u0001\n\u0003\ny%\u0001\u0005u_N#(/\u001b8h)\t\t)\u0001C\u0005\u0002T\u0001\t\t\u0011\"\u0011\u0002V\u00051Q-];bYN$B!!\u0010\u0002X!I\u00111EA)\u0003\u0003\u0005\raP\u0004\t\u00037\u0012\u0001\u0012\u0001\u0004\u0002^\u0005\u00012i\\7qe\u0016\u001c8/[8o)\u0006\u0014G.\u001a\t\u0004\u0017\u0006}caB\u0001\u0003\u0011\u00031\u0011\u0011M\n\u0005\u0003?bQ\u0003C\u0004I\u0003?\"\t!!\u001a\u0015\u0005\u0005u\u0003BCA5\u0003?\u0012\r\u0011\"\u0002\u0002l\u0005yaj\u001c;D_6\u0004(/Z:tK\u0012LE-\u0006\u0002\u0002n=\u0011\u0011qN\u000f\u0002\u007f$I\u00111OA0A\u00035\u0011QN\u0001\u0011\u001d>$8i\\7qe\u0016\u001c8/\u001a3JI\u0002B!\"a\u001e\u0002`\t\u0007IQAA=\u0003E\u0019u.\u001c9be\u0016\u0014\u0015P\r8e-\u0006dW/Z\u000b\u0003\u0003w\u0002b!! \u0002\u0004\u0006\u001dUBAA@\u0015\u0011\t\t)!\u0004\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000b\u000byH\u0001\u0006D_6\u0004\u0018M]1u_J\u0004b!DAE\u0003\u001b\u0013\u0015bAAF\u001d\t1A+\u001e9mKJ\u0002B!a\u0002\u0002\u0010&!\u0011\u0011SA\u0005\u0005\u0019y%M[3di\"I\u0011QSA0A\u00035\u00111P\u0001\u0013\u0007>l\u0007/\u0019:f\u0005f\u0014d\u000e\u001a,bYV,\u0007\u0005\u0003\u0005\u0002\u001a\u0006}C\u0011AAN\u0003E\u0019w.\u001c9be\u0016\u0014\u0015P\r8e-\u0006dW/Z\u000b\u0005\u0003;\u000b)+\u0006\u0002\u0002 B1\u0011QPAB\u0003C\u0003b!DAE\u0003G\u0013\u0005c\u0001\u001d\u0002&\u00121!(a&C\u0002mB\u0011\"!+\u0002`\u0001\u0006I!a+\u0002\r}+W\u000e\u001d;z!\rY\u0005a\u0010\u0005\t\u0003_\u000by\u0006\"\u0001\u00022\u0006)Q-\u001c9usV!\u00111WA]+\t\t)\f\u0005\u0003L\u0001\u0005]\u0006c\u0001\u001d\u0002:\u00121!(!,C\u0002mB!\"!0\u0002`\u0005\u0005I\u0011QA`\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\t\t-a2\u0015\u0011\u0005\r\u0017\u0011ZAf\u0003\u001b\u0004Ba\u0013\u0001\u0002FB\u0019\u0001(a2\u0005\ri\nYL1\u0001<\u0011\u0019I\u00121\u0018a\u00019!1!%a/A\u0002\u0011BqAKA^\u0001\u0004\ty\rE\u0003.i\u0005\u0015'\t\u0003\u0006\u0002T\u0006}\u0013\u0011!CA\u0003+\fq!\u001e8baBd\u00170\u0006\u0003\u0002X\u0006%H\u0003BAm\u0003W\u0004R!DAn\u0003?L1!!8\u000f\u0005\u0019y\u0005\u000f^5p]B9Q\"!9\u001dI\u0005\u0015\u0018bAAr\u001d\t1A+\u001e9mKN\u0002R!\f\u001b\u0002h\n\u00032\u0001OAu\t\u0019Q\u0014\u0011\u001bb\u0001w!Q\u0011Q^Ai\u0003\u0003\u0005\r!a<\u0002\u0007a$\u0003\u0007\u0005\u0003L\u0001\u0005\u001d\bBCAz\u0003?\n\t\u0011\"\u0003\u0002v\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\t")
public final class CompressionTable<T>
implements Product,
scala.Serializable {
    private final long originUid;
    private final byte version;
    private final Map<T, Object> dictionary;

    public static <T> Option<Tuple3<Object, Object, Map<T, Object>>> unapply(CompressionTable<T> compressionTable) {
        return CompressionTable$.MODULE$.unapply(compressionTable);
    }

    public static <T> CompressionTable<T> apply(long l, byte by, Map<T, Object> map) {
        return CompressionTable$.MODULE$.apply(l, by, map);
    }

    public static <T> CompressionTable<T> empty() {
        return CompressionTable$.MODULE$.empty();
    }

    public static <T> Comparator<Tuple2<T, Object>> compareBy2ndValue() {
        return CompressionTable$.MODULE$.compareBy2ndValue();
    }

    public static Comparator<Tuple2<Object, Object>> CompareBy2ndValue() {
        return CompressionTable$.MODULE$.CompareBy2ndValue();
    }

    public static int NotCompressedId() {
        return CompressionTable$.MODULE$.NotCompressedId();
    }

    public long originUid() {
        return this.originUid;
    }

    public byte version() {
        return this.version;
    }

    public Map<T, Object> dictionary() {
        return this.dictionary;
    }

    public int compress(T value) {
        int n;
        Option option = this.dictionary().get(value);
        if (option instanceof Some) {
            int id;
            Some some = (Some)option;
            n = id = BoxesRunTime.unboxToInt((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            n = -1;
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    public DecompressionTable<T> invert() {
        DecompressionTable decompressionTable;
        if (this.dictionary().isEmpty()) {
            DecompressionTable qual$1 = DecompressionTable$.MODULE$.empty();
            long x$1 = this.originUid();
            byte x$2 = this.version();
            Object x$3 = qual$1.copy$default$3();
            decompressionTable = qual$1.copy(x$1, x$2, x$3);
        } else {
            int i;
            Integer expectedGaplessSum = this.dictionary().size() * (this.dictionary().size() + 1) / 2;
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)this.dictionary().values().min((Ordering)Ordering.Int$.MODULE$)) == 0, (Function0 & Serializable & scala.Serializable)() -> "Compression table should start allocating from 0, yet lowest allocated id was " + this.dictionary().values().min((Ordering)Ordering.Int$.MODULE$));
            Predef$.MODULE$.require(BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.dictionary().values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + this.dictionary().size())), (Object)expectedGaplessSum), (Function0 & Serializable & scala.Serializable)() -> "Given compression map does not seem to be gap-less and starting from zero, which makes compressing it into an Array difficult, bailing out! Map was: " + this.dictionary());
            Tuple2[] tups = (Tuple2[])Array$.MODULE$.ofDim(this.dictionary().size(), ClassTag$.MODULE$.apply(Tuple2.class));
            Object ts = Array$.MODULE$.ofDim(this.dictionary().size(), ClassTag$.MODULE$.Object());
            Iterator mit = this.dictionary().iterator();
            for (i = 0; i < tups.length; ++i) {
                tups[i] = (Tuple2)mit.next();
            }
            Arrays.sort((Object[])tups, CompressionTable$.MODULE$.compareBy2ndValue());
            for (i = 0; i < tups.length; ++i) {
                ScalaRunTime$.MODULE$.array_update(ts, i, tups[i]._1());
            }
            decompressionTable = new DecompressionTable(this.originUid(), this.version(), ts);
        }
        return decompressionTable;
    }

    public <T> CompressionTable<T> copy(long originUid, byte version, Map<T, Object> dictionary) {
        return new CompressionTable<T>(originUid, version, dictionary);
    }

    public <T> long copy$default$1() {
        return this.originUid();
    }

    public <T> byte copy$default$2() {
        return this.version();
    }

    public <T> Map<T, Object> copy$default$3() {
        return this.dictionary();
    }

    public String productPrefix() {
        return "CompressionTable";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToLong((long)this.originUid());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToByte((byte)this.version());
                break;
            }
            case 2: {
                object = this.dictionary();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CompressionTable;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.originUid()));
        n = Statics.mix((int)n, (int)this.version());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.dictionary()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CompressionTable)) return false;
        boolean bl = true;
        if (!bl) return false;
        CompressionTable compressionTable = (CompressionTable)x$1;
        if (this.originUid() != compressionTable.originUid()) return false;
        if (this.version() != compressionTable.version()) return false;
        Map<T, Object> map = this.dictionary();
        Map<T, Object> map2 = compressionTable.dictionary();
        if (map != null) {
            if (!map.equals(map2)) return false;
            return true;
        }
        if (map2 == null) return true;
        return false;
    }

    public CompressionTable(long originUid, byte version, Map<T, Object> dictionary) {
        this.originUid = originUid;
        this.version = version;
        this.dictionary = dictionary;
        Product.$init$((Product)this);
    }
}

