/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.dispatcher.HistoryServerArchivist;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.history.FsJobArchivist;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.util.Preconditions;

class JsonResponseHistoryServerArchivist
implements HistoryServerArchivist {
    private final JsonArchivist jsonArchivist;
    private final Path archivePath;

    JsonResponseHistoryServerArchivist(JsonArchivist jsonArchivist, Path archivePath) {
        this.jsonArchivist = (JsonArchivist)Preconditions.checkNotNull((Object)jsonArchivist);
        this.archivePath = (Path)Preconditions.checkNotNull((Object)archivePath);
    }

    @Override
    public CompletableFuture<Acknowledge> archiveExecutionGraph(AccessExecutionGraph executionGraph) {
        try {
            FsJobArchivist.archiveJob(this.archivePath, executionGraph.getJobID(), this.jsonArchivist.archiveJsonWithPath(executionGraph));
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
        catch (IOException e) {
            return FutureUtils.completedExceptionally(e);
        }
    }
}

