/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.factories;

import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.jobmaster.JobMasterConfiguration;
import org.apache.flink.runtime.jobmaster.factories.JobManagerJobMetricGroupFactory;
import org.apache.flink.runtime.jobmaster.factories.JobMasterServiceFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulerFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolFactory;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;

public class DefaultJobMasterServiceFactory
implements JobMasterServiceFactory {
    private final JobMasterConfiguration jobMasterConfiguration;
    private final SlotPoolFactory slotPoolFactory;
    private final SchedulerFactory schedulerFactory;
    private final RpcService rpcService;
    private final HighAvailabilityServices haServices;
    private final JobManagerSharedServices jobManagerSharedServices;
    private final HeartbeatServices heartbeatServices;
    private final JobManagerJobMetricGroupFactory jobManagerJobMetricGroupFactory;
    private final FatalErrorHandler fatalErrorHandler;

    public DefaultJobMasterServiceFactory(JobMasterConfiguration jobMasterConfiguration, SlotPoolFactory slotPoolFactory, SchedulerFactory schedulerFactory, RpcService rpcService, HighAvailabilityServices haServices, JobManagerSharedServices jobManagerSharedServices, HeartbeatServices heartbeatServices, JobManagerJobMetricGroupFactory jobManagerJobMetricGroupFactory, FatalErrorHandler fatalErrorHandler) {
        this.jobMasterConfiguration = jobMasterConfiguration;
        this.slotPoolFactory = slotPoolFactory;
        this.schedulerFactory = schedulerFactory;
        this.rpcService = rpcService;
        this.haServices = haServices;
        this.jobManagerSharedServices = jobManagerSharedServices;
        this.heartbeatServices = heartbeatServices;
        this.jobManagerJobMetricGroupFactory = jobManagerJobMetricGroupFactory;
        this.fatalErrorHandler = fatalErrorHandler;
    }

    @Override
    public JobMaster createJobMasterService(JobGraph jobGraph, OnCompletionActions jobCompletionActions, ClassLoader userCodeClassloader) throws Exception {
        return new JobMaster(this.rpcService, this.jobMasterConfiguration, ResourceID.generate(), jobGraph, this.haServices, this.slotPoolFactory, this.schedulerFactory, this.jobManagerSharedServices, this.heartbeatServices, this.jobManagerJobMetricGroupFactory, jobCompletionActions, this.fatalErrorHandler, userCodeClassloader);
    }
}

