/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.List;
import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class JobExceptionsInfo
implements ResponseBody {
    public static final String FIELD_NAME_ROOT_EXCEPTION = "root-exception";
    public static final String FIELD_NAME_TIMESTAMP = "timestamp";
    public static final String FIELD_NAME_ALL_EXCEPTIONS = "all-exceptions";
    public static final String FIELD_NAME_TRUNCATED = "truncated";
    @JsonProperty(value="root-exception")
    private final String rootException;
    @JsonProperty(value="timestamp")
    private final Long rootTimestamp;
    @JsonProperty(value="all-exceptions")
    private final List<ExecutionExceptionInfo> allExceptions;
    @JsonProperty(value="truncated")
    private final boolean truncated;

    @JsonCreator
    public JobExceptionsInfo(@JsonProperty(value="root-exception") String rootException, @JsonProperty(value="timestamp") Long rootTimestamp, @JsonProperty(value="all-exceptions") List<ExecutionExceptionInfo> allExceptions, @JsonProperty(value="truncated") boolean truncated) {
        this.rootException = rootException;
        this.rootTimestamp = rootTimestamp;
        this.allExceptions = (List)Preconditions.checkNotNull(allExceptions);
        this.truncated = truncated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobExceptionsInfo that = (JobExceptionsInfo)o;
        return this.truncated == that.truncated && Objects.equals(this.rootException, that.rootException) && Objects.equals(this.rootTimestamp, that.rootTimestamp) && Objects.equals(this.allExceptions, that.allExceptions);
    }

    public int hashCode() {
        return Objects.hash(this.rootException, this.rootTimestamp, this.allExceptions, this.truncated);
    }

    public static final class ExecutionExceptionInfo {
        public static final String FIELD_NAME_EXCEPTION = "exception";
        public static final String FIELD_NAME_TASK = "task";
        public static final String FIELD_NAME_LOCATION = "location";
        public static final String FIELD_NAME_TIMESTAMP = "timestamp";
        @JsonProperty(value="exception")
        private final String exception;
        @JsonProperty(value="task")
        private final String task;
        @JsonProperty(value="location")
        private final String location;
        @JsonProperty(value="timestamp")
        private final long timestamp;

        @JsonCreator
        public ExecutionExceptionInfo(@JsonProperty(value="exception") String exception, @JsonProperty(value="task") String task, @JsonProperty(value="location") String location, @JsonProperty(value="timestamp") long timestamp) {
            this.exception = (String)Preconditions.checkNotNull((Object)exception);
            this.task = (String)Preconditions.checkNotNull((Object)task);
            this.location = (String)Preconditions.checkNotNull((Object)location);
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionExceptionInfo that = (ExecutionExceptionInfo)o;
            return this.timestamp == that.timestamp && Objects.equals(this.exception, that.exception) && Objects.equals(this.task, that.task) && Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.exception, this.task, this.location);
        }
    }
}

