/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import akka.actor.ActorSystem;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.entrypoint.ClusterConfiguration;
import org.apache.flink.runtime.entrypoint.ClusterConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalException;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskexecutor.HostBindPolicy;
import org.apache.flink.runtime.taskexecutor.TaskExecutor;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskmanager.MemoryLogger;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerRunner
implements FatalErrorHandler,
AutoCloseableAsync {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerRunner.class);
    private static final long FATAL_ERROR_SHUTDOWN_TIMEOUT_MS = 10000L;
    private static final int STARTUP_FAILURE_RETURN_CODE = 1;
    public static final int RUNTIME_FAILURE_RETURN_CODE = 2;
    private final Object lock = new Object();
    private final Configuration configuration;
    private final ResourceID resourceId;
    private final Time timeout;
    private final RpcService rpcService;
    private final ActorSystem metricQueryServiceActorSystem;
    private final HighAvailabilityServices highAvailabilityServices;
    private final MetricRegistryImpl metricRegistry;
    private final BlobCacheService blobCacheService;
    private final ExecutorService executor;
    private final TaskExecutor taskManager;
    private final CompletableFuture<Void> terminationFuture;
    private boolean shutdown;

    public TaskManagerRunner(Configuration configuration, ResourceID resourceId) throws Exception {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId);
        this.timeout = AkkaUtils.getTimeoutAsTime(configuration);
        this.executor = Executors.newScheduledThreadPool(Hardware.getNumberCPUCores(), new ExecutorThreadFactory("taskmanager-future"));
        this.highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices(configuration, this.executor, HighAvailabilityServicesUtils.AddressResolution.TRY_ADDRESS_RESOLUTION);
        this.rpcService = TaskManagerRunner.createRpcService(configuration, this.highAvailabilityServices);
        this.metricQueryServiceActorSystem = MetricUtils.startMetricsActorSystem(configuration, this.rpcService.getAddress(), LOG);
        HeartbeatServices heartbeatServices = HeartbeatServices.fromConfiguration(configuration);
        this.metricRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration(configuration));
        this.metricRegistry.startQueryService(this.metricQueryServiceActorSystem, resourceId);
        this.blobCacheService = new BlobCacheService(configuration, this.highAvailabilityServices.createBlobStore(), null);
        this.taskManager = TaskManagerRunner.startTaskManager(this.configuration, this.resourceId, this.rpcService, this.highAvailabilityServices, heartbeatServices, this.metricRegistry, this.blobCacheService, false, this);
        this.terminationFuture = new CompletableFuture();
        this.shutdown = false;
        MemoryLogger.startIfConfigured(LOG, configuration, this.metricQueryServiceActorSystem);
    }

    public void start() throws Exception {
        this.taskManager.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
                CompletableFuture<Void> taskManagerTerminationFuture = this.taskManager.closeAsync();
                CompletableFuture<Void> serviceTerminationFuture = FutureUtils.composeAfterwards(taskManagerTerminationFuture, this::shutDownServices);
                serviceTerminationFuture.whenComplete((ignored, throwable) -> {
                    if (throwable != null) {
                        this.terminationFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        this.terminationFuture.complete(null);
                    }
                });
            }
        }
        return this.terminationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> shutDownServices() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList terminationFutures = new ArrayList(3);
            Exception exception = null;
            try {
                this.blobCacheService.close();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
            }
            try {
                this.metricRegistry.shutdown();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            if (this.metricQueryServiceActorSystem != null) {
                terminationFutures.add(AkkaUtils.terminateActorSystem(this.metricQueryServiceActorSystem));
            }
            try {
                this.highAvailabilityServices.close();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            terminationFutures.add(this.rpcService.stopService());
            terminationFutures.add(ExecutorUtils.nonBlockingShutdown((long)this.timeout.toMilliseconds(), (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{this.executor}));
            if (exception != null) {
                terminationFutures.add(FutureUtils.completedExceptionally(exception));
            }
            return FutureUtils.completeAll(terminationFutures);
        }
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }

    @Override
    public void onFatalError(Throwable exception) {
        LOG.error("Fatal error occurred while executing the TaskManager. Shutting it down...", exception);
        if (ExceptionUtils.isJvmFatalOrOutOfMemoryError((Throwable)exception)) {
            this.terminateJVM();
        } else {
            this.closeAsync();
            FutureUtils.orTimeout(this.terminationFuture, 10000L, TimeUnit.MILLISECONDS);
            this.terminationFuture.whenComplete((ignored, throwable) -> this.terminateJVM());
        }
    }

    private void terminateJVM() {
        System.exit(2);
    }

    public static void main(String[] args) throws Exception {
        EnvironmentInformation.logEnvironmentInfo(LOG, "TaskManager", args);
        SignalHandler.register(LOG);
        JvmShutdownSafeguard.installAsShutdownHook(LOG);
        long maxOpenFileHandles = EnvironmentInformation.getOpenFileHandlesLimit();
        if (maxOpenFileHandles != -1L) {
            LOG.info("Maximum number of open file descriptors is {}.", (Object)maxOpenFileHandles);
        } else {
            LOG.info("Cannot determine the maximum number of open file descriptors");
        }
        final Configuration configuration = TaskManagerRunner.loadConfiguration(args);
        try {
            FileSystem.initialize((Configuration)configuration);
        }
        catch (IOException e) {
            throw new IOException("Error while setting the default filesystem scheme from configuration.", e);
        }
        SecurityUtils.install(new SecurityConfiguration(configuration));
        try {
            SecurityUtils.getInstalledContext().runSecured(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TaskManagerRunner.runTaskManager(configuration, ResourceID.generate());
                    return null;
                }
            });
        }
        catch (Throwable t) {
            Throwable strippedThrowable = ExceptionUtils.stripException((Throwable)t, UndeclaredThrowableException.class);
            LOG.error("TaskManager initialization failed.", strippedThrowable);
            System.exit(1);
        }
    }

    @VisibleForTesting
    static Configuration loadConfiguration(String[] args) throws FlinkParseException {
        ClusterConfiguration clusterConfiguration;
        CommandLineParser<ClusterConfiguration> commandLineParser = new CommandLineParser<ClusterConfiguration>(new ClusterConfigurationParserFactory());
        try {
            clusterConfiguration = commandLineParser.parse(args);
        }
        catch (FlinkParseException e) {
            LOG.error("Could not parse the command line options.", (Throwable)((Object)e));
            commandLineParser.printHelp(TaskManagerRunner.class.getSimpleName());
            throw e;
        }
        Configuration dynamicProperties = ConfigurationUtils.createConfiguration((Properties)clusterConfiguration.getDynamicProperties());
        return GlobalConfiguration.loadConfiguration((String)clusterConfiguration.getConfigDir(), (Configuration)dynamicProperties);
    }

    public static void runTaskManager(Configuration configuration, ResourceID resourceId) throws Exception {
        TaskManagerRunner taskManagerRunner = new TaskManagerRunner(configuration, resourceId);
        taskManagerRunner.start();
    }

    public static TaskExecutor startTaskManager(Configuration configuration, ResourceID resourceID, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, BlobCacheService blobCacheService, boolean localCommunicationOnly, FatalErrorHandler fatalErrorHandler) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)resourceID);
        Preconditions.checkNotNull((Object)rpcService);
        Preconditions.checkNotNull((Object)highAvailabilityServices);
        LOG.info("Starting TaskManager with ResourceID: {}", (Object)resourceID);
        InetAddress remoteAddress = InetAddress.getByName(rpcService.getAddress());
        TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration(configuration, remoteAddress, localCommunicationOnly);
        TaskManagerServices taskManagerServices = TaskManagerServices.fromConfiguration(taskManagerServicesConfiguration, resourceID, rpcService.getExecutor(), EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag(), EnvironmentInformation.getMaxJvmHeapMemory());
        TaskManagerMetricGroup taskManagerMetricGroup = MetricUtils.instantiateTaskManagerMetricGroup(metricRegistry, taskManagerServices.getTaskManagerLocation(), taskManagerServices.getNetworkEnvironment(), taskManagerServicesConfiguration.getSystemResourceMetricsProbingInterval());
        TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration(configuration);
        String metricQueryServicePath = metricRegistry.getMetricQueryServicePath();
        return new TaskExecutor(rpcService, taskManagerConfiguration, highAvailabilityServices, taskManagerServices, heartbeatServices, taskManagerMetricGroup, metricQueryServicePath, blobCacheService, fatalErrorHandler);
    }

    public static RpcService createRpcService(Configuration configuration, HighAvailabilityServices haServices) throws Exception {
        Preconditions.checkNotNull((Object)configuration);
        Preconditions.checkNotNull((Object)haServices);
        String taskManagerAddress = TaskManagerRunner.determineTaskManagerBindAddress(configuration, haServices);
        String portRangeDefinition = configuration.getString(TaskManagerOptions.RPC_PORT);
        return AkkaRpcServiceUtils.createRpcService(taskManagerAddress, portRangeDefinition, configuration);
    }

    private static String determineTaskManagerBindAddress(Configuration configuration, HighAvailabilityServices haServices) throws Exception {
        String configuredTaskManagerHostname = configuration.getString(TaskManagerOptions.HOST);
        if (configuredTaskManagerHostname != null) {
            LOG.info("Using configured hostname/address for TaskManager: {}.", (Object)configuredTaskManagerHostname);
            return configuredTaskManagerHostname;
        }
        return TaskManagerRunner.determineTaskManagerBindAddressByConnectingToResourceManager(configuration, haServices);
    }

    private static String determineTaskManagerBindAddressByConnectingToResourceManager(Configuration configuration, HighAvailabilityServices haServices) throws LeaderRetrievalException {
        Time lookupTimeout = Time.milliseconds((long)AkkaUtils.getLookupTimeout(configuration).toMillis());
        InetAddress taskManagerAddress = LeaderRetrievalUtils.findConnectingAddress(haServices.getResourceManagerLeaderRetriever(), lookupTimeout);
        LOG.info("TaskManager will use hostname/address '{}' ({}) for communication.", (Object)taskManagerAddress.getHostName(), (Object)taskManagerAddress.getHostAddress());
        HostBindPolicy bindPolicy = HostBindPolicy.fromString(configuration.getString(TaskManagerOptions.HOST_BIND_POLICY));
        return bindPolicy == HostBindPolicy.IP ? taskManagerAddress.getHostAddress() : taskManagerAddress.getHostName();
    }
}

