/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.util.Preconditions;

public class ResourceProfile
implements Serializable,
Comparable<ResourceProfile> {
    private static final long serialVersionUID = 1L;
    public static final ResourceProfile UNKNOWN = new ResourceProfile();
    public static final ResourceProfile ANY = new ResourceProfile(Double.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Collections.emptyMap());
    public static final ResourceProfile ZERO = new ResourceProfile(0.0, 0);
    private final double cpuCores;
    private final int heapMemoryInMB;
    private final int directMemoryInMB;
    private final int nativeMemoryInMB;
    private final int networkMemoryInMB;
    private final int managedMemoryInMB;
    private final Map<String, Resource> extendedResources = new HashMap<String, Resource>(1);

    public ResourceProfile(double cpuCores, int heapMemoryInMB, int directMemoryInMB, int nativeMemoryInMB, int networkMemoryInMB, int managedMemoryInMB, Map<String, Resource> extendedResources) {
        Preconditions.checkArgument((cpuCores >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((heapMemoryInMB >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((directMemoryInMB >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((nativeMemoryInMB >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((networkMemoryInMB >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((managedMemoryInMB >= 0 ? 1 : 0) != 0);
        this.cpuCores = cpuCores;
        this.heapMemoryInMB = heapMemoryInMB;
        this.directMemoryInMB = directMemoryInMB;
        this.nativeMemoryInMB = nativeMemoryInMB;
        this.networkMemoryInMB = networkMemoryInMB;
        this.managedMemoryInMB = managedMemoryInMB;
        if (extendedResources != null) {
            this.extendedResources.putAll(extendedResources);
        }
    }

    public ResourceProfile(double cpuCores, int heapMemoryInMB) {
        this(cpuCores, heapMemoryInMB, 0, 0, 0, 0, Collections.emptyMap());
    }

    private ResourceProfile() {
        this.cpuCores = -1.0;
        this.heapMemoryInMB = -1;
        this.directMemoryInMB = -1;
        this.nativeMemoryInMB = -1;
        this.networkMemoryInMB = -1;
        this.managedMemoryInMB = -1;
    }

    public ResourceProfile(ResourceProfile other) {
        this(other.cpuCores, other.heapMemoryInMB, other.directMemoryInMB, other.nativeMemoryInMB, other.networkMemoryInMB, other.managedMemoryInMB, other.extendedResources);
    }

    public double getCpuCores() {
        return this.cpuCores;
    }

    public int getHeapMemoryInMB() {
        return this.heapMemoryInMB;
    }

    public int getDirectMemoryInMB() {
        return this.directMemoryInMB;
    }

    public int getNativeMemoryInMB() {
        return this.nativeMemoryInMB;
    }

    public int getNetworkMemoryInMB() {
        return this.networkMemoryInMB;
    }

    public int getManagedMemoryInMB() {
        return this.managedMemoryInMB;
    }

    public int getMemoryInMB() {
        return this.heapMemoryInMB + this.directMemoryInMB + this.nativeMemoryInMB + this.networkMemoryInMB + this.managedMemoryInMB;
    }

    public int getOperatorsMemoryInMB() {
        return this.heapMemoryInMB + this.directMemoryInMB + this.nativeMemoryInMB + this.managedMemoryInMB;
    }

    public Map<String, Resource> getExtendedResources() {
        return Collections.unmodifiableMap(this.extendedResources);
    }

    public boolean isMatching(ResourceProfile required) {
        if (required == UNKNOWN) {
            return true;
        }
        if (this.cpuCores >= required.getCpuCores() && this.heapMemoryInMB >= required.getHeapMemoryInMB() && this.directMemoryInMB >= required.getDirectMemoryInMB() && this.nativeMemoryInMB >= required.getNativeMemoryInMB() && this.networkMemoryInMB >= required.getNetworkMemoryInMB() && this.managedMemoryInMB >= required.getManagedMemoryInMB()) {
            for (Map.Entry<String, Resource> resource : required.extendedResources.entrySet()) {
                if (this.extendedResources.containsKey(resource.getKey()) && this.extendedResources.get(resource.getKey()).getResourceAggregateType().equals((Object)resource.getValue().getResourceAggregateType()) && !(this.extendedResources.get(resource.getKey()).getValue() < resource.getValue().getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(@Nonnull ResourceProfile other) {
        int cmp = Integer.compare(this.getMemoryInMB(), other.getMemoryInMB());
        if (cmp == 0) {
            cmp = Double.compare(this.cpuCores, other.cpuCores);
        }
        if (cmp == 0) {
            Iterator<Map.Entry<String, Resource>> thisIterator = this.extendedResources.entrySet().iterator();
            Iterator<Map.Entry<String, Resource>> otherIterator = other.extendedResources.entrySet().iterator();
            while (thisIterator.hasNext() && otherIterator.hasNext()) {
                Map.Entry<String, Resource> thisResource = thisIterator.next();
                Map.Entry<String, Resource> otherResource = otherIterator.next();
                cmp = otherResource.getKey().compareTo(thisResource.getKey());
                if (cmp != 0) {
                    return cmp;
                }
                if (!otherResource.getValue().getResourceAggregateType().equals((Object)thisResource.getValue().getResourceAggregateType())) {
                    return 1;
                }
                cmp = Double.compare(thisResource.getValue().getValue(), otherResource.getValue().getValue());
                if (cmp == 0) continue;
                return cmp;
            }
            if (thisIterator.hasNext()) {
                return 1;
            }
            if (otherIterator.hasNext()) {
                return -1;
            }
        }
        return cmp;
    }

    public int hashCode() {
        long cpuBits = Double.doubleToLongBits(this.cpuCores);
        int result = (int)(cpuBits ^ cpuBits >>> 32);
        result = 31 * result + this.heapMemoryInMB;
        result = 31 * result + this.directMemoryInMB;
        result = 31 * result + this.nativeMemoryInMB;
        result = 31 * result + this.networkMemoryInMB;
        result = 31 * result + this.managedMemoryInMB;
        result = 31 * result + this.extendedResources.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == ResourceProfile.class) {
            ResourceProfile that = (ResourceProfile)obj;
            return this.cpuCores == that.cpuCores && this.heapMemoryInMB == that.heapMemoryInMB && this.directMemoryInMB == that.directMemoryInMB && this.nativeMemoryInMB == that.nativeMemoryInMB && this.networkMemoryInMB == that.networkMemoryInMB && this.managedMemoryInMB == that.managedMemoryInMB && Objects.equals(this.extendedResources, that.extendedResources);
        }
        return false;
    }

    @Nonnull
    public ResourceProfile merge(@Nonnull ResourceProfile other) {
        if (this.equals(ANY) || other.equals(ANY)) {
            return ANY;
        }
        if (this.equals(UNKNOWN) || other.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        HashMap<String, Resource> resultExtendedResource = new HashMap<String, Resource>(this.extendedResources);
        other.extendedResources.forEach((name, resource) -> resultExtendedResource.compute((String)name, (ignored, oldResource) -> oldResource == null ? resource : oldResource.merge(resource)));
        return new ResourceProfile(this.addNonNegativeDoublesConsideringOverflow(this.cpuCores, other.cpuCores), this.addNonNegativeIntegersConsideringOverflow(this.heapMemoryInMB, other.heapMemoryInMB), this.addNonNegativeIntegersConsideringOverflow(this.directMemoryInMB, other.directMemoryInMB), this.addNonNegativeIntegersConsideringOverflow(this.nativeMemoryInMB, other.nativeMemoryInMB), this.addNonNegativeIntegersConsideringOverflow(this.networkMemoryInMB, other.networkMemoryInMB), this.addNonNegativeIntegersConsideringOverflow(this.managedMemoryInMB, other.managedMemoryInMB), resultExtendedResource);
    }

    public ResourceProfile subtract(ResourceProfile other) {
        if (this.equals(ANY) || other.equals(ANY)) {
            return ANY;
        }
        if (this.equals(UNKNOWN) || other.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        Preconditions.checkArgument((boolean)this.isMatching(other), (Object)"Try to subtract an unmatched resource profile from this one.");
        HashMap<String, Resource> resultExtendedResource = new HashMap<String, Resource>(this.extendedResources);
        other.extendedResources.forEach((name, resource) -> resultExtendedResource.compute((String)name, (ignored, oldResource) -> {
            Resource resultResource = oldResource.subtract(resource);
            return resultResource.getValue() == 0.0 ? null : resultResource;
        }));
        return new ResourceProfile(this.subtractDoublesConsideringInf(this.cpuCores, other.cpuCores), this.subtractIntegersConsideringInf(this.heapMemoryInMB, other.heapMemoryInMB), this.subtractIntegersConsideringInf(this.directMemoryInMB, other.directMemoryInMB), this.subtractIntegersConsideringInf(this.nativeMemoryInMB, other.nativeMemoryInMB), this.subtractIntegersConsideringInf(this.networkMemoryInMB, other.networkMemoryInMB), this.subtractIntegersConsideringInf(this.managedMemoryInMB, other.managedMemoryInMB), resultExtendedResource);
    }

    private double addNonNegativeDoublesConsideringOverflow(double first, double second) {
        double result = first + second;
        if (result == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        return result;
    }

    private int addNonNegativeIntegersConsideringOverflow(int first, int second) {
        int result = first + second;
        if (result < 0) {
            return Integer.MAX_VALUE;
        }
        return result;
    }

    private double subtractDoublesConsideringInf(double first, double second) {
        return first == Double.MAX_VALUE ? Double.MAX_VALUE : first - second;
    }

    private int subtractIntegersConsideringInf(int first, int second) {
        return first == Integer.MAX_VALUE ? Integer.MAX_VALUE : first - second;
    }

    public String toString() {
        StringBuilder resources = new StringBuilder(this.extendedResources.size() * 10);
        for (Map.Entry<String, Resource> resource : this.extendedResources.entrySet()) {
            resources.append(", ").append(resource.getKey()).append('=').append(resource.getValue());
        }
        return "ResourceProfile{cpuCores=" + this.cpuCores + ", heapMemoryInMB=" + this.heapMemoryInMB + ", directMemoryInMB=" + this.directMemoryInMB + ", nativeMemoryInMB=" + this.nativeMemoryInMB + ", networkMemoryInMB=" + this.networkMemoryInMB + ", managedMemoryInMB=" + this.managedMemoryInMB + resources + '}';
    }

    private Object readResolve() {
        return this.equals(UNKNOWN) ? UNKNOWN : this;
    }

    public static ResourceProfile fromResourceSpec(ResourceSpec resourceSpec, int networkMemory) {
        if (ResourceSpec.UNKNOWN.equals((Object)resourceSpec)) {
            return UNKNOWN;
        }
        HashMap<String, Resource> copiedExtendedResources = new HashMap<String, Resource>(resourceSpec.getExtendedResources());
        return new ResourceProfile(resourceSpec.getCpuCores(), resourceSpec.getHeapMemory(), resourceSpec.getDirectMemory(), resourceSpec.getNativeMemory(), networkMemory, resourceSpec.getManagedMemory(), copiedExtendedResources);
    }
}

