/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverEdge;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverTopology;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailoverVertex;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.PipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelinedRegionComputeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedRegionComputeUtil.class);

    public static Set<PipelinedRegion> toPipelinedRegionsSet(Set<Set<FailoverVertex>> distinctRegions) {
        return distinctRegions.stream().map(PipelinedRegionComputeUtil.toExecutionVertexIdSet()).map(PipelinedRegion::from).collect(Collectors.toSet());
    }

    private static Function<Set<FailoverVertex>, Set<ExecutionVertexID>> toExecutionVertexIdSet() {
        return failoverVertices -> failoverVertices.stream().map(FailoverVertex::getExecutionVertexID).collect(Collectors.toSet());
    }

    public static Set<Set<FailoverVertex>> computePipelinedRegions(FailoverTopology topology) {
        if (topology.containsCoLocationConstraints()) {
            return PipelinedRegionComputeUtil.uniqueRegions(PipelinedRegionComputeUtil.buildOneRegionForAllVertices(topology));
        }
        IdentityHashMap<FailoverVertex, Set<FailoverVertex>> vertexToRegion = new IdentityHashMap<FailoverVertex, Set<FailoverVertex>>();
        for (FailoverVertex failoverVertex : topology.getFailoverVertices()) {
            HashSet<FailoverVertex> currentRegion = new HashSet<FailoverVertex>(1);
            currentRegion.add(failoverVertex);
            vertexToRegion.put(failoverVertex, currentRegion);
            for (FailoverEdge failoverEdge : failoverVertex.getInputEdges()) {
                HashSet<FailoverVertex> largerSet;
                HashSet smallerSet;
                if (!failoverEdge.getResultPartitionType().isPipelined()) continue;
                FailoverVertex producerVertex = failoverEdge.getSourceVertex();
                HashSet<FailoverVertex> producerRegion = (HashSet<FailoverVertex>)vertexToRegion.get(producerVertex);
                if (producerRegion == null) {
                    throw new IllegalStateException("Producer task " + producerVertex.getExecutionVertexName() + " failover region is null while calculating failover region for the consumer task " + failoverVertex.getExecutionVertexName() + ". This should be a failover region building bug.");
                }
                if (currentRegion == producerRegion) continue;
                if (currentRegion.size() < producerRegion.size()) {
                    smallerSet = currentRegion;
                    largerSet = producerRegion;
                } else {
                    smallerSet = producerRegion;
                    largerSet = currentRegion;
                }
                for (FailoverVertex v : smallerSet) {
                    vertexToRegion.put(v, largerSet);
                }
                largerSet.addAll(smallerSet);
                currentRegion = largerSet;
            }
        }
        return PipelinedRegionComputeUtil.uniqueRegions(vertexToRegion);
    }

    private static Map<FailoverVertex, Set<FailoverVertex>> buildOneRegionForAllVertices(FailoverTopology topology) {
        LOG.warn("Cannot decompose the topology into individual failover regions due to use of Co-Location constraints (iterations). Job will fail over as one holistic unit.");
        IdentityHashMap<FailoverVertex, Set<FailoverVertex>> vertexToRegion = new IdentityHashMap<FailoverVertex, Set<FailoverVertex>>();
        HashSet<FailoverVertex> allVertices = new HashSet<FailoverVertex>();
        for (FailoverVertex failoverVertex : topology.getFailoverVertices()) {
            allVertices.add(failoverVertex);
            vertexToRegion.put(failoverVertex, allVertices);
        }
        return vertexToRegion;
    }

    private static Set<Set<FailoverVertex>> uniqueRegions(Map<FailoverVertex, Set<FailoverVertex>> vertexToRegion) {
        Set<Set<FailoverVertex>> distinctRegions = Collections.newSetFromMap(new IdentityHashMap());
        distinctRegions.addAll(vertexToRegion.values());
        return distinctRegions;
    }

    private PipelinedRegionComputeUtil() {
    }
}

