/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public enum LocationPreferenceSlotSelectionStrategy implements SlotSelectionStrategy
{
    INSTANCE;

    private static final BiFunction<Integer, Integer, Integer> LOCALITY_EVALUATION_FUNCTION;

    @Override
    public Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectBestSlotForProfile(@Nonnull Collection<SlotSelectionStrategy.SlotInfoAndResources> availableSlots, @Nonnull SlotProfile slotProfile) {
        Collection<TaskManagerLocation> locationPreferences = slotProfile.getPreferredLocations();
        if (availableSlots.isEmpty()) {
            return Optional.empty();
        }
        ResourceProfile resourceProfile = slotProfile.getResourceProfile();
        return locationPreferences.isEmpty() ? this.selectWithoutLocationPreference(availableSlots, resourceProfile) : this.selectWitLocationPreference(availableSlots, locationPreferences, resourceProfile);
    }

    @Nonnull
    private Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWithoutLocationPreference(@Nonnull Collection<SlotSelectionStrategy.SlotInfoAndResources> availableSlots, @Nonnull ResourceProfile resourceProfile) {
        for (SlotSelectionStrategy.SlotInfoAndResources candidate : availableSlots) {
            if (!candidate.getRemainingResources().isMatching(resourceProfile)) continue;
            return Optional.of(SlotSelectionStrategy.SlotInfoAndLocality.of(candidate.getSlotInfo(), Locality.UNCONSTRAINED));
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWitLocationPreference(@Nonnull Collection<SlotSelectionStrategy.SlotInfoAndResources> availableSlots, @Nonnull Collection<TaskManagerLocation> locationPreferences, @Nonnull ResourceProfile resourceProfile) {
        HashMap<ResourceID, Integer> preferredResourceIDs = new HashMap<ResourceID, Integer>(locationPreferences.size());
        HashMap<String, Integer> preferredFQHostNames = new HashMap<String, Integer>(locationPreferences.size());
        for (TaskManagerLocation locationPreference : locationPreferences) {
            preferredResourceIDs.merge(locationPreference.getResourceID(), 1, Integer::sum);
            preferredFQHostNames.merge(locationPreference.getFQDNHostname(), 1, Integer::sum);
        }
        SlotSelectionStrategy.SlotInfoAndResources bestCandidate = null;
        Locality bestCandidateLocality = Locality.UNKNOWN;
        int bestCandidateScore = Integer.MIN_VALUE;
        for (SlotSelectionStrategy.SlotInfoAndResources candidate : availableSlots) {
            Integer hostLocalWeigh;
            Integer localWeigh;
            int candidateScore;
            if (!candidate.getRemainingResources().isMatching(resourceProfile) || (candidateScore = LOCALITY_EVALUATION_FUNCTION.apply(localWeigh = preferredResourceIDs.getOrDefault(candidate.getSlotInfo().getTaskManagerLocation().getResourceID(), 0), hostLocalWeigh = preferredFQHostNames.getOrDefault(candidate.getSlotInfo().getTaskManagerLocation().getFQDNHostname(), 0)).intValue()) <= bestCandidateScore) continue;
            bestCandidateScore = candidateScore;
            bestCandidate = candidate;
            bestCandidateLocality = localWeigh > 0 ? Locality.LOCAL : (hostLocalWeigh > 0 ? Locality.HOST_LOCAL : Locality.NON_LOCAL);
        }
        return bestCandidate != null ? Optional.of(SlotSelectionStrategy.SlotInfoAndLocality.of(bestCandidate.getSlotInfo(), bestCandidateLocality)) : Optional.empty();
    }

    static {
        LOCALITY_EVALUATION_FUNCTION = (localWeigh, hostLocalWeigh) -> localWeigh * 10 + hostLocalWeigh;
    }
}

