/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;

public enum PreviousAllocationSlotSelectionStrategy implements SlotSelectionStrategy
{
    INSTANCE;


    @Override
    public Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectBestSlotForProfile(@Nonnull Collection<SlotSelectionStrategy.SlotInfoAndResources> availableSlots, @Nonnull SlotProfile slotProfile) {
        Collection<AllocationID> priorAllocations = slotProfile.getPreferredAllocations();
        if (!priorAllocations.isEmpty()) {
            for (SlotSelectionStrategy.SlotInfoAndResources availableSlot : availableSlots) {
                if (!priorAllocations.contains((Object)availableSlot.getSlotInfo().getAllocationId())) continue;
                return Optional.of(SlotSelectionStrategy.SlotInfoAndLocality.of(availableSlot.getSlotInfo(), Locality.LOCAL));
            }
        }
        Set<AllocationID> blackListedAllocations = slotProfile.getPreviousExecutionGraphAllocations();
        Collection<SlotSelectionStrategy.SlotInfoAndResources> availableAndAllowedSlots = this.computeWithoutBlacklistedSlots(availableSlots, blackListedAllocations);
        return LocationPreferenceSlotSelectionStrategy.INSTANCE.selectBestSlotForProfile(availableAndAllowedSlots, slotProfile);
    }

    @Nonnull
    private Collection<SlotSelectionStrategy.SlotInfoAndResources> computeWithoutBlacklistedSlots(@Nonnull Collection<SlotSelectionStrategy.SlotInfoAndResources> availableSlots, @Nonnull Set<AllocationID> blacklistedAllocations) {
        if (blacklistedAllocations.isEmpty()) {
            return Collections.unmodifiableCollection(availableSlots);
        }
        ArrayList<SlotSelectionStrategy.SlotInfoAndResources> availableAndAllowedSlots = new ArrayList<SlotSelectionStrategy.SlotInfoAndResources>(availableSlots.size());
        for (SlotSelectionStrategy.SlotInfoAndResources availableSlot : availableSlots) {
            if (blacklistedAllocations.contains((Object)availableSlot.getSlotInfo().getAllocationId())) continue;
            availableAndAllowedSlots.add(availableSlot);
        }
        return availableAndAllowedSlots;
    }
}

