/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.backpressure;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.util.Preconditions;

public class OperatorBackPressureStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int sampleId;
    private final long endTimestamp;
    private final double[] subTaskBackPressureRatio;
    private final double maxSubTaskBackPressureRatio;

    public OperatorBackPressureStats(int sampleId, long endTimestamp, double[] subTaskBackPressureRatio) {
        this.sampleId = sampleId;
        this.endTimestamp = endTimestamp;
        this.subTaskBackPressureRatio = (double[])Preconditions.checkNotNull((Object)subTaskBackPressureRatio, (String)"Sub task back pressure ratio");
        Preconditions.checkArgument((subTaskBackPressureRatio.length >= 1 ? 1 : 0) != 0, (Object)"No Sub task back pressure ratio specified");
        double max = 0.0;
        for (double ratio : subTaskBackPressureRatio) {
            if (!(ratio > max)) continue;
            max = ratio;
        }
        this.maxSubTaskBackPressureRatio = max;
    }

    public int getSampleId() {
        return this.sampleId;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public int getNumberOfSubTasks() {
        return this.subTaskBackPressureRatio.length;
    }

    public double getBackPressureRatio(int index) {
        return this.subTaskBackPressureRatio[index];
    }

    public double getMaxBackPressureRatio() {
        return this.maxSubTaskBackPressureRatio;
    }

    public String toString() {
        return "OperatorBackPressureStats{sampleId=" + this.sampleId + ", endTimestamp=" + this.endTimestamp + ", subTaskBackPressureRatio=" + Arrays.toString(this.subTaskBackPressureRatio) + '}';
    }
}

