/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnegative;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.taskexecutor.StackTraceSampleableTask;
import org.apache.flink.util.Preconditions;

class StackTraceSampleService {
    private final ScheduledExecutor scheduledExecutor;

    StackTraceSampleService(ScheduledExecutor scheduledExecutor) {
        this.scheduledExecutor = Objects.requireNonNull(scheduledExecutor, "scheduledExecutor must not be null");
    }

    public CompletableFuture<List<StackTraceElement[]>> requestStackTraceSample(StackTraceSampleableTask task, @Nonnegative int numSamples, Time delayBetweenSamples, int maxStackTraceDepth) {
        Preconditions.checkNotNull((Object)task, (String)"task must not be null");
        Preconditions.checkArgument((numSamples > 0 ? 1 : 0) != 0, (Object)"numSamples must be positive");
        Preconditions.checkNotNull((Object)delayBetweenSamples, (String)"delayBetweenSamples must not be null");
        return this.requestStackTraceSample(task, numSamples, delayBetweenSamples, maxStackTraceDepth, new ArrayList<StackTraceElement[]>(numSamples), new CompletableFuture<List<StackTraceElement[]>>());
    }

    private CompletableFuture<List<StackTraceElement[]>> requestStackTraceSample(StackTraceSampleableTask task, int numSamples, Time delayBetweenSamples, int maxStackTraceDepth, List<StackTraceElement[]> currentTraces, CompletableFuture<List<StackTraceElement[]>> resultFuture) {
        Optional<StackTraceElement[]> stackTrace = this.getStackTrace(task, maxStackTraceDepth);
        if (!stackTrace.isPresent()) {
            if (!currentTraces.isEmpty()) {
                resultFuture.complete(currentTraces);
                return resultFuture;
            }
            throw new IllegalStateException(String.format("Cannot sample task %s. The task is not running.", new Object[]{task.getExecutionId()}));
        }
        currentTraces.add(stackTrace.get());
        if (numSamples > 1) {
            this.scheduledExecutor.schedule(() -> this.requestStackTraceSample(task, numSamples - 1, delayBetweenSamples, maxStackTraceDepth, currentTraces, resultFuture), delayBetweenSamples.getSize(), delayBetweenSamples.getUnit());
        } else {
            resultFuture.complete(currentTraces);
        }
        return resultFuture;
    }

    private Optional<StackTraceElement[]> getStackTrace(StackTraceSampleableTask task, int maxStackTraceDepth) {
        if (!task.isRunning()) {
            return Optional.empty();
        }
        StackTraceElement[] stackTrace = task.getStackTrace();
        return Optional.of(this.truncateStackTrace(stackTrace, maxStackTraceDepth));
    }

    private StackTraceElement[] truncateStackTrace(StackTraceElement[] stackTrace, int maxStackTraceDepth) {
        if (maxStackTraceDepth > 0) {
            return Arrays.copyOfRange(stackTrace, 0, Math.min(maxStackTraceDepth, stackTrace.length));
        }
        return stackTrace;
    }
}

