/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.util.Preconditions;

public class CheckpointOptions
implements Serializable {
    private static final long serialVersionUID = 5010126558083292915L;
    private final CheckpointType checkpointType;
    private final CheckpointStorageLocationReference targetLocation;
    private static final CheckpointOptions CHECKPOINT_AT_DEFAULT_LOCATION = new CheckpointOptions(CheckpointType.CHECKPOINT, CheckpointStorageLocationReference.getDefault());

    public CheckpointOptions(CheckpointType checkpointType, CheckpointStorageLocationReference targetLocation) {
        this.checkpointType = (CheckpointType)((Object)Preconditions.checkNotNull((Object)((Object)checkpointType)));
        this.targetLocation = (CheckpointStorageLocationReference)Preconditions.checkNotNull((Object)targetLocation);
    }

    public CheckpointType getCheckpointType() {
        return this.checkpointType;
    }

    public CheckpointStorageLocationReference getTargetLocation() {
        return this.targetLocation;
    }

    public int hashCode() {
        return 31 * this.targetLocation.hashCode() + this.checkpointType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == CheckpointOptions.class) {
            CheckpointOptions that = (CheckpointOptions)obj;
            return this.checkpointType == that.checkpointType && this.targetLocation.equals(that.targetLocation);
        }
        return false;
    }

    public String toString() {
        return "CheckpointOptions: " + (Object)((Object)this.checkpointType) + " @ " + this.targetLocation;
    }

    public static CheckpointOptions forCheckpointWithDefaultLocation() {
        return CHECKPOINT_AT_DEFAULT_LOCATION;
    }
}

