/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.util.Preconditions;

public class CheckpointProperties
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final CheckpointType checkpointType;
    private final boolean forced;
    private final boolean discardSubsumed;
    private final boolean discardFinished;
    private final boolean discardCancelled;
    private final boolean discardFailed;
    private final boolean discardSuspended;
    private static final CheckpointProperties SYNC_SAVEPOINT = new CheckpointProperties(true, CheckpointType.SYNC_SAVEPOINT, false, false, false, false, false);
    private static final CheckpointProperties SAVEPOINT = new CheckpointProperties(true, CheckpointType.SAVEPOINT, false, false, false, false, false);
    private static final CheckpointProperties CHECKPOINT_NEVER_RETAINED = new CheckpointProperties(false, CheckpointType.CHECKPOINT, true, true, true, true, true);
    private static final CheckpointProperties CHECKPOINT_RETAINED_ON_FAILURE = new CheckpointProperties(false, CheckpointType.CHECKPOINT, true, true, true, false, true);
    private static final CheckpointProperties CHECKPOINT_RETAINED_ON_CANCELLATION = new CheckpointProperties(false, CheckpointType.CHECKPOINT, true, true, false, false, false);

    @VisibleForTesting
    CheckpointProperties(boolean forced, CheckpointType checkpointType, boolean discardSubsumed, boolean discardFinished, boolean discardCancelled, boolean discardFailed, boolean discardSuspended) {
        this.forced = forced;
        this.checkpointType = (CheckpointType)((Object)Preconditions.checkNotNull((Object)((Object)checkpointType)));
        this.discardSubsumed = discardSubsumed;
        this.discardFinished = discardFinished;
        this.discardCancelled = discardCancelled;
        this.discardFailed = discardFailed;
        this.discardSuspended = discardSuspended;
    }

    boolean forceCheckpoint() {
        return this.forced;
    }

    boolean discardOnSubsumed() {
        return this.discardSubsumed;
    }

    boolean discardOnJobFinished() {
        return this.discardFinished;
    }

    boolean discardOnJobCancelled() {
        return this.discardCancelled;
    }

    boolean discardOnJobFailed() {
        return this.discardFailed;
    }

    boolean discardOnJobSuspended() {
        return this.discardSuspended;
    }

    public CheckpointType getCheckpointType() {
        return this.checkpointType;
    }

    public boolean isSavepoint() {
        return this.checkpointType.isSavepoint();
    }

    public boolean isSynchronous() {
        return this.checkpointType.isSynchronous();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointProperties that = (CheckpointProperties)o;
        return this.forced == that.forced && this.checkpointType == that.checkpointType && this.discardSubsumed == that.discardSubsumed && this.discardFinished == that.discardFinished && this.discardCancelled == that.discardCancelled && this.discardFailed == that.discardFailed && this.discardSuspended == that.discardSuspended;
    }

    public int hashCode() {
        int result = this.forced ? 1 : 0;
        result = 31 * result + this.checkpointType.hashCode();
        result = 31 * result + (this.discardSubsumed ? 1 : 0);
        result = 31 * result + (this.discardFinished ? 1 : 0);
        result = 31 * result + (this.discardCancelled ? 1 : 0);
        result = 31 * result + (this.discardFailed ? 1 : 0);
        result = 31 * result + (this.discardSuspended ? 1 : 0);
        return result;
    }

    public String toString() {
        return "CheckpointProperties{forced=" + this.forced + ", checkpointType=" + (Object)((Object)this.checkpointType) + ", discardSubsumed=" + this.discardSubsumed + ", discardFinished=" + this.discardFinished + ", discardCancelled=" + this.discardCancelled + ", discardFailed=" + this.discardFailed + ", discardSuspended=" + this.discardSuspended + '}';
    }

    public static CheckpointProperties forSavepoint() {
        return SAVEPOINT;
    }

    public static CheckpointProperties forSyncSavepoint() {
        return SYNC_SAVEPOINT;
    }

    public static CheckpointProperties forCheckpoint(CheckpointRetentionPolicy policy) {
        switch (policy) {
            case NEVER_RETAIN_AFTER_TERMINATION: {
                return CHECKPOINT_NEVER_RETAINED;
            }
            case RETAIN_ON_FAILURE: {
                return CHECKPOINT_RETAINED_ON_FAILURE;
            }
            case RETAIN_ON_CANCELLATION: {
                return CHECKPOINT_RETAINED_ON_CANCELLATION;
            }
        }
        throw new IllegalArgumentException("unknown policy: " + (Object)((Object)policy));
    }
}

