/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializer;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV1Serializer;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV2Serializer;
import org.apache.flink.util.Preconditions;

public class SavepointSerializers {
    static boolean FAIL_WHEN_LEGACY_STATE_DETECTED = true;
    private static final Map<Integer, SavepointSerializer<?>> SERIALIZERS = new HashMap(2);

    private SavepointSerializers() {
        throw new AssertionError();
    }

    public static <T extends Savepoint> SavepointSerializer<T> getSerializer(T savepoint) {
        Preconditions.checkNotNull(savepoint, (String)"Savepoint");
        SavepointSerializer<?> serializer = SERIALIZERS.get(savepoint.getVersion());
        if (serializer != null) {
            return serializer;
        }
        throw new IllegalArgumentException("Unknown savepoint version " + savepoint.getVersion() + ".");
    }

    public static SavepointSerializer<?> getSerializer(int version) {
        SavepointSerializer<?> serializer = SERIALIZERS.get(version);
        if (serializer != null) {
            return serializer;
        }
        throw new IllegalArgumentException("Cannot restore savepoint version " + version + ".");
    }

    @VisibleForTesting
    public static void setFailWhenLegacyStateDetected(boolean fail) {
        FAIL_WHEN_LEGACY_STATE_DETECTED = fail;
    }

    static {
        SERIALIZERS.put(1, SavepointV1Serializer.INSTANCE);
        SERIALIZERS.put(2, SavepointV2Serializer.INSTANCE);
    }
}

