/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.dispatcher.ArchivedExecutionGraphStore;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.DispatcherFactory;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.HistoryServerArchivist;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponent;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.rest.RestEndpointFactory;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcherImpl;
import org.apache.flink.runtime.rest.handler.legacy.metrics.VoidMetricFetcher;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.WebMonitorEndpoint;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.runtime.webmonitor.retriever.impl.RpcGatewayRetriever;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDispatcherResourceManagerComponentFactory<T extends Dispatcher, U extends RestfulGateway>
implements DispatcherResourceManagerComponentFactory<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Nonnull
    private final DispatcherFactory<T> dispatcherFactory;
    @Nonnull
    private final ResourceManagerFactory<?> resourceManagerFactory;
    @Nonnull
    private final RestEndpointFactory<U> restEndpointFactory;

    public AbstractDispatcherResourceManagerComponentFactory(@Nonnull DispatcherFactory<T> dispatcherFactory, @Nonnull ResourceManagerFactory<?> resourceManagerFactory, @Nonnull RestEndpointFactory<U> restEndpointFactory) {
        this.dispatcherFactory = dispatcherFactory;
        this.resourceManagerFactory = resourceManagerFactory;
        this.restEndpointFactory = restEndpointFactory;
    }

    @Override
    public DispatcherResourceManagerComponent<T> create(Configuration configuration, Executor ioExecutor, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, BlobServer blobServer, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, ArchivedExecutionGraphStore archivedExecutionGraphStore, MetricQueryServiceRetriever metricQueryServiceRetriever, FatalErrorHandler fatalErrorHandler) throws Exception {
        LeaderRetrievalService dispatcherLeaderRetrievalService = null;
        LeaderRetrievalService resourceManagerRetrievalService = null;
        WebMonitorEndpoint<U> webMonitorEndpoint = null;
        ResourceManager<?> resourceManager = null;
        ComponentMetricGroup jobManagerMetricGroup = null;
        RpcEndpoint dispatcher = null;
        try {
            dispatcherLeaderRetrievalService = highAvailabilityServices.getDispatcherLeaderRetriever();
            resourceManagerRetrievalService = highAvailabilityServices.getResourceManagerLeaderRetriever();
            RpcGatewayRetriever<DispatcherId, DispatcherGateway> dispatcherGatewayRetriever = new RpcGatewayRetriever<DispatcherId, DispatcherGateway>(rpcService, DispatcherGateway.class, DispatcherId::fromUuid, 10, Time.milliseconds((long)50L));
            RpcGatewayRetriever<ResourceManagerId, ResourceManagerGateway> resourceManagerGatewayRetriever = new RpcGatewayRetriever<ResourceManagerId, ResourceManagerGateway>(rpcService, ResourceManagerGateway.class, ResourceManagerId::fromUuid, 10, Time.milliseconds((long)50L));
            ExecutorService executor = WebMonitorEndpoint.createExecutorService(configuration.getInteger(RestOptions.SERVER_NUM_THREADS), configuration.getInteger(RestOptions.SERVER_THREAD_PRIORITY), "DispatcherRestEndpoint");
            long updateInterval = configuration.getLong(MetricOptions.METRIC_FETCHER_UPDATE_INTERVAL);
            VoidMetricFetcher metricFetcher = updateInterval == 0L ? VoidMetricFetcher.INSTANCE : MetricFetcherImpl.fromConfiguration(configuration, metricQueryServiceRetriever, dispatcherGatewayRetriever, executor);
            webMonitorEndpoint = this.restEndpointFactory.createRestEndpoint(configuration, dispatcherGatewayRetriever, resourceManagerGatewayRetriever, blobServer, executor, metricFetcher, highAvailabilityServices.getWebMonitorLeaderElectionService(), fatalErrorHandler);
            this.log.debug("Starting Dispatcher REST endpoint.");
            webMonitorEndpoint.start();
            String hostname = this.getHostname(rpcService);
            jobManagerMetricGroup = MetricUtils.instantiateJobManagerMetricGroup(metricRegistry, hostname, ConfigurationUtils.getSystemResourceMetricsProbingInterval((Configuration)configuration));
            resourceManager = this.resourceManagerFactory.createResourceManager(configuration, ResourceID.generate(), rpcService, highAvailabilityServices, heartbeatServices, metricRegistry, fatalErrorHandler, new ClusterInformation(hostname, blobServer.getPort()), webMonitorEndpoint.getRestBaseUrl(), (JobManagerMetricGroup)jobManagerMetricGroup);
            HistoryServerArchivist historyServerArchivist = HistoryServerArchivist.createHistoryServerArchivist(configuration, webMonitorEndpoint, ioExecutor);
            dispatcher = this.dispatcherFactory.createDispatcher(configuration, rpcService, highAvailabilityServices, resourceManagerGatewayRetriever, blobServer, heartbeatServices, (JobManagerMetricGroup)jobManagerMetricGroup, metricRegistry.getMetricQueryServiceGatewayRpcAddress(), archivedExecutionGraphStore, fatalErrorHandler, historyServerArchivist);
            this.log.debug("Starting ResourceManager.");
            resourceManager.start();
            resourceManagerRetrievalService.start(resourceManagerGatewayRetriever);
            this.log.debug("Starting Dispatcher.");
            dispatcher.start();
            dispatcherLeaderRetrievalService.start(dispatcherGatewayRetriever);
            return this.createDispatcherResourceManagerComponent(dispatcher, resourceManager, dispatcherLeaderRetrievalService, resourceManagerRetrievalService, webMonitorEndpoint, (JobManagerMetricGroup)jobManagerMetricGroup);
        }
        catch (Exception exception) {
            if (dispatcherLeaderRetrievalService != null) {
                try {
                    dispatcherLeaderRetrievalService.stop();
                }
                catch (Exception e) {
                    exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
                }
            }
            if (resourceManagerRetrievalService != null) {
                try {
                    resourceManagerRetrievalService.stop();
                }
                catch (Exception e) {
                    exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
                }
            }
            ArrayList<CompletableFuture<Void>> terminationFutures = new ArrayList<CompletableFuture<Void>>(3);
            if (webMonitorEndpoint != null) {
                terminationFutures.add(webMonitorEndpoint.closeAsync());
            }
            if (resourceManager != null) {
                terminationFutures.add(resourceManager.closeAsync());
            }
            if (dispatcher != null) {
                terminationFutures.add(dispatcher.closeAsync());
            }
            FutureUtils.ConjunctFuture<Void> terminationFuture = FutureUtils.completeAll(terminationFutures);
            try {
                terminationFuture.get();
            }
            catch (Exception e) {
                exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
            }
            if (jobManagerMetricGroup != null) {
                jobManagerMetricGroup.close();
            }
            throw new FlinkException("Could not create the DispatcherResourceManagerComponent.", (Throwable)exception);
        }
    }

    protected String getHostname(RpcService rpcService) {
        String rpcServiceAddress = rpcService.getAddress();
        return rpcServiceAddress != null && rpcServiceAddress.isEmpty() ? "localhost" : rpcServiceAddress;
    }

    protected abstract DispatcherResourceManagerComponent<T> createDispatcherResourceManagerComponent(T var1, ResourceManager<?> var2, LeaderRetrievalService var3, LeaderRetrievalService var4, WebMonitorEndpoint<?> var5, JobManagerMetricGroup var6);
}

