/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.LeaderRetrievalHandler;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.handler.util.MimeTypes;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPromise;
import org.apache.flink.shaded.netty4.io.netty.channel.DefaultFileRegion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedFile;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedInput;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.apache.flink.util.Preconditions;

@ChannelHandler.Sharable
public class StaticFileServerHandler<T extends RestfulGateway>
extends LeaderRetrievalHandler<T> {
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final int HTTP_CACHE_SECONDS = 300;
    private final File rootPath;

    public StaticFileServerHandler(GatewayRetriever<? extends T> retriever, Time timeout, File rootPath) throws IOException {
        super(retriever, timeout, Collections.emptyMap());
        this.rootPath = ((File)Preconditions.checkNotNull((Object)rootPath)).getCanonicalFile();
    }

    @Override
    protected void respondAsLeader(ChannelHandlerContext channelHandlerContext, RoutedRequest routedRequest, T gateway) throws Exception {
        HttpRequest request = routedRequest.getRequest();
        String requestPath = routedRequest.getPath().endsWith("/") ? routedRequest.getPath() + "index.html" : (routedRequest.getPath().equals("/jobmanager/log") || routedRequest.getPath().equals("/jobmanager/stdout") ? "" : routedRequest.getPath());
        this.respondToRequest(channelHandlerContext, request, requestPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void respondToRequest(ChannelHandlerContext ctx, HttpRequest request, String requestPath) throws IOException, ParseException, URISyntaxException {
        block42: {
            file = new File(this.rootPath, requestPath);
            if (file.exists()) break block42;
            cl = StaticFileServerHandler.class.getClassLoader();
            resourceStream = cl.getResourceAsStream("web" + requestPath);
            var7_7 = null;
            try {
                success = false;
                try {
                    if (resourceStream != null) {
                        root = cl.getResource("web");
                        requested = cl.getResource("web" + requestPath);
                        if (root != null && requested != null && !(rootURI = new URI(root.getPath()).normalize()).relativize(requestedURI = new URI(requested.getPath()).normalize()).equals(requestedURI)) {
                            this.logger.debug("Loading missing file from classloader: {}", (Object)requestPath);
                            file.getParentFile().mkdirs();
                            Files.copy(resourceStream, file.toPath(), new CopyOption[0]);
                            success = true;
                        }
                    }
                    ** if (success) goto lbl-1000
                }
                catch (Throwable t) {
                    block43: {
                        block44: {
                            this.logger.error("error while responding", t);
                            if (success) break block42;
                            this.logger.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                            HandlerUtils.sendErrorResponse(ctx, request, new ErrorResponseBody(String.format("Unable to load requested file %s.", new Object[]{requestPath})), HttpResponseStatus.NOT_FOUND, (Map<String, String>)this.responseHeaders);
                            if (resourceStream == null) break block43;
                            if (var7_7 == null) break block44;
                            try {
                                resourceStream.close();
                            }
                            catch (Throwable t) {
                                var7_7.addSuppressed(t);
                            }
                            break block43;
                        }
                        resourceStream.close();
                    }
                    return;
                    {
                        catch (Throwable var13_23) {
                            block45: {
                                block46: {
                                    block47: {
                                        if (success) break block45;
                                        this.logger.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                                        HandlerUtils.sendErrorResponse(ctx, request, new ErrorResponseBody(String.format("Unable to load requested file %s.", new Object[]{requestPath})), HttpResponseStatus.NOT_FOUND, (Map<String, String>)this.responseHeaders);
                                        if (resourceStream == null) break block46;
                                        if (var7_7 == null) break block47;
                                        try {
                                            resourceStream.close();
                                        }
                                        catch (Throwable var14_24) {
                                            var7_7.addSuppressed(var14_24);
                                        }
                                        break block46;
                                    }
                                    resourceStream.close();
                                }
                                return;
                            }
                            try {
                                throw var13_23;
                            }
                            catch (Throwable success) {
                                var7_7 = success;
                                throw success;
                            }
                            catch (Throwable var15_25) {
                                throw var15_25;
                            }
                        }
                    }
                }
lbl-1000:
                // 1 sources

                {
                    this.logger.debug("Unable to load requested file {} from classloader", (Object)requestPath);
                    HandlerUtils.sendErrorResponse(ctx, request, new ErrorResponseBody(String.format("Unable to load requested file %s.", new Object[]{requestPath})), HttpResponseStatus.NOT_FOUND, (Map<String, String>)this.responseHeaders);
                    return;
                }
lbl-1000:
                // 1 sources

                {
                }
            }
            finally {
                if (resourceStream != null) {
                    if (var7_7 != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable root) {
                            var7_7.addSuppressed(root);
                        }
                    } else {
                        resourceStream.close();
                    }
                }
            }
        }
        if (!file.exists() || file.isHidden() || file.isDirectory() || !file.isFile()) {
            HandlerUtils.sendErrorResponse(ctx, request, new ErrorResponseBody("File not found."), HttpResponseStatus.NOT_FOUND, (Map<String, String>)this.responseHeaders);
            return;
        }
        if (!file.getCanonicalFile().toPath().startsWith(this.rootPath.toPath())) {
            HandlerUtils.sendErrorResponse(ctx, request, new ErrorResponseBody("File not found."), HttpResponseStatus.NOT_FOUND, (Map<String, String>)this.responseHeaders);
            return;
        }
        ifModifiedSince = request.headers().get("If-Modified-Since");
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Responding 'NOT MODIFIED' for file '" + file.getAbsolutePath() + '\'');
            }
            StaticFileServerHandler.sendNotModified(ctx);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Responding with file '" + file.getAbsolutePath() + '\'');
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            HandlerUtils.sendErrorResponse(ctx, request, new ErrorResponseBody("File not found."), HttpResponseStatus.NOT_FOUND, (Map<String, String>)this.responseHeaders);
            return;
        }
        try {
            fileLength = raf.length();
            response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            StaticFileServerHandler.setContentTypeHeader((HttpResponse)response, file);
            if (!requestPath.contains("log") && !requestPath.contains("out")) {
                StaticFileServerHandler.setDateAndCacheHeaders((HttpResponse)response, file);
            }
            if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
                response.headers().set("Connection", (Object)"keep-alive");
            }
            HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
            ctx.write((Object)response);
            if (ctx.pipeline().get(SslHandler.class) == null) {
                ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
                lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                lastContentFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
            }
            if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception e) {
            raf.close();
            this.logger.error("Failed to serve file.", (Throwable)e);
            HandlerUtils.sendErrorResponse(ctx, request, new ErrorResponseBody("Internal server error."), HttpResponseStatus.INTERNAL_SERVER_ERROR, (Map<String, String>)this.responseHeaders);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ctx.channel().isActive()) {
            this.logger.error("Caught exception", cause);
            HandlerUtils.sendErrorResponse(ctx, false, new ErrorResponseBody("Internal server error."), HttpResponseStatus.INTERNAL_SERVER_ERROR, Collections.emptyMap());
        }
    }

    public static void sendNotModified(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        StaticFileServerHandler.setDateHeader((FullHttpResponse)response);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static void setDateHeader(FullHttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
    }

    public static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(GMT_TIMEZONE);
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 300);
        response.headers().set("Expires", (Object)dateFormatter.format(time.getTime()));
        response.headers().set("Cache-Control", (Object)"private, max-age=300");
        response.headers().set("Last-Modified", (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    public static void setContentTypeHeader(HttpResponse response, File file) {
        String mimeType = MimeTypes.getMimeTypeForFileName(file.getName());
        String mimeFinal = mimeType != null ? mimeType : MimeTypes.getDefaultMimeType();
        response.headers().set("Content-Type", (Object)mimeFinal);
    }
}

